/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.laslib.LAScriterion;
import com.github.mreutegg.laszip4j.laszip.LASpoint;

class LAScriterionDropy
extends LAScriterion {
    private double below_y;
    private double above_y;

    @Override
    public String name() {
        return "drop_y";
    }

    @Override
    public int get_command(StringBuilder string) {
        return Cstdio.sprintf(string, "-%s %g %g ", this.name(), this.below_y, this.above_y);
    }

    @Override
    public boolean filter(LASpoint point) {
        double y = point.get_y();
        return this.below_y <= y && y < this.above_y;
    }

    public LAScriterionDropy(double below_y, double above_y) {
        this.below_y = below_y;
        this.above_y = above_y;
    }
}

