/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.laslib.LAScriterion;
import com.github.mreutegg.laszip4j.laszip.LASpoint;

class LAScriterionKeepReturns
extends LAScriterion {
    private int drop_return_mask;

    @Override
    public String name() {
        return "keep_return_mask";
    }

    @Override
    public int get_command(StringBuilder string) {
        return Cstdio.sprintf(string, "-%s %d ", this.name(), ~this.drop_return_mask);
    }

    @Override
    public boolean filter(LASpoint point) {
        return (1 << point.getReturn_number() & this.drop_return_mask) != 0;
    }

    LAScriterionKeepReturns(int keep_return_mask) {
        this.drop_return_mask = ~keep_return_mask;
    }
}

