/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

public class ArithmeticBitModel {
    private static final int BM__LengthShift = 13;
    private static final int BM__MaxCount = 8192;
    int u_update_cycle;
    int u_bits_until_update;
    int u_bit_0_prob;
    int u_bit_0_count;
    int u_bit_count;

    public ArithmeticBitModel() {
        this.init();
    }

    void init() {
        this.u_bit_0_count = 1;
        this.u_bit_count = 2;
        this.u_bit_0_prob = 4096;
        this.u_bits_until_update = 4;
        this.u_update_cycle = 4;
    }

    void update() {
        if ((this.u_bit_count += this.u_update_cycle) > 8192) {
            this.u_bit_count = this.u_bit_count + 1 >>> 1;
            this.u_bit_0_count = this.u_bit_0_count + 1 >>> 1;
            if (this.u_bit_0_count == this.u_bit_count) {
                ++this.u_bit_count;
            }
        }
        int scale = Integer.divideUnsigned(Integer.MIN_VALUE, this.u_bit_count);
        this.u_bit_0_prob = this.u_bit_0_count * scale >>> 18;
        this.u_update_cycle = 5 * this.u_update_cycle >>> 2;
        if (this.u_update_cycle > 64) {
            this.u_update_cycle = 64;
        }
        this.u_bits_until_update = this.u_update_cycle;
    }
}

