/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gis.las;

import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;

public final class GpsTimeConverter {
    private static final short[][] leapSeconds = new short[][]{{1980, 0, 0}, {1981, 1, 0}, {1982, 1, 0}, {1983, 1, 0}, {1984, 0, 0}, {1985, 1, 0}, {1986, 0, 0}, {1987, 0, 1}, {1988, 0, 0}, {1989, 0, 1}, {1990, 0, 1}, {1991, 0, 0}, {1992, 1, 0}, {1993, 1, 0}, {1994, 1, 0}, {1995, 0, 1}, {1996, 0, 0}, {1997, 1, 0}, {1998, 0, 1}, {1999, 0, 0}, {2000, 0, 0}, {2001, 0, 0}, {2002, 0, 0}, {2003, 0, 0}, {2004, 0, 0}, {2005, 0, 1}, {2006, 0, 0}, {2007, 0, 0}, {2008, 0, 1}, {2009, 0, 0}, {2010, 0, 0}, {2011, 0, 0}, {2012, 1, 0}, {2013, 0, 0}, {2014, 0, 0}, {2015, 1, 0}, {2016, 0, 0}};
    private static final long[] linearTime;
    private static final long[] javaTime;

    private GpsTimeConverter() {
    }

    public static long gpsToMillis(double gpsTime) {
        if (gpsTime < 0.0) {
            return (long)((double)javaTime[0] - gpsTime * 1000.0);
        }
        long target = (long)gpsTime;
        long ms = (long)((gpsTime - Math.floor(gpsTime)) * 1000.0);
        if (target > linearTime[linearTime.length - 1]) {
            long deltaSec = target - linearTime[linearTime.length - 1];
            return javaTime[javaTime.length - 1] + deltaSec * 1000L + ms;
        }
        int index = Arrays.binarySearch(linearTime, target);
        if (index < 0) {
            int i = -index - 1;
            long deltaSec = target - linearTime[i];
            return javaTime[i] + deltaSec * 1000L + ms;
        }
        return javaTime[index] + ms;
    }

    public static Date gpsToDate(double gpsTime) {
        long t = GpsTimeConverter.gpsToMillis(gpsTime);
        return new Date(t);
    }

    static {
        int nTimeFixes = 0;
        for (int i = 0; i < leapSeconds.length; ++i) {
            if (leapSeconds[i][1] != 0) {
                nTimeFixes += 2;
            }
            if (leapSeconds[i][2] == 0) continue;
            nTimeFixes += 2;
        }
        linearTime = new long[nTimeFixes + 1];
        javaTime = new long[nTimeFixes + 1];
        GregorianCalendar c = new GregorianCalendar(new SimpleTimeZone(0, "UTC"));
        c.clear();
        c.set(1980, 0, 6, 0, 0, 0);
        long priorTimestamp = c.getTimeInMillis() / 1000L;
        int iAdjustment = 0;
        GpsTimeConverter.linearTime[iAdjustment] = 0L;
        GpsTimeConverter.javaTime[iAdjustment] = priorTimestamp * 1000L;
        ++iAdjustment;
        long gpsOffset = 0L;
        for (int i = 1; i < leapSeconds.length; ++i) {
            for (int j = 1; j < 3; ++j) {
                if (leapSeconds[i][j] == 0) continue;
                c.clear();
                if (j == 1) {
                    c.set(i + 1980, 6, 1, 0, 0, 0);
                } else {
                    c.set(i + 1981, 0, 1, 0, 0, 0);
                }
                long timestamp = c.getTimeInMillis() / 1000L;
                long delta = timestamp - priorTimestamp;
                gpsOffset += delta;
                GpsTimeConverter.linearTime[iAdjustment] = gpsOffset++;
                GpsTimeConverter.javaTime[iAdjustment] = timestamp * 1000L;
                GpsTimeConverter.linearTime[++iAdjustment] = gpsOffset;
                GpsTimeConverter.javaTime[iAdjustment] = timestamp * 1000L;
                ++iAdjustment;
                priorTimestamp = timestamp;
            }
        }
    }
}

