/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gis.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.tinfour.common.IMonitorWithCancellation;
import org.tinfour.common.Vertex;
import org.tinfour.gis.shapefile.DbfField;
import org.tinfour.gis.shapefile.DbfFileReader;
import org.tinfour.gis.shapefile.ShapefileReader;
import org.tinfour.gis.shapefile.ShapefileRecord;
import org.tinfour.gis.utils.IVerticalCoordinateTransform;
import org.tinfour.utils.LinearUnits;
import org.tinfour.utils.loaders.CoordinatePair;
import org.tinfour.utils.loaders.ICoordinateTransform;
import org.tinfour.utils.loaders.IVertexReader;
import org.tinfour.utils.loaders.SimpleGeographicTransform;

public class VertexReaderShapefile
implements IVertexReader,
Closeable {
    final File file;
    final String rootPath;
    ShapefileReader reader;
    double xMin;
    double xMax;
    double yMin;
    double yMax;
    double zMin;
    double zMax;
    double timeForLoad;
    boolean geographicCoordinates;
    LinearUnits linearUnits = LinearUnits.UNKNOWN;
    ICoordinateTransform coordinateTransform;
    IVerticalCoordinateTransform verticalCoordinateTransform;
    String dbfFieldForZ;

    public VertexReaderShapefile(File file) throws IOException {
        this.file = file;
        String testExt = null;
        String path = file.getPath();
        int lastPeriod = path.lastIndexOf(46);
        if (lastPeriod > 0) {
            testExt = path.substring(lastPeriod + 1, path.length());
        }
        if (!"shp".equalsIgnoreCase(testExt)) {
            throw new IllegalArgumentException("File must be of type .shp");
        }
        this.rootPath = path.substring(0, lastPeriod);
        this.reader = this.openFile(file);
    }

    public void setDbfFieldForZ(String dbfFieldForZ) {
        if (dbfFieldForZ != null) {
            this.dbfFieldForZ = dbfFieldForZ.trim();
            if (this.dbfFieldForZ.isEmpty()) {
                this.dbfFieldForZ = null;
            }
        } else {
            this.dbfFieldForZ = null;
        }
    }

    public void setVerticalCoordinateTransform(IVerticalCoordinateTransform verticalTransform) {
        this.verticalCoordinateTransform = verticalTransform;
    }

    @Override
    public double getXMin() {
        return this.xMin;
    }

    @Override
    public double getXMax() {
        return this.xMax;
    }

    @Override
    public double getYMin() {
        return this.yMin;
    }

    @Override
    public double getYMax() {
        return this.yMax;
    }

    @Override
    public double getZMin() {
        return this.zMin;
    }

    @Override
    public double getZMax() {
        return this.zMax;
    }

    public double getTimeForLoad() {
        return this.timeForLoad;
    }

    @Override
    public boolean isSourceInGeographicCoordinates() {
        return this.geographicCoordinates;
    }

    @Override
    public List<Vertex> read(IMonitorWithCancellation monitor) throws IOException {
        double mainFileSize = 0.0;
        if (monitor != null) {
            mainFileSize = this.reader.getFileSize();
        }
        DbfFileReader dbfReader = null;
        DbfField zField = null;
        boolean useShapefileZ = true;
        CoordinatePair scratch = new CoordinatePair();
        if (this.dbfFieldForZ != null) {
            File dbfFile = this.reader.getCoFile("DBF");
            dbfReader = this.reader.getDbfFileReader();
            zField = dbfReader.getFieldByName(this.dbfFieldForZ);
            if (zField == null) {
                try {
                    dbfReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new IllegalArgumentException("The specified field " + this.dbfFieldForZ + " was not found in " + dbfFile.getName());
            }
            if (!zField.isNumeric()) {
                try {
                    dbfReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new IllegalArgumentException("The specified field " + this.dbfFieldForZ + " is not numeric in" + dbfFile.getName());
            }
            useShapefileZ = false;
        }
        ArrayList<Vertex> vList = new ArrayList<Vertex>();
        ShapefileRecord record = null;
        this.xMin = Double.POSITIVE_INFINITY;
        this.yMin = Double.POSITIVE_INFINITY;
        this.zMin = Double.POSITIVE_INFINITY;
        this.xMax = Double.NEGATIVE_INFINITY;
        this.yMax = Double.NEGATIVE_INFINITY;
        this.zMax = Double.NEGATIVE_INFINITY;
        int nRecordsRead = 0;
        while (this.reader.hasNext()) {
            if (monitor != null && mainFileSize > 0.0 && nRecordsRead % 1000 == 0) {
                double filePos = this.reader.getFilePosition();
                monitor.reportProgress((int)(100.0 * filePos / mainFileSize));
            }
            record = this.reader.readNextRecord(record);
            int recNo = record.recordNumber;
            double[] xyz = record.xyz;
            double z = 0.0;
            if (dbfReader != null && zField != null) {
                dbfReader.readField(recNo, zField);
                z = zField.getDouble();
            }
            for (int i = 0; i < record.nPoints; ++i) {
                int index = i * 3;
                double x = xyz[index];
                double y = xyz[index + 1];
                if (useShapefileZ) {
                    z = xyz[index + 2];
                }
                if (this.coordinateTransform != null) {
                    boolean status = this.coordinateTransform.forward(x, y, scratch);
                    if (!status) {
                        throw new IOException("Invalid transformation for coordinates in record " + recNo + ": " + x + "," + y);
                    }
                    x = scratch.x;
                    y = scratch.y;
                }
                if (this.verticalCoordinateTransform != null) {
                    z = this.verticalCoordinateTransform.transform(recNo, z);
                }
                vList.add(new Vertex(x, y, z, recNo));
                if (x < this.xMin) {
                    this.xMin = x;
                }
                if (y < this.yMin) {
                    this.yMin = y;
                }
                if (z < this.zMin) {
                    this.zMin = z;
                }
                if (x > this.xMax) {
                    this.xMax = x;
                }
                if (y > this.yMax) {
                    this.yMax = y;
                }
                if (!(z > this.zMax)) continue;
                this.zMax = z;
            }
        }
        if (dbfReader != null) {
            dbfReader.close();
        }
        return vList;
    }

    private ShapefileReader openFile(File file) throws IOException, IllegalArgumentException {
        File target = file;
        ShapefileReader reader = new ShapefileReader(target);
        try {
            this.checkForGeographicCoordinates(reader);
        }
        catch (IOException ioex) {
            try {
                if (reader != null) {
                    reader.close();
                    reader = null;
                }
                throw ioex;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return reader;
    }

    private void checkForGeographicCoordinates(ShapefileReader reader) throws IOException {
        File target = reader.getCoFile("prj");
        if (target != null) {
            try (FileInputStream fins2 = new FileInputStream(target);){
                int indexUnit;
                int n;
                StringBuilder sb = new StringBuilder();
                byte[] buffer = new byte[8192];
                while ((n = fins2.read(buffer)) > 0) {
                    for (int i = 0; i < n; ++i) {
                        sb.append((char)buffer[i]);
                    }
                }
                String content = sb.toString().toUpperCase();
                int indexPROJ = content.indexOf("PROJ");
                if (indexPROJ >= 0) {
                    return;
                }
                int indexGEOCS = content.indexOf("GEOCS");
                if (indexGEOCS > 0) {
                    this.geographicCoordinates = true;
                }
                if ((indexUnit = content.indexOf("UNIT")) > 0 && (content.indexOf("FOOT") > indexUnit || content.indexOf("FEET") > indexUnit)) {
                    this.linearUnits = LinearUnits.FEET;
                }
            }
            catch (IOException fins2) {
                // empty catch block
            }
        }
        double x0 = reader.getMinX();
        double y0 = reader.getMinY();
        double x1 = reader.getMaxX();
        double y1 = reader.getMaxY();
        double dx = x1 - x0;
        double dy = y1 - y0;
        boolean bl = this.geographicCoordinates = dx <= 360.0 && dy < 90.0 && -180.0 <= x0 && x1 < 180.0 && -90.0 <= y0 && y1 <= 90.0;
        if (this.geographicCoordinates) {
            double xCenter = (x0 + x1) / 2.0;
            double yCenter = (y0 + y1) / 2.0;
            this.coordinateTransform = new SimpleGeographicTransform(yCenter, xCenter, this.linearUnits);
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public ICoordinateTransform getCoordinateTransform() {
        return this.coordinateTransform;
    }

    @Override
    public void setCoordinateTransform(ICoordinateTransform transform) {
        this.coordinateTransform = transform;
        this.geographicCoordinates = transform instanceof SimpleGeographicTransform;
    }

    public LinearUnits getLinearUnits() {
        return this.linearUnits;
    }
}

