/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.semivirtual;

import java.util.Arrays;
import org.tinfour.common.Vertex;

class SemiVirtualEdgePage {
    static final int PAIRS_PER_PAGE_SCALE = 10;
    static final int PAIRS_PER_PAGE = 1024;
    static final int INDICES_PER_PAGE = 2048;
    static final int INDEX_MASK = 2047;
    static final int MASK_LOW_BIT_CLEAR = -2;
    int pageID;
    int pageOffset;
    int nPairsAllocated;
    final Vertex[] vertices;
    final int[] links;
    short[] freePairs;
    int[] constraints;
    int[] synthetic;
    SemiVirtualEdgePage nextPage;

    SemiVirtualEdgePage(int pageID) {
        this.pageID = pageID;
        this.pageOffset = pageID * 2048;
        this.vertices = new Vertex[2048];
        this.links = new int[4096];
    }

    void clear() {
        this.nPairsAllocated = 0;
        this.freePairs = null;
        this.constraints = null;
        Arrays.fill(this.vertices, 0, this.vertices.length, null);
        Arrays.fill(this.links, 0, this.links.length, 0);
    }

    void dispose() {
        for (int i = 0; i < 2048; ++i) {
            this.vertices[i] = null;
        }
        this.nPairsAllocated = 0;
        this.freePairs = null;
        this.constraints = null;
    }

    int allocateEdge(Vertex a, Vertex b) {
        int index;
        if (this.freePairs == null) {
            index = this.nPairsAllocated++;
        } else {
            ++this.nPairsAllocated;
            int iLastFree = 1024 - this.nPairsAllocated;
            index = this.freePairs[iLastFree];
        }
        this.vertices[index *= 2] = a;
        this.vertices[index + 1] = b;
        return this.pageOffset + index;
    }

    void deallocateEdge(int absIndex) {
        int index;
        int offset = index = absIndex & 0x7FE;
        this.vertices[offset] = null;
        this.vertices[offset + 1] = null;
        this.links[offset *= 2] = 0;
        this.links[offset + 1] = 0;
        this.links[offset + 2] = 0;
        this.links[offset + 3] = 0;
        if (this.nPairsAllocated == 1) {
            this.freePairs = null;
        } else {
            if (this.freePairs == null) {
                this.freePairs = new short[1024];
                for (int i = this.nPairsAllocated; i < 1024; ++i) {
                    this.freePairs[i - this.nPairsAllocated] = (short)i;
                }
            }
            this.freePairs[1024 - this.nPairsAllocated] = (short)(index / 2);
        }
        if (this.constraints != null) {
            this.constraints[index / 2] = 0;
        }
        --this.nPairsAllocated;
    }

    boolean isFullyAllocated() {
        return this.nPairsAllocated == 1024;
    }

    int[] getAllocations() {
        int[] allocations = new int[this.nPairsAllocated];
        if (this.nPairsAllocated == 0) {
            return allocations;
        }
        if (this.freePairs == null) {
            for (int i = 0; i < this.nPairsAllocated; ++i) {
                allocations[i] = this.pageOffset + i * 2;
            }
        } else {
            boolean[] isPairInFreeList = new boolean[1024];
            int nFreePairs = 1024 - this.nPairsAllocated;
            for (int i = 0; i < nFreePairs; ++i) {
                isPairInFreeList[this.freePairs[i]] = true;
            }
            int k = 0;
            for (int i = 0; i < 1024; ++i) {
                if (isPairInFreeList[i]) continue;
                allocations[k++] = this.pageOffset + i * 2;
            }
        }
        return allocations;
    }

    int[] readyConstraints() {
        if (this.constraints == null) {
            this.constraints = new int[1024];
        }
        return this.constraints;
    }

    int[] readySynthetic() {
        if (this.synthetic == null) {
            this.synthetic = new int[32];
        }
        return this.synthetic;
    }
}

