/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.svm.properties;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.tinfour.svm.properties.SvmFileSpecification;
import org.tinfour.svm.properties.SvmUnitSpecification;

public class SvmProperties {
    private static final String unitOfDistanceKey = "unitOfDistance";
    private static final String unitOfAreaKey = "unitOfArea";
    private static final String unitOfVolumeKey = "unitOfVolume";
    private static final String reportKey = "report";
    private static final String shorelineReferenceElevationKey = "shorelineReferenceElevation";
    private static final String tableKey = "table";
    private static final String tableIntervalKey = "tableInterval";
    private static final String flatFixerKey = "remediateFlatTriangles";
    private static final String soundingSpacingKey = "computeSoundingSpacing";
    private static final String inputFolderKey = "inputFolder";
    private static final String outputFolderKey = "outputFolder";
    private static final String gridFileName = "rasterFileName";
    private static final String gridCellSize = "rasterCellSize";
    final Properties properties = new Properties();
    final List<String> keyList = new ArrayList<String>();
    private File specificationFile;
    private SvmUnitSpecification unitOfDistance = new SvmUnitSpecification("Distance", "m", 1.0);
    private SvmUnitSpecification unitOfArea = new SvmUnitSpecification("Area", "m^2", 1.0);
    private SvmUnitSpecification unitOfVolume = new SvmUnitSpecification("Volume", "m^3", 1.0);

    public static int indexArg(String[] args, String target, boolean valueRequired) {
        if (args == null || target == null || target.isEmpty()) {
            return -1;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!target.equalsIgnoreCase(args[i])) continue;
            if (valueRequired) {
                if (i == args.length - 1 || args[i + 1].isEmpty()) {
                    throw new IllegalArgumentException("Missing value for option " + target);
                }
                String s = args[i + 1];
                if (s.charAt(0) == '-' && s.length() > 1 && !Character.isDigit(s.charAt(1))) {
                    throw new IllegalArgumentException("Missing value for option " + target);
                }
            }
            return i;
        }
        return -1;
    }

    private static String findArgString(String[] args, String target) {
        int index = SvmProperties.indexArg(args, target, true);
        if (index >= 0) {
            return args[index + 1];
        }
        return null;
    }

    public static SvmProperties load(String[] args) throws IOException {
        String s = SvmProperties.findArgString(args, "-properties");
        if (s == null) {
            String test;
            int i;
            if (args.length == 1 && (i = (test = args[0].toLowerCase()).lastIndexOf(".properties")) == test.length() - 11) {
                s = args[0];
            }
            if (s == null) {
                throw new IllegalArgumentException("Missing properties file specification");
            }
        }
        File file = new File(s);
        SvmProperties p = new SvmProperties();
        p.load(file);
        return p;
    }

    public void load(File file) throws IOException {
        this.specificationFile = file;
        FileInputStream fins = new FileInputStream(file);
        Object object = null;
        try (BufferedInputStream bins2 = new BufferedInputStream(fins);){
            this.properties.load(bins2);
        }
        catch (Throwable bins2) {
            object = bins2;
            throw bins2;
        }
        finally {
            if (fins != null) {
                if (object != null) {
                    try {
                        fins.close();
                    }
                    catch (Throwable bins2) {
                        ((Throwable)object).addSuppressed(bins2);
                    }
                } else {
                    fins.close();
                }
            }
        }
        Set<String> nset = this.properties.stringPropertyNames();
        for (String s : nset) {
            this.keyList.add(s);
        }
        Collections.sort(this.keyList);
        this.unitOfDistance = this.extractUnit("Distance", unitOfDistanceKey, this.unitOfDistance);
        this.unitOfArea = this.extractUnit("Area", unitOfAreaKey, this.getUnitOfArea());
        this.unitOfVolume = this.extractUnit("Volume", unitOfVolumeKey, this.getUnitOfVolume());
    }

    public List<SvmFileSpecification> getSampleSpecifications() {
        return this.getTargetSpecifications("samples");
    }

    public List<SvmFileSpecification> getSupplementSpecifications() {
        return this.getTargetSpecifications("supplement");
    }

    public List<SvmFileSpecification> getBoundarySpecifications() {
        return this.getTargetSpecifications("bounds");
    }

    public SvmUnitSpecification getUnitOfDistance() {
        return this.unitOfDistance;
    }

    private SvmUnitSpecification extractUnit(String name, String key, SvmUnitSpecification defaultUnit) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            return defaultUnit;
        }
        List<String> splitList = this.split(value);
        if (splitList.isEmpty()) {
            throw new IllegalArgumentException("Missing specification for " + key);
        }
        String label = splitList.get(0);
        double scaleFactor = 1.0;
        if (splitList.size() > 1) {
            try {
                scaleFactor = Double.parseDouble(splitList.get(1));
            }
            catch (NumberFormatException nex) {
                throw new IllegalArgumentException("Invalid specification for " + key);
            }
            if (scaleFactor == 0.0) {
                throw new IllegalArgumentException("Zero scaling factor not allowed for " + key);
            }
        }
        return new SvmUnitSpecification(name, label, scaleFactor);
    }

    private File extractFile(String folderKey, String property) {
        if (property == null || property.isEmpty()) {
            return null;
        }
        File f = new File(property);
        File folder = this.getFolderForKey(folderKey);
        if (folder != null && !f.isAbsolute()) {
            return new File(folder, property);
        }
        return f;
    }

    private List<SvmFileSpecification> getTargetSpecifications(String target) {
        File folder = this.getInputFolder();
        ArrayList<SvmFileSpecification> specList = new ArrayList<SvmFileSpecification>();
        for (String key : this.keyList) {
            if (!key.startsWith(target)) continue;
            String value = this.properties.getProperty(key);
            List<String> splitList = this.split(value);
            specList.add(new SvmFileSpecification(key, splitList, folder));
        }
        return specList;
    }

    private List<String> split(String value) {
        ArrayList<String> splitList = new ArrayList<String>();
        if (value == null || value.isEmpty()) {
            return splitList;
        }
        StringBuilder sb = new StringBuilder();
        boolean spacePending = false;
        boolean spaceEnable = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isWhitespace(c)) {
                if (spaceEnable) {
                    spacePending = true;
                }
                spaceEnable = false;
                continue;
            }
            if (c == '|') {
                String s = sb.toString();
                sb.setLength(0);
                splitList.add(s);
                spaceEnable = false;
                spacePending = false;
                continue;
            }
            if (spacePending) {
                sb.append(' ');
                spacePending = false;
            }
            spaceEnable = true;
            sb.append(c);
        }
        if (sb.length() > 0) {
            splitList.add(sb.toString());
        }
        return splitList;
    }

    public File getInputFolder() {
        return this.getFolderForKey(inputFolderKey);
    }

    public File getOutputFolder() {
        return this.getFolderForKey(outputFolderKey);
    }

    private File getFolderForKey(String key) {
        String s = this.properties.getProperty(key);
        if (s == null) {
            return null;
        }
        return new File(s);
    }

    public File getReportFile() {
        return this.extractFile(outputFolderKey, this.properties.getProperty(reportKey));
    }

    public File getTableFile() {
        return this.extractFile(outputFolderKey, this.properties.getProperty(tableKey));
    }

    public double getTableInterval() {
        String s = this.properties.getProperty(tableIntervalKey, "1.0");
        try {
            double d = Double.parseDouble(s);
            if (d <= 0.0) {
                throw new IllegalArgumentException("Invalid value for table interval: " + s);
            }
            return d;
        }
        catch (NumberFormatException nex) {
            throw new IllegalArgumentException("Invalid numeric for table interval: " + s);
        }
    }

    public boolean isFlatFixerEnabled() {
        String s = this.properties.getProperty(flatFixerKey, "false");
        boolean test = Boolean.parseBoolean(s.trim());
        return test;
    }

    public boolean isSoundingSpacingEnabled() {
        String s = this.properties.getProperty(soundingSpacingKey, "false");
        boolean test = Boolean.parseBoolean(s.trim());
        return test;
    }

    private int findMaxNameLength(int m0, List<SvmFileSpecification> samples) {
        int m = m0;
        for (SvmFileSpecification sample : samples) {
            String path = sample.file.getName();
            if (path.length() <= m) continue;
            m = path.length();
        }
        return m;
    }

    private void writeFileList(PrintStream ps, List<SvmFileSpecification> samples, String nameFmt) {
        if (samples.size() == 0) {
            ps.println("   None");
        } else {
            for (int i = 0; i < samples.size(); ++i) {
                SvmFileSpecification sample = samples.get(i);
                String name = sample.file.getName();
                ps.format(nameFmt, i + 1, name);
                if (sample.field == null) {
                    ps.format("%n", new Object[0]);
                    continue;
                }
                ps.format("   (%s)%n", sample.field);
            }
        }
    }

    private void writeUnit(PrintStream ps, String name, SvmUnitSpecification s) {
        double f = s.getScaleFactor();
        String fStr = "";
        if (f != 1.0) {
            fStr = f - Math.floor(1.0E-5) == 0.0 ? String.format("   %8d", (long)f) : String.format("   %11.3f", f);
        }
        ps.format("   %-12s%-12s%s%n", name, s.getLabel(), fStr);
    }

    public void writeSummary(PrintStream ps) {
        ps.format("Specifications for processing%n", new Object[0]);
        if (this.specificationFile != null) {
            ps.format("Properties file: %s%n", this.specificationFile.getPath());
        }
        File f = this.getInputFolder();
        ps.format("Input folder:   %s%n", f == null ? "Not specified" : f.getPath());
        f = this.getOutputFolder();
        ps.format("Output folder:  %s%n", f == null ? "Not specified" : f.getPath());
        ps.format("%n", new Object[0]);
        List<SvmFileSpecification> samples = this.getSampleSpecifications();
        List<SvmFileSpecification> bounds = this.getBoundarySpecifications();
        List<SvmFileSpecification> supplements = this.getSupplementSpecifications();
        int m = this.findMaxNameLength(0, samples);
        m = this.findMaxNameLength(m, bounds);
        String nameFmt = "   %2d. %-" + m + "s";
        ps.format("Sample Files:%n", new Object[0]);
        this.writeFileList(ps, samples, nameFmt);
        ps.format("Boundry Files:%n", new Object[0]);
        this.writeFileList(ps, bounds, nameFmt);
        ps.format("Supplemental Sample Files:%n", new Object[0]);
        this.writeFileList(ps, supplements, nameFmt);
        ps.format("%nUnits of Measure%n", new Object[0]);
        this.writeUnit(ps, "Distance", this.unitOfDistance);
        this.writeUnit(ps, "Area:", this.getUnitOfArea());
        this.writeUnit(ps, "Volume:", this.getUnitOfVolume());
        ps.println("");
        String s = this.properties.getProperty(reportKey);
        ps.format("Report:                   %s%n", s == null || s.isEmpty() ? "None" : s);
        s = this.properties.getProperty(tableKey);
        ps.format("Table output:             %s%n", s == null || s.isEmpty() ? "None" : s);
        if (s != null && !s.isEmpty()) {
            ps.format("Table interval:           %4.2f%n", this.getTableInterval());
        }
        s = this.properties.getProperty(shorelineReferenceElevationKey);
        ps.format("Shoreline Elevation:      ", new Object[0]);
        if (s == null || s.isEmpty()) {
            ps.format("To be obtained from boundary data", new Object[0]);
        } else {
            ps.format("Explicitly specified as " + s, new Object[0]);
        }
        ps.format("%n", new Object[0]);
        boolean fixFlats = this.isFlatFixerEnabled();
        ps.format("Remediate Flat Triangles: %s%n", Boolean.toString(fixFlats));
    }

    public SvmUnitSpecification getUnitOfArea() {
        return this.unitOfArea;
    }

    public SvmUnitSpecification getUnitOfVolume() {
        return this.unitOfVolume;
    }

    public double getShorelineReferenceElevation() {
        String s = this.properties.getProperty(shorelineReferenceElevationKey);
        if (s == null) {
            return Double.NaN;
        }
        if ((s = s.trim()).isEmpty()) {
            return Double.NaN;
        }
        try {
            double d = Double.parseDouble(s);
            if (d <= 0.0) {
                throw new IllegalArgumentException("Invalid value for shoreline reference elevation: " + s);
            }
            return d;
        }
        catch (NumberFormatException nex) {
            throw new IllegalArgumentException("Invalid numeric for shoreline reference elevation: " + s);
        }
    }

    public double getGridCellSize() {
        String s = this.properties.getProperty(gridCellSize);
        if (s == null) {
            return Double.NaN;
        }
        if ((s = s.trim()).isEmpty()) {
            return Double.NaN;
        }
        try {
            double d = Double.parseDouble(s);
            if (d <= 0.0) {
                throw new IllegalArgumentException("Invalid value for grid cell size: " + s);
            }
            return d;
        }
        catch (NumberFormatException nex) {
            throw new IllegalArgumentException("Invalid numeric for gridCellSize: " + s);
        }
    }

    public File getGridFile() {
        return this.extractFile(outputFolderKey, this.properties.getProperty(gridFileName));
    }
}

