/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.common;

import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.List;
import org.tinfour.common.IConstraint;
import org.tinfour.common.PolyLineConstraintAdapter;
import org.tinfour.common.Vertex;
import org.tinfour.utils.KahanSummation;

public class PolygonConstraint
extends PolyLineConstraintAdapter
implements IConstraint {
    private double squareArea;

    public PolygonConstraint() {
    }

    public PolygonConstraint(Vertex v0, Vertex v1, Vertex v2, Vertex v3) {
        this.add(v0);
        this.add(v1);
        this.add(v2);
        this.add(v3);
        this.complete();
    }

    public PolygonConstraint(List<Vertex> vList) {
        super(vList);
    }

    @Override
    public List<Vertex> getVertices() {
        return this.list;
    }

    @Override
    public final void complete() {
        if (this.isComplete) {
            return;
        }
        this.isComplete = true;
        if (this.list.size() > 1) {
            Vertex a = (Vertex)this.list.get(0);
            Vertex b = (Vertex)this.list.get(this.list.size() - 1);
            if (a.getX() == b.getX() && a.getY() == b.getY()) {
                this.list.remove(this.list.size() - 1);
            } else {
                this.length += ((Vertex)this.list.get(0)).getDistance((Vertex)this.list.get(this.list.size() - 1));
            }
        }
        if (this.list.size() < 3) {
            return;
        }
        double xCenter = 0.0;
        double yCenter = 0.0;
        for (Vertex v : this.list) {
            xCenter += v.getX();
            yCenter += v.getY();
        }
        xCenter /= (double)this.list.size();
        yCenter /= (double)this.list.size();
        KahanSummation lenSum = new KahanSummation();
        KahanSummation areaSum = new KahanSummation();
        this.squareArea = 0.0;
        this.length = 0.0;
        Vertex a = (Vertex)this.list.get(this.list.size() - 1);
        for (Vertex b : this.list) {
            lenSum.add(a.getDistance(b));
            double aX = a.getX() - xCenter;
            double aY = a.getY() - yCenter;
            double bX = b.getX() - xCenter;
            double bY = b.getY() - yCenter;
            areaSum.add(aX * bY - aY * bX);
            a = b;
        }
        this.length = lenSum.getSum();
        this.squareArea = areaSum.getSum() / 2.0;
    }

    @Override
    public boolean isPolygon() {
        return true;
    }

    @Override
    public boolean definesConstrainedRegion() {
        return true;
    }

    public double getArea() {
        return this.squareArea;
    }

    @Override
    public double getNominalPointSpacing() {
        if (this.list.size() < 2) {
            return Double.NaN;
        }
        if (this.isComplete) {
            return this.length / (double)this.list.size();
        }
        return this.length / (double)(this.list.size() - 1);
    }

    @Override
    public PolygonConstraint getConstraintWithNewGeometry(List<Vertex> geometry) {
        PolygonConstraint c = new PolygonConstraint();
        c.applicationData = this.applicationData;
        c.constraintIndex = this.constraintIndex;
        c.maintainingTin = this.maintainingTin;
        c.constraintLinkingEdge = this.constraintLinkingEdge;
        for (Vertex v : geometry) {
            c.add(v);
            v.setConstraintMember(true);
        }
        c.complete();
        return c;
    }

    @Override
    public PolygonConstraint refactor(Iterable<Vertex> geometry) {
        ArrayList<Vertex> gList = new ArrayList<Vertex>();
        for (Vertex v : geometry) {
            gList.add(v);
        }
        return this.getConstraintWithNewGeometry(gList);
    }

    @Override
    public boolean isValid() {
        if (this.list.size() < 3) {
            return false;
        }
        if (this.list.size() == 3) {
            Vertex v0 = (Vertex)this.list.get(0);
            Vertex v1 = (Vertex)this.list.get(2);
            if (v0.getX() == v1.getX() && v0.getY() == v1.getY()) {
                return false;
            }
        }
        return true;
    }

    public Path2D getPath2D(AffineTransform transform) {
        AffineTransform af = transform;
        if (transform == null) {
            af = new AffineTransform();
        }
        double[] c = new double[4];
        Path2D.Double path = new Path2D.Double(0);
        boolean moveFlag = true;
        for (Vertex v : this.list) {
            c[0] = v.x;
            c[1] = v.y;
            af.transform(c, 0, c, 2, 1);
            if (moveFlag) {
                moveFlag = false;
                ((Path2D)path).moveTo(c[2], c[3]);
                continue;
            }
            ((Path2D)path).lineTo(c[2], c[3]);
        }
        path.closePath();
        return path;
    }

    public String toString() {
        String appStr = "";
        if (this.applicationData == null) {
            return "PolygonConstraint, area=" + this.getArea();
        }
        appStr = this.applicationData.toString();
        return "PolygonConstraint, area=" + this.getArea() + ", appData=" + appStr;
    }
}

