/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.contour;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;
import org.tinfour.interpolation.IVertexValuator;
import org.tinfour.interpolation.NaturalNeighborInterpolator;

public class SmoothingFilter
implements IVertexValuator {
    NaturalNeighborInterpolator nni;
    IIncrementalTin tin;
    double[] zArray;
    private final double timeToConstructFilter;

    public SmoothingFilter(IIncrementalTin tin) {
        long time0 = System.nanoTime();
        this.tin = tin;
        this.nni = new NaturalNeighborInterpolator(tin);
        List<Vertex> vList = tin.getVertices();
        this.zArray = new double[vList.size() + 1];
        BitSet visited = new BitSet(vList.size() + 1);
        int k = 0;
        for (Vertex v : vList) {
            this.zArray[k] = v.getZ();
            v.setIndex(k++);
        }
        for (int i = 0; i < 25; ++i) {
            visited.clear();
            double[] zSource = Arrays.copyOf(this.zArray, this.zArray.length);
            for (IQuadEdge e : tin.edges()) {
                this.process(visited, zSource, e);
                this.process(visited, zSource, e.getDual());
            }
        }
        long time1 = System.nanoTime();
        this.timeToConstructFilter = (double)(time1 - time0) / 1000000.0;
    }

    public double getTimeToConstructFilter() {
        return this.timeToConstructFilter;
    }

    private void process(BitSet visited, double[] zSource, IQuadEdge edge) {
        double zNeighbors;
        Vertex A = edge.getA();
        if (A == null) {
            return;
        }
        int index = A.getIndex();
        if (visited.get(index)) {
            return;
        }
        visited.set(index);
        if (A.isConstraintMember()) {
            return;
        }
        double x = A.getX();
        double y = A.getY();
        List<IQuadEdge> pList = this.nni.getConnectedPolygon(edge);
        double[] w = this.nni.getBarycentricCoordinates(pList, x, y);
        if (w == null) {
            return;
        }
        double sumW = 0.0;
        double sumZ = 0.0;
        int k = 0;
        for (IQuadEdge p : pList) {
            double zP = zSource[p.getA().getIndex()];
            sumW += w[k];
            sumZ += zP * w[k];
            ++k;
        }
        this.zArray[index] = zNeighbors = sumZ / sumW;
    }

    @Override
    public double value(Vertex v) {
        int index = v.getIndex();
        return this.zArray[index];
    }

    public double[] getVertexAdjustments() {
        return Arrays.copyOf(this.zArray, this.zArray.length);
    }

    public void setVertexAdjustments(double[] adjustments) {
        if (adjustments.length != this.zArray.length) {
            throw new IllegalArgumentException("Adjustment size " + adjustments.length + " does not match internal value " + this.zArray.length);
        }
        System.arraycopy(adjustments, 0, this.zArray, 0, adjustments.length);
    }
}

