/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gis.shapefile;

public enum ShapefileType {
    NullShape(0, false),
    Point(1, false),
    PolyLine(3, false),
    Polygon(5, false),
    MultiPoint(8, false),
    PointZ(11, true),
    PolyLineZ(13, true),
    PolygonZ(15, true),
    MultiPointZ(18, true),
    PointM(21, false),
    PolyLineM(23, false),
    PolygonM(25, false),
    MultiPointM(28, false),
    MultiPatch(31, false);

    private final int shapeTypeCode;
    private final boolean hasZ;

    private ShapefileType(int shapeTypeCode, boolean hasZ) {
        this.shapeTypeCode = shapeTypeCode;
        this.hasZ = hasZ;
    }

    public static ShapefileType getShapefileType(int code) {
        for (ShapefileType v : ShapefileType.values()) {
            if (v.shapeTypeCode != code) continue;
            return v;
        }
        return null;
    }

    public int getTypeCode() {
        return this.shapeTypeCode;
    }

    public boolean isPolygon() {
        return this == PolygonZ || this == Polygon || this == PolygonM;
    }

    public boolean is3D() {
        return this.hasZ;
    }
}

