/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.svm;

import java.util.ArrayList;
import java.util.List;
import org.tinfour.common.GeometricOperations;
import org.tinfour.common.Thresholds;
import org.tinfour.common.Vertex;
import org.tinfour.utils.KahanSummation;

class SvmTriangleVolumeStore {
    private static final int PAGE_ALLOC_SIZE = 1000;
    private static final int N_VALUES_PER_ENTRY = 11;
    private List<VolumePage> pageList = new ArrayList<VolumePage>();
    private VolumePage currentPage;
    private int nTriangles;
    private double maxArea = 0.0;
    private final GeometricOperations geoOp;

    SvmTriangleVolumeStore(Thresholds thresholds) {
        this.geoOp = new GeometricOperations(thresholds);
        this.currentPage = new VolumePage();
        this.pageList.add(this.currentPage);
    }

    void addTriangle(Vertex a, Vertex b, Vertex c, double test) {
        Vertex v2;
        Vertex v1;
        Vertex v0;
        if (this.currentPage.n == 1000) {
            this.currentPage = new VolumePage();
            this.pageList.add(this.currentPage);
        }
        ++this.nTriangles;
        double aZ = a.getZ();
        double bZ = b.getZ();
        double cZ = c.getZ();
        if (aZ <= bZ) {
            if (aZ <= cZ) {
                v0 = a;
                v1 = b;
                v2 = c;
            } else {
                v0 = c;
                v1 = a;
                v2 = b;
            }
        } else if (bZ <= cZ) {
            v0 = b;
            v1 = c;
            v2 = a;
        } else {
            v0 = c;
            v1 = b;
            v2 = a;
        }
        if (v2.getZ() < v1.getZ()) {
            Vertex swap = v1;
            v1 = v2;
            v2 = swap;
        }
        double x0 = v0.getX();
        double y0 = v0.getY();
        double z0 = v0.getZ();
        double x1 = v1.getX();
        double y1 = v1.getY();
        double z1 = v1.getZ();
        double x2 = v2.getX();
        double y2 = v2.getY();
        double z2 = v2.getZ();
        assert (z0 <= z1 && z1 <= z2) : "vertex ordering failure";
        double zPartialMean = (2.0 * z2 - z1 - z0) / 3.0;
        double area = Math.abs(this.geoOp.area(v0, v1, v2));
        double partialVolume = area * zPartialMean;
        if (area > this.maxArea) {
            this.maxArea = area;
        }
        int i = this.currentPage.n * 11;
        ++this.currentPage.n;
        this.currentPage.p[i] = area;
        this.currentPage.p[i + 1] = partialVolume;
        this.currentPage.p[i + 2] = x0;
        this.currentPage.p[i + 3] = y0;
        this.currentPage.p[i + 4] = z0;
        this.currentPage.p[i + 5] = x1;
        this.currentPage.p[i + 6] = y1;
        this.currentPage.p[i + 7] = z1;
        this.currentPage.p[i + 8] = x2;
        this.currentPage.p[i + 9] = y2;
        this.currentPage.p[i + 10] = z2;
    }

    AreaVolumeResult compute(double z) {
        KahanSummation areaSum = new KahanSummation();
        KahanSummation volumeSum = new KahanSummation();
        for (VolumePage page : this.pageList) {
            for (int i = 0; i < page.n; ++i) {
                double bY;
                double bX;
                double aY;
                double aX;
                int offset = i * 11;
                double area = page.p[offset];
                double partialVolume = page.p[offset + 1];
                double z0 = page.p[offset + 4];
                double z1 = page.p[offset + 7];
                double z2 = page.p[offset + 10];
                if (z <= z0) {
                    if (z != z0 || z0 != z1 || z1 != z0) continue;
                    areaSum.add(area);
                    continue;
                }
                if (z >= z2) {
                    double v = partialVolume + area * (z - z2);
                    areaSum.add(area);
                    volumeSum.add(v);
                    continue;
                }
                double x0 = page.p[offset + 2];
                double y0 = page.p[offset + 3];
                double x1 = page.p[offset + 5];
                double y1 = page.p[offset + 6];
                double x2 = page.p[offset + 8];
                double y2 = page.p[offset + 9];
                if (z > z1) {
                    aX = this.interp(z, z0, z2, x0, x2);
                    aY = this.interp(z, z0, z2, y0, y2);
                    bX = this.interp(z, z1, z2, x1, x2);
                    bY = this.interp(z, z1, z2, y1, y2);
                    double dryTrigArea = Math.abs(this.geoOp.area(aX, aY, bX, bY, x2, y2));
                    double dryTrigVolume = dryTrigArea * (2.0 * (z2 - z)) / 3.0;
                    double dryPolyArea = area - dryTrigArea;
                    double dryPolyVolume = dryPolyArea * (z2 - z);
                    double v = partialVolume - dryTrigVolume - dryPolyVolume;
                    areaSum.add(area - dryTrigArea);
                    volumeSum.add(v);
                    continue;
                }
                aX = this.interp(z, z0, z1, x0, x1);
                aY = this.interp(z, z0, z1, y0, y1);
                bX = this.interp(z, z0, z2, x0, x2);
                bY = this.interp(z, z0, z2, y0, y2);
                double a = Math.abs(this.geoOp.area(aX, aY, bX, bY, x0, y0));
                double v = a * (z - z0) / 3.0;
                areaSum.add(a);
                volumeSum.add(v);
            }
        }
        return new AreaVolumeResult(z, areaSum.getSum(), volumeSum.getSum());
    }

    private double interp(double z, double z0, double z1, double c0, double c1) {
        return (c0 * (z1 - z) + c1 * (z - z0)) / (z1 - z0);
    }

    int getTriangleCount() {
        return this.nTriangles;
    }

    class AreaVolumeResult {
        final double level;
        final double volume;
        final double area;

        AreaVolumeResult(double z, double area, double volume) {
            this.level = z;
            this.area = area;
            this.volume = volume;
        }
    }

    private static class VolumePage {
        int n;
        final double[] p = new double[11000];

        VolumePage() {
        }
    }
}

