/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.svm.properties;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.tinfour.gis.utils.IVerticalCoordinateTransform;

public class SvmFileSpecification {
    final String key;
    final File file;
    final String field;
    final IVerticalCoordinateTransform verticalTransform;

    SvmFileSpecification(String key, List<String> list, File folder) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Invalid key");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Empty specification for " + key);
        }
        this.key = key;
        String path = list.get(0);
        File test = new File(path);
        this.file = test.isAbsolute() || folder == null ? test : new File(folder, path);
        double fixedValue = Double.NaN;
        String s = list.get(1).trim();
        if (s.length() > 0 && !Character.isAlphabetic(s.charAt(0))) {
            try {
                fixedValue = Double.parseDouble(s);
            }
            catch (NumberFormatException dontCare) {
                fixedValue = Double.NaN;
            }
        }
        if (Double.isNaN(fixedValue)) {
            this.field = list.size() > 1 ? list.get(1) : null;
            this.verticalTransform = list.size() > 2 ? this.interpretVtrans(list.get(2)) : null;
        } else {
            this.field = null;
            this.verticalTransform = new FixedValueTransform(fixedValue);
        }
    }

    private List<String> split(String s) {
        StringBuilder sb = new StringBuilder(128);
        ArrayList<String> sList = new ArrayList<String>();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                if (sb.length() <= 0) continue;
                sList.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            sList.add(sb.toString());
        }
        return sList;
    }

    private IVerticalCoordinateTransform interpretVtrans(String string) {
        List<String> sList = this.split(string);
        int n = 0;
        double[] d = new double[sList.size()];
        for (String s : sList) {
            try {
                d[n++] = Double.parseDouble(s);
            }
            catch (NumberFormatException nex) {
                throw new IllegalArgumentException("Invalid entry where numeric expected for " + string.trim());
            }
        }
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return new FixedValueTransform(d[0]);
        }
        if (n == 2) {
            return new LinearValueTransform(d[0], d[1]);
        }
        throw new IllegalArgumentException("Too many specifications for " + string.trim());
    }

    public File getFile() {
        return this.file;
    }

    public String getField() {
        return this.field;
    }

    public IVerticalCoordinateTransform getVerticalTransform() {
        return this.verticalTransform;
    }

    public String toString() {
        String path = this.file.getPath();
        return "SvmInput: " + this.key + "=" + path;
    }

    private static class LinearValueTransform
    implements IVerticalCoordinateTransform {
        final double scale;
        final double offset;

        LinearValueTransform(double scale, double offset) {
            this.scale = scale;
            this.offset = offset;
        }

        @Override
        public double transform(int recordIndex, double z) {
            return this.scale * z + this.offset;
        }

        public String toString() {
            return "Linear value transform z'=" + this.scale + "*z+" + this.offset;
        }
    }

    private static class FixedValueTransform
    implements IVerticalCoordinateTransform {
        final double value;

        FixedValueTransform(double value) {
            this.value = value;
        }

        public String toString() {
            return "Fixed value transform z'=" + this.value;
        }

        @Override
        public double transform(int recordIndex, double z) {
            return this.value;
        }
    }
}

