/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.edge;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;
import org.tinfour.edge.QuadEdge;

public class EdgePool
implements Iterable<IQuadEdge> {
    private static final int EDGE_POOL_PAGE_SIZE = 1024;
    private final int pageSize;
    private final int pageSize2;
    Page[] pages;
    Page nextAvailablePage;
    int nAllocated;
    int nFree;
    int nAllocationOperations;
    int nFreeOperations;
    HashMap<Integer, IConstraint> borderConstraintMap = new HashMap();
    HashMap<Integer, IConstraint> linearConstraintMap = new HashMap();

    public EdgePool() {
        this.pageSize = 1024;
        this.pageSize2 = 2048;
        this.pages = new Page[1];
        this.pages[0] = new Page(0);
        this.nextAvailablePage = this.pages[0];
        this.nextAvailablePage.initializeEdges();
        this.nFree = this.pageSize;
    }

    int getPageCount() {
        return this.pages.length;
    }

    int getPageSize() {
        return this.pageSize;
    }

    public void preAllocateEdges(int n) {
        int i;
        if (this.nFree >= n) {
            return;
        }
        int availablePageID = this.nextAvailablePage.pageID;
        int edgesNeeded = n - this.nFree;
        int pagesNeeded = (edgesNeeded + this.pageSize - 1) / this.pageSize;
        int oldLen = this.pages.length;
        int nP = oldLen + pagesNeeded;
        this.pages = Arrays.copyOf(this.pages, nP);
        for (i = oldLen; i < nP; ++i) {
            this.pages[i] = new Page(i);
            this.pages[i].initializeEdges();
        }
        for (i = 0; i < nP - 1; ++i) {
            this.pages[i].nextPage = this.pages[i + 1];
        }
        this.nextAvailablePage = this.pages[availablePageID];
        this.nFree += pagesNeeded * this.pageSize;
    }

    private void allocatePage() {
        int oldLength = this.pages.length;
        Page[] newPages = new Page[oldLength + 1];
        System.arraycopy(this.pages, 0, newPages, 0, this.pages.length);
        newPages[oldLength] = new Page(oldLength);
        newPages[oldLength].initializeEdges();
        this.pages = newPages;
        this.nFree += this.pageSize;
        this.nextAvailablePage = this.pages[oldLength];
        for (int i = 0; i < this.pages.length - 1; ++i) {
            this.pages[i].nextPage = this.pages[i + 1];
        }
    }

    public QuadEdge allocateEdge(Vertex a, Vertex b) {
        Page page = this.nextAvailablePage;
        QuadEdge e = page.allocateEdge();
        if (page.isFullyAllocated()) {
            this.nextAvailablePage = page.nextPage;
            if (this.nextAvailablePage == null) {
                this.allocatePage();
            }
        }
        --this.nFree;
        ++this.nAllocated;
        ++this.nAllocationOperations;
        e.setVertices(a, b);
        return e;
    }

    QuadEdge allocateUndefinedEdge() {
        Page page = this.nextAvailablePage;
        QuadEdge t = page.allocateEdge();
        if (page.isFullyAllocated()) {
            this.nextAvailablePage = page.nextPage;
            if (this.nextAvailablePage == null) {
                this.allocatePage();
            }
        }
        --this.nFree;
        ++this.nAllocated;
        ++this.nAllocationOperations;
        return t;
    }

    public void deallocateEdge(QuadEdge e) {
        int iPage = e.getIndex() / this.pageSize2;
        Page page = this.pages[iPage];
        if (page.isFullyAllocated()) {
            page.nextPage = this.nextAvailablePage;
            this.nextAvailablePage = page;
        }
        page.deallocateEdge(e);
        --this.nAllocated;
        ++this.nFree;
        ++this.nFreeOperations;
    }

    public int size() {
        return this.nAllocated;
    }

    public QuadEdge getStartingEdge() {
        for (Page p : this.pages) {
            if (p.nAllocated <= 0) continue;
            for (int i = 0; i < p.nAllocated; ++i) {
                if (p.edges[i].getB() == null || p.edges[i].getA() == null) continue;
                return p.edges[i];
            }
        }
        return null;
    }

    public QuadEdge getStartingGhostEdge() {
        for (Page p : this.pages) {
            if (p.nAllocated <= 0) continue;
            for (int i = 0; i < p.nAllocated; ++i) {
                QuadEdge e = p.edges[i];
                if (e.getB() != null) continue;
                return e;
            }
        }
        return null;
    }

    public List<IQuadEdge> getEdges() {
        ArrayList<IQuadEdge> eList = new ArrayList<IQuadEdge>(this.nAllocated);
        for (Page p : this.pages) {
            for (int j = 0; j < p.nAllocated; ++j) {
                eList.add(p.edges[j]);
            }
        }
        return eList;
    }

    public int getEdgeCount() {
        return this.nAllocated;
    }

    public void dispose() {
        this.nextAvailablePage = null;
        for (int i = 0; i < this.pages.length; ++i) {
            Page page = this.pages[i];
            page.nextPage = null;
            for (int j = 0; j < this.pageSize; ++j) {
                QuadEdge e = page.edges[j];
                e.clear();
                page.edges[j] = null;
            }
            page.edges = null;
            this.pages[i] = null;
        }
        this.pages = null;
    }

    public void clear() {
        for (Page p : this.pages) {
            for (QuadEdge t : p.edges) {
                t.clear();
            }
            p.nAllocated = 0;
        }
        this.nAllocated = 0;
        this.nFree = this.pages.length * this.pageSize;
        this.nAllocationOperations = 0;
        this.nFreeOperations = 0;
        this.nextAvailablePage = this.pages[0];
        for (int i = 0; i < this.pages.length - 1; ++i) {
            this.pages[i].nextPage = this.pages[i + 1];
        }
        this.pages[this.pages.length - 1].nextPage = null;
        this.linearConstraintMap.clear();
        this.borderConstraintMap.clear();
    }

    public String toString() {
        String s = "nEdges=" + this.nAllocated + ", nPages=" + this.pages.length + ", nFree=" + this.nFree;
        return s;
    }

    public void printDiagnostics(PrintStream ps) {
        int nPartials = 0;
        Page p = this.nextAvailablePage;
        while (p != null) {
            ++nPartials;
            p = p.nextPage;
        }
        int nConstrained = 0;
        int nConstraintInterior = 0;
        int nConstraintBorder = 0;
        for (IQuadEdge e : this) {
            if (e.isConstrained()) {
                ++nConstrained;
                if (!e.isConstrainedRegionBorder()) continue;
                ++nConstraintBorder;
                continue;
            }
            if (!e.isConstrainedRegionInterior()) continue;
            ++nConstraintInterior;
        }
        ps.format("Edges allocated:             %8d%n", this.nAllocated);
        ps.format("Edges free:                  %8d%n", this.nFree);
        ps.format("Pages:                       %8d%n", this.pages.length);
        ps.format("Partially used pages:        %8d%n", nPartials);
        ps.format("Total allocation operations: %8d%n", this.nAllocationOperations);
        ps.format("Total free operations:       %8d%n", this.nFreeOperations);
        ps.format("Constrained edges            %8d%n", nConstrained);
        ps.format("   Region borders:           %8d%n", nConstraintBorder);
        ps.format("   Region interior:          %8d%n", nConstraintInterior);
    }

    @Override
    public Iterator<IQuadEdge> iterator() {
        return this.getIterator(true);
    }

    public Iterator<IQuadEdge> getIterator(final boolean includeGhostEdges) {
        Iterator<IQuadEdge> ix = new Iterator<IQuadEdge>(){
            QuadEdge currentEdge;
            int nextPage;
            int nextEdge;
            boolean skipGhosts;
            boolean hasNext;
            {
                this.skipGhosts = !includeGhostEdges;
                this.hasNext = this.findNextEdge(0, -1);
            }

            private boolean findNextEdge(int iPage, int iEdge) {
                this.nextPage = iPage;
                this.nextEdge = iEdge;
                while (this.nextPage < EdgePool.this.pages.length) {
                    ++this.nextEdge;
                    if (this.nextEdge < EdgePool.this.pages[this.nextPage].nAllocated) {
                        QuadEdge e;
                        if (this.skipGhosts && ((e = EdgePool.this.pages[this.nextPage].edges[this.nextEdge]).getA() == null || e.getB() == null)) continue;
                        return true;
                    }
                    this.nextEdge = -1;
                    ++this.nextPage;
                }
                return false;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove operation not supported by this iterator");
            }

            @Override
            public QuadEdge next() {
                this.currentEdge = null;
                if (this.hasNext) {
                    this.currentEdge = EdgePool.this.pages[this.nextPage].edges[this.nextEdge];
                    this.hasNext = this.findNextEdge(this.nextPage, this.nextEdge);
                }
                return this.currentEdge;
            }
        };
        return ix;
    }

    public int getMaximumAllocationIndex() {
        for (int iPage = this.pages.length - 1; iPage >= 0; --iPage) {
            Page p = this.pages[iPage];
            if (p.nAllocated <= 0) continue;
            return p.pageID * this.pageSize2 + p.nAllocated * 2;
        }
        return 0;
    }

    public QuadEdge splitEdge(QuadEdge e, Vertex m) {
        IConstraint c;
        QuadEdge b = e.getBaseReference();
        QuadEdge d = e.getDual();
        QuadEdge eR = e.getReverse();
        QuadEdge dF = d.getForward();
        Vertex a = e.getA();
        e.setA(m);
        QuadEdge p = this.allocateEdge(a, m);
        QuadEdge q = p.getDual();
        p.setForward(e);
        p.setReverse(eR);
        q.setForward(dF);
        q.setReverse(d);
        p.dual.index = b.dual.index;
        if (e.isConstrainedRegionBorder()) {
            IConstraint c2 = this.borderConstraintMap.get(e.getIndex());
            if (c2 != null) {
                this.addBorderConstraintToMap(p, c2);
            }
            if ((c2 = this.borderConstraintMap.get(d.getIndex())) != null) {
                this.addBorderConstraintToMap(q, c2);
            }
        } else if (e.isConstraintLineMember() && (c = this.linearConstraintMap.get(e.getIndex())) != null) {
            this.addLinearConstraintToMap(p, c);
        }
        return p;
    }

    public void addBorderConstraintToMap(IQuadEdge edge, IConstraint constraint) {
        this.borderConstraintMap.put(edge.getIndex(), constraint);
    }

    public void addLinearConstraintToMap(IQuadEdge edge, IConstraint constraint) {
        int index = edge.getIndex();
        this.linearConstraintMap.put(index, constraint);
        this.linearConstraintMap.put(index ^ 1, constraint);
    }

    public void removeBorderConstraintFromMap(IQuadEdge edge) {
        this.borderConstraintMap.remove(edge.getIndex());
    }

    public IConstraint getBorderConstraint(IQuadEdge edge) {
        if (edge.isConstrainedRegionBorder()) {
            return this.borderConstraintMap.get(edge.getIndex());
        }
        return null;
    }

    public IConstraint getLinearConstraint(IQuadEdge edge) {
        if (edge.isConstraintLineMember()) {
            return this.linearConstraintMap.get(edge.getIndex());
        }
        return null;
    }

    private class Page {
        int pageID;
        int pageOffset;
        int nAllocated;
        QuadEdge[] edges;
        Page nextPage;

        Page(int pageID) {
            this.pageID = pageID;
            this.pageOffset = pageID * EdgePool.this.pageSize2;
            this.edges = new QuadEdge[EdgePool.this.pageSize];
        }

        void initializeEdges() {
            for (int i = 0; i < EdgePool.this.pageSize; ++i) {
                this.edges[i] = new QuadEdge(this.pageOffset + i * 2);
            }
        }

        QuadEdge allocateEdge() {
            QuadEdge e = this.edges[this.nAllocated];
            e.setIndex(this.pageID * EdgePool.this.pageSize2 + this.nAllocated * 2);
            ++this.nAllocated;
            return e;
        }

        void deallocateEdge(QuadEdge be) {
            QuadEdge e = be.getBaseReference();
            int arrayIndex = (e.getIndex() - this.pageOffset) / 2;
            e.clear();
            --this.nAllocated;
            if (arrayIndex < this.nAllocated) {
                QuadEdge swap;
                this.edges[arrayIndex] = swap = this.edges[this.nAllocated];
                int oldIndex = swap.getIndex();
                int newIndex = this.pageOffset + arrayIndex * 2;
                swap.setIndex(newIndex);
                this.edges[this.nAllocated] = e;
                if (swap.isConstraintLineMember()) {
                    IConstraint c;
                    if (EdgePool.this.linearConstraintMap.containsKey(oldIndex)) {
                        c = EdgePool.this.linearConstraintMap.get(oldIndex);
                        EdgePool.this.linearConstraintMap.remove(oldIndex);
                        EdgePool.this.linearConstraintMap.remove(oldIndex ^ 1);
                        EdgePool.this.linearConstraintMap.put(newIndex, c);
                        EdgePool.this.linearConstraintMap.put(newIndex ^ 1, c);
                    }
                    if (swap.isConstrainedRegionBorder()) {
                        if (EdgePool.this.borderConstraintMap.containsKey(oldIndex)) {
                            c = EdgePool.this.borderConstraintMap.get(oldIndex);
                            EdgePool.this.borderConstraintMap.remove(oldIndex);
                            EdgePool.this.borderConstraintMap.put(newIndex, c);
                        }
                        newIndex ^= 1;
                        if (EdgePool.this.borderConstraintMap.containsKey(oldIndex ^= 1)) {
                            c = EdgePool.this.borderConstraintMap.get(oldIndex);
                            EdgePool.this.borderConstraintMap.remove(oldIndex);
                            EdgePool.this.borderConstraintMap.put(newIndex, c);
                        }
                    }
                }
                e.setIndex(this.pageOffset + this.nAllocated * 2);
            }
        }

        boolean isFullyAllocated() {
            return this.nAllocated == this.edges.length;
        }
    }
}

