/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gis.las;

import java.util.Date;
import org.tinfour.gis.las.GpsTimeConverter;

public enum LasGpsTimeType {
    WeekTime,
    SatelliteTime;

    public static final long GPS_EPOCH_SECONDS = 315964800000L;

    public long transformGpsTimeToMillis(double lasGpsTime) {
        long f = (long)Math.floor(lasGpsTime);
        double d = lasGpsTime - (double)f;
        if (this == SatelliteTime) {
            double gpsTime = Math.floor(lasGpsTime) + 1.0E9;
            long s = GpsTimeConverter.gpsToMillis(gpsTime);
            return s + (long)(d * 1000.0 + 0.5);
        }
        return f * 1000L + (long)(d * 1000.0 + 0.5);
    }

    public Date transformGpsTimeToDate(double lasGpsTime) {
        return new Date(this.transformGpsTimeToMillis(lasGpsTime));
    }
}

