/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gis.shapefile;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.SimpleTimeZone;
import org.tinfour.gis.shapefile.DbfField;
import org.tinfour.io.BufferedRandomAccessReader;

public class DbfFileReader
implements Closeable {
    private static final int N_BYTES_IN_FIELD_DEF = 32;
    File file;
    BufferedRandomAccessReader brad;
    final int version;
    final int nRecords;
    final int nBytesInHeader;
    final int nBytesInRecord;
    final int nFields;
    final List<DbfField> fields;
    final Date dateTime;

    public DbfFileReader(File file) throws IOException {
        this.file = file;
        this.brad = new BufferedRandomAccessReader(file);
        this.version = this.brad.readUnsignedByte() & 3;
        if (this.version != 3) {
            throw new IOException("Unsupported DBF version " + this.version);
        }
        int year = this.brad.readUnsignedByte() + 1900;
        int month = this.brad.readUnsignedByte();
        int day = this.brad.readUnsignedByte();
        if (month > 0) {
            --month;
        }
        SimpleTimeZone zone = new SimpleTimeZone(0, "UTC");
        Calendar calendar = Calendar.getInstance(zone);
        calendar.set(year, month, day);
        this.dateTime = calendar.getTime();
        this.nRecords = this.brad.readInt();
        this.nBytesInHeader = this.brad.readUnsignedShort();
        this.nBytesInRecord = this.brad.readUnsignedShort();
        this.nFields = (this.nBytesInHeader - 32 - 1) / 32;
        this.fields = new ArrayList<DbfField>(this.nFields);
        this.brad.seek(32L);
        int offset = 1;
        for (int i = 0; i < this.nFields; ++i) {
            this.brad.seek(32 + i * 32);
            DbfField f = DbfField.load(this.brad, offset);
            offset += f.getFieldLength();
            this.fields.add(f);
        }
    }

    public int getRecordCount() {
        return this.nRecords;
    }

    public List<DbfField> getFields() {
        ArrayList<DbfField> fList = new ArrayList<DbfField>(this.nFields);
        fList.addAll(this.fields);
        return fList;
    }

    public DbfField getFieldByName(String name) {
        for (DbfField f : this.fields) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        for (DbfField f : this.fields) {
            if (!f.getName().equalsIgnoreCase(name)) continue;
            return f;
        }
        return null;
    }

    public void readField(int recordNumber, DbfField field) throws IOException {
        if (recordNumber < 1 || recordNumber > this.nRecords) {
            throw new IOException("Record " + recordNumber + " out of range 1 to " + this.nRecords);
        }
        long recordOffset = (long)this.nBytesInHeader + (long)(recordNumber - 1) * (long)this.nBytesInRecord;
        field.read(this.brad, recordOffset);
    }

    @Override
    public void close() throws IOException {
        if (this.brad != null) {
            this.brad.close();
        }
    }
}

