/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.interpolation;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.tinfour.common.Circumcircle;
import org.tinfour.common.GeometricOperations;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IIncrementalTinNavigator;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Thresholds;
import org.tinfour.common.Vertex;
import org.tinfour.interpolation.IInterpolatorOverTin;
import org.tinfour.interpolation.IVertexValuator;
import org.tinfour.interpolation.VertexValuatorDefault;

public class NaturalNeighborInterpolator
implements IInterpolatorOverTin {
    private final double vertexTolerance2;
    private final double inCircleThreshold;
    private final double halfPlaneThreshold;
    final IIncrementalTin tin;
    final GeometricOperations geoOp;
    IIncrementalTinNavigator navigator;
    private final VertexValuatorDefault defaultValuator = new VertexValuatorDefault();
    private double xQuery;
    private double yQuery;
    private double barycentricCoordinateDeviation;

    public NaturalNeighborInterpolator(IIncrementalTin tin) {
        Thresholds thresholds = tin.getThresholds();
        this.geoOp = new GeometricOperations(thresholds);
        this.vertexTolerance2 = thresholds.getVertexTolerance2();
        this.inCircleThreshold = thresholds.getInCircleThreshold();
        this.halfPlaneThreshold = thresholds.getHalfPlaneThreshold();
        this.tin = tin;
        this.navigator = tin.getNavigator();
    }

    @Override
    public void resetForChangeToTin() {
        this.navigator.resetForChangeToTin();
    }

    @Override
    public double interpolate(double x, double y, IVertexValuator valuator) {
        List<IQuadEdge> eList;
        int nEdge;
        this.xQuery = x;
        this.yQuery = y;
        IVertexValuator vq = valuator;
        if (vq == null) {
            vq = this.defaultValuator;
        }
        if ((nEdge = (eList = this.getBowyerWatsonPolygon(x, y)).size()) == 0) {
            return Double.NaN;
        }
        if (nEdge == 1) {
            IQuadEdge e = eList.get(0);
            Vertex v = e.getA();
            return vq.value(v);
        }
        Circumcircle c0 = new Circumcircle();
        Circumcircle c1 = new Circumcircle();
        double barycenterX = 0.0;
        double barycenterY = 0.0;
        double wSum = 0.0;
        double zSum = 0.0;
        for (int i0 = 0; i0 < nEdge; ++i0) {
            double y1;
            double x1;
            double y0;
            double x0;
            int i1 = (i0 + 1) % nEdge;
            IQuadEdge e0 = eList.get(i0);
            IQuadEdge e1 = eList.get(i1);
            Vertex a = e0.getA();
            Vertex b = e1.getA();
            Vertex c = e1.getB();
            double ax = a.getX() - x;
            double ay = a.getY() - y;
            double bx = b.getX() - x;
            double by = b.getY() - y;
            double cx = c.getX() - x;
            double cy = c.getY() - y;
            IQuadEdge ed0 = e0.getDual();
            Vertex d0 = ed0.getForward().getB();
            if (d0 == null) {
                x0 = (ax + bx) / 2.0;
                y0 = (ay + by) / 2.0;
            } else {
                c0.compute(bx, by, ax, ay, d0.getX() - x, d0.getY() - y);
                x0 = c0.getX();
                y0 = c0.getY();
            }
            IQuadEdge ed1 = e1.getDual();
            Vertex d1 = ed1.getForward().getB();
            if (d1 == null) {
                x1 = (bx + cx) / 2.0;
                y1 = (by + cy) / 2.0;
            } else {
                c1.compute(cx, cy, bx, by, d1.getX() - x, d1.getY() - y);
                x1 = c1.getX();
                y1 = c1.getY();
            }
            c0.compute(ax, ay, bx, by, 0.0, 0.0);
            c1.compute(bx, by, cx, cy, 0.0, 0.0);
            double wXY = x0 * c0.getY() - c0.getX() * y0 + c0.getX() * c1.getY() - c1.getX() * c0.getY() + c1.getX() * y1 - x1 * c1.getY();
            IQuadEdge n = e0.getForward();
            Vertex nb = n.getB();
            c1.compute(ax, ay, bx, by, nb.getX() - x, nb.getY() - y);
            double wThiessen = x0 * c1.getY() - c1.getX() * y0;
            while (!n.equals(e1)) {
                IQuadEdge n1 = n.getDual();
                n = n1.getForward();
                c0.copy(c1);
                a = n1.getA();
                b = n.getA();
                c = n.getB();
                ax = a.getX() - x;
                ay = a.getY() - y;
                bx = b.getX() - x;
                by = b.getY() - y;
                cx = c.getX() - x;
                cy = c.getY() - y;
                c1.compute(ax, ay, bx, by, cx, cy);
                wThiessen += c0.getX() * c1.getY() - c1.getX() * c0.getY();
            }
            double wDelta = -((wThiessen += c1.getX() * y1 - x1 * c1.getY()) - wXY);
            wSum += wDelta;
            b = e0.getB();
            zSum += wDelta * vq.value(b);
            barycenterX += wDelta * b.getX();
            barycenterY += wDelta * b.getY();
        }
        double xError = (barycenterX /= wSum) - x;
        double yError = (barycenterY /= wSum) - y;
        this.barycentricCoordinateDeviation = Math.sqrt(xError * xError + yError * yError);
        return zSum / wSum;
    }

    public double interpolateUsingTestMethod(double x, double y, IVertexValuator valuator) {
        List<IQuadEdge> eList;
        int nEdge;
        IVertexValuator vq = valuator;
        if (vq == null) {
            vq = this.defaultValuator;
        }
        if ((nEdge = (eList = this.getBowyerWatsonPolygon(x, y)).size()) == 0) {
            return Double.NaN;
        }
        if (nEdge == 1) {
            IQuadEdge e = eList.get(0);
            Vertex v = e.getA();
            return vq.value(v);
        }
        double[] w = this.getBarycentricCoordinates(eList, x, y);
        if (w == null) {
            return Double.NaN;
        }
        double zSum = 0.0;
        int k = 0;
        for (IQuadEdge s : eList) {
            double z = vq.value(s.getA());
            zSum += w[k++] * z;
        }
        return zSum;
    }

    public double getBarycentricCoordinateDeviation() {
        return this.barycentricCoordinateDeviation;
    }

    public List<IQuadEdge> getBowyerWatsonPolygon(double x, double y) {
        double h;
        ArrayList<IQuadEdge> eList = new ArrayList<IQuadEdge>();
        IQuadEdge locatorEdge = this.navigator.getNeighborEdge(x, y);
        if (locatorEdge == null) {
            return eList;
        }
        IQuadEdge e = locatorEdge;
        IQuadEdge f = e.getForward();
        IQuadEdge r = e.getReverse();
        Vertex v0 = e.getA();
        Vertex v1 = e.getB();
        Vertex v2 = e.getForward().getB();
        if (v2 == null) {
            return eList;
        }
        if (v0.getDistanceSq(x, y) < this.vertexTolerance2) {
            eList.add(e);
            return eList;
        }
        if (v1.getDistanceSq(x, y) < this.vertexTolerance2) {
            eList.add(e.getForward());
            return eList;
        }
        if (v2.getDistanceSq(x, y) < this.vertexTolerance2) {
            eList.add(e.getReverse());
            return eList;
        }
        if (e.isConstrained() && (h = this.geoOp.halfPlane(v0.x, v0.y, v1.x, v1.y, x, y)) < this.halfPlaneThreshold) {
            return eList;
        }
        if (f.isConstrained() && (h = this.geoOp.halfPlane(v1.x, v1.y, v2.x, v2.y, x, y)) < this.halfPlaneThreshold) {
            return eList;
        }
        if (r.isConstrained() && (h = this.geoOp.halfPlane(v2.x, v2.y, v0.x, v0.y, x, y)) < this.halfPlaneThreshold) {
            return eList;
        }
        ArrayDeque<IQuadEdge> stack = new ArrayDeque<IQuadEdge>();
        IQuadEdge c = locatorEdge;
        while (true) {
            IQuadEdge n0 = c.getDual();
            IQuadEdge n1 = n0.getForward();
            if (c.isConstrained()) {
                h = -1.0;
            } else if (n1.getB() == null) {
                h = -1.0;
            } else {
                double a11 = n0.getA().x - x;
                double a12 = n0.getA().y - y;
                double a21 = n1.getA().x - x;
                double a32 = n1.getB().y - y;
                double a31 = n1.getB().x - x;
                double a22 = n1.getA().y - y;
                h = (a11 * a11 + a12 * a12) * (a21 * a32 - a31 * a22) + (a21 * a21 + a22 * a22) * (a31 * a12 - a11 * a32) + (a31 * a31 + a32 * a32) * (a11 * a22 - a21 * a12);
                if (-this.inCircleThreshold < h && h < this.inCircleThreshold) {
                    h = this.geoOp.inCircleQuadPrecision(n0.getA().x, n0.getA().y, n1.getA().x, n1.getA().y, n1.getB().x, n1.getB().y, x, y);
                }
            }
            if (h >= 0.0) {
                stack.addFirst(n0);
                c = n1;
                continue;
            }
            eList.add(c);
            c = c.getForward();
            IQuadEdge p = (IQuadEdge)stack.peekFirst();
            while (c.equals(p)) {
                stack.remove();
                c = c.getDual().getForward();
                p = (IQuadEdge)stack.peekFirst();
            }
            if (c.equals(locatorEdge)) break;
        }
        return eList;
    }

    @Override
    public String getMethod() {
        return "Natural Neighbor (Sibson's C0)";
    }

    IQuadEdge checkTriangleVerticesForMatch(IQuadEdge baseEdge, double x, double y, double distanceTolerance2) {
        Vertex v2;
        IQuadEdge sEdge = baseEdge;
        IQuadEdge sFwd = sEdge.getForward();
        double dMin = sEdge.getA().getDistanceSq(x, y);
        double dFwd = sFwd.getA().getDistanceSq(x, y);
        if (dFwd < dMin) {
            sEdge = sFwd;
            dMin = dFwd;
        }
        if ((v2 = sEdge.getForward().getB()) != null && v2.getDistanceSq(x, y) < dMin) {
            return sFwd.getForward();
        }
        return sEdge;
    }

    @Override
    public boolean isSurfaceNormalSupported() {
        return true;
    }

    @Override
    public double[] getSurfaceNormal() {
        double[] bwWeights;
        List<IQuadEdge> bwList = this.getBowyerWatsonPolygon(this.xQuery, this.yQuery);
        int nEdge = bwList.size();
        if (nEdge == 0) {
            return new double[0];
        }
        if (nEdge == 1) {
            bwList = this.getConnectedPolygon(bwList.get(0));
        }
        if ((bwWeights = this.getBarycentricCoordinates(bwList, this.xQuery, this.yQuery)) == null) {
            return new double[0];
        }
        double xNormal = 0.0;
        double yNormal = 0.0;
        double zNormal = 0.0;
        int i = 0;
        for (IQuadEdge e : bwList) {
            List<IQuadEdge> rim = this.getConnectedPolygon(e);
            Vertex hub = e.getA();
            double xHub = hub.getX();
            double yHub = hub.getY();
            double zHub = hub.getZ();
            double[] w = this.getBarycentricCoordinates(rim, xHub, yHub);
            if (w == null) {
                w = this.repairRim(e, rim, xHub, yHub);
                if (rim.isEmpty()) {
                    return new double[0];
                }
            }
            int k = 0;
            double xSum = 0.0;
            double ySum = 0.0;
            double zSum = 0.0;
            for (IQuadEdge edge : rim) {
                Vertex v = edge.getA();
                double x = v.getX() - xHub;
                double y = v.getY() - yHub;
                double z = v.getZ() - zHub;
                double s = Math.sqrt(x * x + y * y);
                double nx = -z * x / s;
                double ny = -z * y / s;
                double nz = s;
                double n = w[k++] / Math.sqrt(nx * nx + ny * ny + nz * nz);
                xSum += nx * n;
                ySum += ny * n;
                zSum += nz * n;
            }
            double n = bwWeights[i++] / Math.sqrt(xSum * xSum + ySum * ySum + zSum * zSum);
            xNormal += xSum * n;
            yNormal += ySum * n;
            zNormal += zSum * n;
        }
        double[] normal = new double[3];
        double n = Math.sqrt(xNormal * xNormal + yNormal * yNormal + zNormal * zNormal);
        normal[0] = xNormal / n;
        normal[1] = yNormal / n;
        normal[2] = zNormal / n;
        return normal;
    }

    private double[] repairRim(IQuadEdge e, List<IQuadEdge> rim, double xHub, double yHub) {
        double[] w = new double[rim.size()];
        rim.clear();
        int k = 0;
        double wSum = 0.0;
        IQuadEdge s = e;
        do {
            double dy;
            double dx;
            double d;
            IQuadEdge f;
            Vertex v;
            if ((v = (f = s.getForward()).getA()) == null || !((d = Math.sqrt((dx = v.getX() - xHub) * dx + (dy = v.getY() - yHub) * dy)) > 0.0)) continue;
            double weight = 1.0 / d;
            w[k++] = weight;
            wSum += weight;
            rim.add(f);
        } while (!(s = s.getReverse().getDual()).equals(e));
        if (wSum == 0.0) {
            rim.clear();
        } else {
            int i = 0;
            while (i < k) {
                int n = i++;
                w[n] = w[n] / wSum;
            }
        }
        return w;
    }

    public List<IQuadEdge> getConnectedPolygon(IQuadEdge e) {
        ArrayList<IQuadEdge> eList = new ArrayList<IQuadEdge>();
        IQuadEdge s = e;
        do {
            eList.add(s.getForward());
        } while (!(s = s.getReverse().getDual()).equals(e));
        return eList;
    }

    public double[] getBarycentricCoordinates(List<IQuadEdge> polygon, double x, double y) {
        int i;
        this.barycentricCoordinateDeviation = Double.NaN;
        int nEdge = polygon.size();
        IQuadEdge p0 = polygon.get(nEdge - 1);
        IQuadEdge p1 = polygon.get(0);
        double[] weights = new double[nEdge];
        int k = 0;
        double xSum = 0.0;
        double ySum = 0.0;
        double wSum = 0.0;
        Vertex v0 = p0.getA();
        Vertex v1 = p1.getA();
        if (v0 == null || v1 == null) {
            return null;
        }
        double x0 = v0.getX() - x;
        double y0 = v0.getY() - y;
        double x1 = v1.getX() - x;
        double y1 = v1.getY() - y;
        double r0 = Math.sqrt(x0 * x0 + y0 * y0);
        double r1 = Math.sqrt(x1 * x1 + y1 * y1);
        double t1 = (r0 * r1 - (x0 * x1 + y0 * y1)) / (x0 * y1 - x1 * y0);
        for (IQuadEdge e1 : polygon) {
            double t0 = t1;
            x0 = x1;
            y0 = y1;
            r0 = r1;
            v1 = e1.getB();
            if (v1 == null) {
                return null;
            }
            x1 = v1.getX() - x;
            y1 = v1.getY() - y;
            r1 = Math.sqrt(x1 * x1 + y1 * y1);
            t1 = (r0 * r1 - (x0 * x1 + y0 * y1)) / (x0 * y1 - x1 * y0);
            double w = (t0 + t1) / r0;
            xSum += w * x0;
            ySum += w * y0;
            wSum += w;
            weights[k++] = w;
        }
        for (i = 0; i < k; ++i) {
            weights[i] = weights[i] / wSum;
        }
        wSum = 0.0;
        for (i = 0; i < k; ++i) {
            wSum += weights[i];
        }
        this.barycentricCoordinateDeviation = Math.sqrt(xSum * xSum + ySum * ySum);
        return weights;
    }
}

