/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.svm;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import org.tinfour.svm.SvmTriangleVolumeStore;
import org.tinfour.svm.properties.SvmProperties;
import org.tinfour.svm.properties.SvmUnitSpecification;
import org.tinfour.utils.AxisIntervals;

class SvmCapacityGraph {
    private final SvmProperties properties;
    private final List<SvmTriangleVolumeStore.AreaVolumeResult> resultList;
    private final double totalVolume;
    private final double minLevel;
    private final double maxLevel;
    private final SvmUnitSpecification unitOfVolume;
    private final SvmUnitSpecification unitOfLength;
    private static final int defaultImageHeightInPixels = 400;
    private static final double defaultImageHeightInPoints = 300.0;
    private static final double defaultFontSizeTitle = 14.0;
    private static final double defaultFontSizeAxis = 12.0;
    private static final double fLeft = 0.1;
    private static final double fTop = 0.08;
    private static final double fRight = 0.9;
    private static final double fBottom = 0.85;

    private double computeFontSize(double dSize, double dHeight) {
        double f = dSize / 300.0;
        double dHeightInPoints = dHeight * 72.0 / 96.0;
        double fSize = f * dHeightInPoints;
        if (fSize < 1.0) {
            fSize = 1.0;
        }
        return fSize;
    }

    SvmCapacityGraph(SvmProperties properties, List<SvmTriangleVolumeStore.AreaVolumeResult> resultList, double totalVolume) {
        this.properties = properties;
        this.resultList = resultList;
        this.totalVolume = totalVolume;
        double zMin = resultList.get((int)0).level;
        double zMax = resultList.get((int)(resultList.size() - 1)).level;
        if (zMin > zMax) {
            double swap = zMin;
            zMin = zMax;
            zMax = swap;
        }
        this.minLevel = zMin;
        this.maxLevel = zMax;
        this.unitOfVolume = properties.getUnitOfVolume();
        this.unitOfLength = properties.getUnitOfDistance();
    }

    boolean writeOutput() throws IOException {
        double y;
        int i;
        double yLabel;
        double xLabel;
        File outputFile = this.properties.getCapacityGraphFile();
        if (outputFile == null) {
            return false;
        }
        Dimension dimension = this.properties.getCapacityGraphDimensions();
        String title = this.properties.getCapacityGraphTitle();
        int width = dimension.width;
        int height = dimension.height;
        BufferedImage bImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = bImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, width, height);
        g2d.setColor(Color.gray);
        g2d.drawRect(0, 0, width - 1, height - 1);
        double wInPixels = dimension.getWidth();
        double hInPixels = dimension.getHeight();
        double titleFontSize = this.computeFontSize(14.0, hInPixels);
        double axisFontSize = this.computeFontSize(12.0, hInPixels);
        Font titleFont = new Font("Arial", 1, (int)titleFontSize);
        Font axisFont = new Font("Arial", 1, (int)axisFontSize);
        FontRenderContext frc = new FontRenderContext(null, true, true);
        TextLayout testLayout = new TextLayout("00000", axisFont, frc);
        Rectangle2D fontR2D = testLayout.getBounds();
        double axisFontHeight = fontR2D.getHeight();
        double axisFontWidth = fontR2D.getWidth();
        int yFontAllowance = (int)(axisFontHeight * 1.1);
        int xFontAllowance = (int)(axisFontWidth * 1.3);
        AffineTransform af = AffineTransform.getQuadrantRotateInstance(3);
        Font axisFontRotated = axisFont.deriveFont(af);
        double volumeUnitsAdjustment = this.unitOfVolume.getScaleFactor();
        double gLeft = wInPixels * 0.1;
        double gRight = wInPixels * 0.9;
        double gTop = hInPixels * 0.08;
        double gBottom = hInPixels * 0.85;
        double gdx = gRight - gLeft;
        double gdy = gBottom - gTop;
        TextLayout titleLayout = null;
        Rectangle2D titleR2D = null;
        if (title != null) {
            titleLayout = new TextLayout(title, titleFont, frc);
            titleR2D = titleLayout.getBounds();
            gTop = (int)(-3.0 * titleR2D.getY());
            gdy = gBottom - gTop;
        }
        double cHead = 110.0;
        AxisIntervals cIntervals = AxisIntervals.computeIntervals(0.0, cHead, yFontAllowance, yFontAllowance / 2, (int)gdy, true);
        double cUnitsPerPixel = cIntervals.getUnitsPerPixel();
        double[] cCoords = cIntervals.getLabelCoordinates();
        String[] cLabels = cIntervals.getLabels();
        double cDeltaPix = cHead / cUnitsPerPixel;
        double cDeltaPix100 = 100.0 / cUnitsPerPixel;
        double vWithScale = this.totalVolume / volumeUnitsAdjustment;
        double vUnitsPerPixel = vWithScale / cDeltaPix100;
        AxisIntervals vIntervals = AxisIntervals.computeIntervals(0.0, vWithScale * (cHead / 100.0), yFontAllowance, yFontAllowance / 2, (int)gdy, false);
        double[] vCoords = vIntervals.getLabelCoordinates();
        String[] vLabels = vIntervals.getLabels();
        AxisIntervals xIntervals = AxisIntervals.computeIntervals(this.minLevel, this.maxLevel, xFontAllowance, xFontAllowance / 2, (int)(gdx - axisFontHeight * 2.0), true);
        double xUnitsPerPixel = xIntervals.getUnitsPerPixel();
        double[] xCoords = xIntervals.getLabelCoordinates();
        String[] xLabels = xIntervals.getLabels();
        double xDelta = xCoords[xCoords.length - 1] - xCoords[0];
        double xDeltaPix = xDelta / xUnitsPerPixel;
        testLayout = new TextLayout("100", axisFont, frc);
        fontR2D = testLayout.getBounds();
        double cWidth = fontR2D.getWidth();
        double vWidth = 0.0;
        for (int i2 = 0; i2 < vLabels.length; ++i2) {
            testLayout = new TextLayout(vLabels[i2], axisFont, frc);
            fontR2D = testLayout.getBounds();
            if (!(fontR2D.getWidth() > vWidth)) continue;
            vWidth = fontR2D.getWidth();
        }
        double x0 = wInPixels / 2.0 - xDeltaPix / 2.0 + (cWidth - vWidth);
        double x1 = x0 + xDeltaPix;
        double y0 = gTop;
        double y1 = gTop + cDeltaPix;
        g2d.setColor(Color.gray);
        g2d.setStroke(new BasicStroke(1.0f));
        if (titleLayout != null) {
            xLabel = (x0 + x1) / 2.0 - titleR2D.getCenterX();
            yLabel = -titleR2D.getY() + titleR2D.getHeight();
            titleLayout.draw(g2d, (float)xLabel, (float)yLabel);
        }
        Rectangle2D.Double graphRect = new Rectangle2D.Double(x0, y0, xDeltaPix, cDeltaPix);
        g2d.draw(graphRect);
        Line2D.Double l2d = new Line2D.Double();
        double yBoxTop = Double.POSITIVE_INFINITY;
        double xLabelMin = Double.POSITIVE_INFINITY;
        for (int i3 = 0; i3 < cCoords.length; ++i3) {
            double y2 = y1 - cCoords[i3] / cUnitsPerPixel;
            ((Line2D)l2d).setLine(x0, y2, x1, y2);
            g2d.draw(l2d);
            TextLayout tLayout = new TextLayout(cLabels[i3], axisFont, frc);
            Rectangle2D r2d = tLayout.getBounds();
            yLabel = y2 - r2d.getCenterY();
            xLabel = x0 - r2d.getMaxX() - 10.0;
            tLayout.draw(g2d, (float)xLabel, (float)yLabel);
            yBoxTop = y2;
            if (!(xLabel < xLabelMin)) continue;
            xLabelMin = xLabel;
        }
        String cLabel = "Estimated Capacity (percent)";
        TextLayout cLayout = new TextLayout(cLabel, axisFontRotated, frc);
        Rectangle2D cr2d = cLayout.getBounds();
        xLabel = xLabelMin + cr2d.getWidth() - axisFontHeight * 2.0;
        yLabel = (y0 + y1) / 2.0 - cr2d.getCenterY();
        cLayout.draw(g2d, (float)xLabel, (float)yLabel);
        double vMaxTextX = 0.0;
        for (i = 0; i < vCoords.length; ++i) {
            vLabels[i] = vLabels[i].trim();
            TextLayout tLayout = new TextLayout(vLabels[i], axisFont, frc);
            Rectangle2D r2d = tLayout.getBounds();
            if (!(r2d.getMaxX() > vMaxTextX)) continue;
            vMaxTextX = r2d.getWidth();
        }
        for (i = 0; i < vCoords.length && !((y = y1 - vCoords[i] / vUnitsPerPixel) < yBoxTop); ++i) {
            ((Line2D)l2d).setLine(x1, y, x1 + 5.0, y);
            g2d.draw(l2d);
            TextLayout tLayout = new TextLayout(vLabels[i], axisFont, frc);
            Rectangle2D r2d = tLayout.getBounds();
            yLabel = y - r2d.getCenterY();
            xLabel = x1 + 10.0 + vMaxTextX - r2d.getWidth();
            tLayout.draw(g2d, (float)xLabel, (float)yLabel);
        }
        String vLabel = "Computed Volume (" + this.unitOfVolume.getLabel() + ")";
        TextLayout vLayout = new TextLayout(vLabel, axisFontRotated, frc);
        Rectangle2D vr2d = vLayout.getBounds();
        xLabel = x1 + 10.0 + vMaxTextX - vr2d.getX() + axisFontHeight * 2.0;
        yLabel = (y0 + y1) / 2.0 - vr2d.getCenterY();
        vLayout.draw(g2d, (float)xLabel, (float)yLabel);
        yLabel = y1 + axisFontHeight * 2.0;
        for (int i4 = 0; i4 < xCoords.length; ++i4) {
            double x = x0 + (xCoords[i4] - xCoords[0]) / xUnitsPerPixel;
            l2d = new Line2D.Double(x, y0, x, y1);
            g2d.draw(l2d);
            TextLayout tLayout = new TextLayout(xLabels[i4], axisFont, frc);
            Rectangle2D r2d = tLayout.getBounds();
            xLabel = x - r2d.getCenterX();
            tLayout.draw(g2d, (float)xLabel, (float)yLabel);
        }
        String aLabel = "Water Surface Elevation (" + this.unitOfLength.getLabel() + ")";
        TextLayout aLayout = new TextLayout(aLabel, axisFont, frc);
        Rectangle2D ar2d = aLayout.getBounds();
        xLabel = (x0 + x1) / 2.0 - ar2d.getCenterX();
        yLabel = y1 + axisFontHeight * 4.0 - ar2d.getX();
        aLayout.draw(g2d, (float)xLabel, (float)yLabel);
        g2d.setClip(graphRect);
        Path2D.Double path = new Path2D.Double();
        boolean moveFlag = true;
        for (SvmTriangleVolumeStore.AreaVolumeResult avr : this.resultList) {
            double level = avr.level;
            double percent = 100.0 * avr.volume / this.totalVolume;
            double x = x0 + (level - xCoords[0]) / xUnitsPerPixel;
            double y3 = y1 - percent / cUnitsPerPixel;
            if (moveFlag) {
                moveFlag = false;
                ((Path2D)path).moveTo(x, y3);
                continue;
            }
            ((Path2D)path).lineTo(x, y3);
        }
        g2d.setColor(Color.BLUE);
        g2d.setStroke(new BasicStroke(2.0f, 1, 1));
        g2d.draw(path);
        g2d.setClip(null);
        ImageIO.write((RenderedImage)bImage, "PNG", outputFile);
        return false;
    }
}

