/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.svm;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import org.tinfour.gis.utils.ShapefileMetadataReporter;
import org.tinfour.svm.SvmBathymetryData;
import org.tinfour.svm.SvmComputation;
import org.tinfour.svm.properties.SvmFileSpecification;
import org.tinfour.svm.properties.SvmProperties;

public class SvmMain {
    private static final String[] usage = new String[]{"Usage information for Simple Volumetric Model (SVM)", "", "  -properties  <file> Input properties file path", "  -template           Prints an example properties file to the console", "  -inspect     <file or directory>   Inspects and reports on the content", "                      of the specified Shapefile and its associated", "                      DBF file.  If a directory is specified, reports", "                      on the content of every Shapefile in the directory"};

    private static void printUsageAndExit() {
        for (String s : usage) {
            System.out.println(s);
        }
        System.exit(0);
    }

    private static boolean isSpecified(String[] args, String target) {
        if (args != null && target != null) {
            for (String arg : args) {
                if (!target.equalsIgnoreCase(arg)) continue;
                return true;
            }
        }
        return false;
    }

    private static void checkForUsage(String[] args) {
        if (args == null || args.length == 0) {
            SvmMain.printUsageAndExit();
        } else if (SvmMain.isSpecified(args, "-?") || SvmMain.isSpecified(args, "-help")) {
            SvmMain.printUsageAndExit();
        }
    }

    private static void checkForTemplate(String[] args) {
        if (SvmMain.isSpecified(args, "-template")) {
            try (InputStream ins = SvmMain.class.getResourceAsStream("SvmTemplate.properties");){
                int c;
                while ((c = ins.read()) >= 0) {
                    System.out.append((char)c);
                }
                System.out.flush();
            }
            catch (IOException ioex) {
                System.err.println("Failed to load template " + ioex.getMessage());
            }
            System.exit(0);
        }
    }

    private static void checkForInspection(String[] args) throws IOException {
        int index = SvmProperties.indexArg(args, "-inspect", true);
        if (index < 0) {
            return;
        }
        File target = new File(args[index + 1]);
        if (!target.exists()) {
            throw new IllegalArgumentException("Inspection target does not exist " + target.getPath());
        }
        SvmMain.performShapefileInspection(target, System.out);
        System.exit(0);
    }

    private static void performShapefileInspection(File target, PrintStream ps) throws IOException {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                int n = name.length();
                if (n >= 5) {
                    int i = name.lastIndexOf(46);
                    return i > 0 && ".shp".equalsIgnoreCase(name.substring(i, n));
                }
                return false;
            }
        };
        if (target.isDirectory()) {
            String[] targets;
            for (String name : targets = target.list(filter)) {
                ps.println("\n------------------------------------------------");
                File t = new File(target, name);
                ShapefileMetadataReporter reporter = new ShapefileMetadataReporter(t, true);
                reporter.printReport(ps);
            }
        } else {
            String name = target.getName();
            if (!filter.accept(target, name)) {
                throw new IllegalArgumentException("Invalid Shapefile specification " + target.getPath());
            }
            ShapefileMetadataReporter reporter = new ShapefileMetadataReporter(target, true);
            reporter.printReport(ps);
        }
    }

    private SvmMain() {
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws IOException {
        void var9_15;
        File outputFolder;
        SvmMain.checkForUsage(args);
        SvmMain.checkForTemplate(args);
        SvmMain.checkForInspection(args);
        Date dateOfAnalysis = new Date();
        SvmMain.writeIntroduction(System.out, dateOfAnalysis);
        SvmProperties prop = SvmProperties.load(args);
        prop.writeSummary(System.out);
        File inputFolder = prop.getInputFolder();
        if (inputFolder != null && !inputFolder.exists()) {
            System.err.println("\nInput folder not found for " + inputFolder.getPath());
            System.exit(-1);
        }
        if ((outputFolder = prop.getOutputFolder()) != null && !outputFolder.exists()) {
            System.err.println("\nOutput folder not found for " + outputFolder.getPath());
            System.exit(-1);
        }
        SvmBathymetryData data = new SvmBathymetryData();
        List<SvmFileSpecification> bathyFiles = prop.getSampleSpecifications();
        for (SvmFileSpecification svmFileSpecification : bathyFiles) {
            data.loadSamples(svmFileSpecification.getFile(), svmFileSpecification.getField(), svmFileSpecification.getVerticalTransform());
        }
        List<SvmFileSpecification> supplementFiles = prop.getSupplementSpecifications();
        for (SvmFileSpecification svmFileSpecification : supplementFiles) {
            data.loadSupplement(svmFileSpecification.getFile(), svmFileSpecification.getField(), svmFileSpecification.getVerticalTransform());
        }
        List<SvmFileSpecification> list = prop.getBoundarySpecifications();
        for (SvmFileSpecification boundaryFile : list) {
            data.loadBoundaryConstraints(boundaryFile.getFile(), boundaryFile.getField(), boundaryFile.getVerticalTransform());
        }
        PrintStream printStream = System.out;
        FileOutputStream reportOutputStream = null;
        File reportFile = prop.getReportFile();
        if (reportFile != null) {
            reportOutputStream = new FileOutputStream(reportFile);
            BufferedOutputStream bos = new BufferedOutputStream(reportOutputStream);
            PrintStream printStream2 = new PrintStream((OutputStream)bos, true, "UTF-8");
            SvmMain.writeIntroduction(printStream2, dateOfAnalysis);
            prop.writeSummary(printStream2);
            printStream2.flush();
        }
        SvmComputation svmComp = new SvmComputation();
        svmComp.processVolume((PrintStream)var9_15, prop, data);
        var9_15.flush();
        if (reportOutputStream != null) {
            reportOutputStream.close();
        }
    }

    private static void writeIntroduction(PrintStream ps, Date date) {
        Locale locale = Locale.getDefault();
        SimpleDateFormat sdFormat = new SimpleDateFormat("dd MMM yyyy HH:mm", locale);
        sdFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        ps.println("Simple Volumetric Model (Version 1.0 beta)");
        ps.println("");
        ps.println("Date of analysis:  " + sdFormat.format(date) + " UTC");
    }
}

