/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.svm;

import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IIncrementalTinNavigator;
import org.tinfour.common.IQuadEdge;
import org.tinfour.interpolation.NaturalNeighborInterpolator;
import org.tinfour.svm.properties.SvmProperties;
import org.tinfour.utils.GridSpecification;
import org.tinfour.utils.KahanSummation;

class SvmRaster {
    SvmRaster() {
    }

    void buildAndWriteRaster(SvmProperties properties, PrintStream ps, IIncrementalTin tin, boolean[] water, double shoreReferenceElevation) {
        int nCells;
        int nCols;
        int nRows;
        long iMax;
        long jMax;
        long iMin;
        long jMin;
        File gridFile = properties.getGridFile();
        double s = properties.getGridCellSize();
        if (gridFile == null || Double.isNaN(s)) {
            return;
        }
        ps.println("");
        ps.println("Processing raster data");
        long maxMemory = Runtime.getRuntime().maxMemory();
        KahanSummation sum = new KahanSummation();
        Rectangle2D bounds = tin.getBounds();
        double xMin = bounds.getMinX();
        double yMin = bounds.getMinY();
        double xMax = bounds.getMaxX();
        double yMax = bounds.getMaxY();
        boolean cellSizeAdjusted = false;
        while (true) {
            jMin = (long)Math.floor(xMin / s);
            iMin = (long)Math.floor(yMin / s);
            jMax = (long)Math.ceil(xMax / s);
            iMax = (long)Math.ceil(yMax / s);
            nRows = (int)(iMax - iMin);
            nCells = nRows * (nCols = (int)(jMax - jMin));
            double memoryNeeded = (double)nCells * 4.0;
            if (!(memoryNeeded > (double)maxMemory * 0.75)) break;
            s *= 2.0;
            cellSizeAdjusted = true;
        }
        if (cellSizeAdjusted) {
            ps.println("Due to memory limits, cell size increased to " + s);
        }
        ps.format("  N Rows:    %8d%n", nRows);
        ps.format("  N Columns: %8d%n", nCols);
        ps.format("  Cell size: %8.3f%n", s);
        ps.println("");
        float[][] result = new float[nRows][nCols];
        long reportBlockSize = nRows / 10;
        long priorReportBlock = 0L;
        int nCovered = 0;
        IIncrementalTinNavigator navigator = tin.getNavigator();
        NaturalNeighborInterpolator nni = new NaturalNeighborInterpolator(tin);
        long time0 = System.nanoTime();
        for (long i = iMin; i < iMax; ++i) {
            int iRow = (int)(i - iMin);
            for (long j = jMin; j < jMax; ++j) {
                int jCol = (int)(j - jMin);
                double x = (double)j * s;
                double y = (double)i * s;
                IQuadEdge edge = navigator.getNeighborEdge(x, y);
                double z = -1.0;
                if (this.testWater(edge, water)) {
                    z = nni.interpolate(x, y, null);
                    if (z < shoreReferenceElevation) {
                        double c = (shoreReferenceElevation - z) * s * s;
                        sum.add(c);
                    } else {
                        z = -1.0;
                    }
                }
                if (z == -1.0) {
                    result[iRow][jCol] = Float.NaN;
                    continue;
                }
                ++nCovered;
                result[iRow][jCol] = (float)z;
            }
            long reportBlock = (long)iRow / reportBlockSize;
            if (reportBlock <= priorReportBlock) continue;
            priorReportBlock = reportBlock;
            ps.format("%2d%% complete%n", reportBlock * 10L);
            ps.flush();
        }
        long time1 = System.nanoTime();
        ps.format("Time to Process Raster  %3.1f seconds %n", (double)(time1 - time0) / 1.0E9);
        String areaUnits = properties.getUnitOfArea().getLabel();
        double areaFactor = properties.getUnitOfArea().getScaleFactor();
        String volumeUnits = properties.getUnitOfVolume().getLabel();
        double volumeFactor = properties.getUnitOfVolume().getScaleFactor();
        int n = sum.getSummandCount();
        double surfArea = (double)n * s * s / areaFactor;
        double volume = sum.getSum() / volumeFactor;
        ps.format("%nComputations from Raster Methods%n", new Object[0]);
        ps.format("  Volume              %10.8e %,20.0f %s%n", volume, volume, volumeUnits);
        ps.format("  Surface Area        %10.8e %,20.0f %s%n", surfArea, surfArea, areaUnits);
        ps.format("  Percent Covered     %4.1f%%%n", 100.0 * (double)nCovered / (double)nCells);
        ps.println("");
        ps.format("%nWriting output to %s%n", gridFile.getPath());
        ps.flush();
        GridSpecification grid = new GridSpecification(GridSpecification.CellPosition.CenterOfCell, s, xMin, xMax, yMin, yMax);
        try {
            grid.writeAsciiFile(gridFile, result, "%4.1f", "-1");
        }
        catch (IOException ioex) {
            ps.println("Write operation failed " + ioex.getMessage());
        }
    }

    boolean testWater(IQuadEdge edge, boolean[] water) {
        if (edge.isConstrainedRegionInterior()) {
            int index = edge.getConstraintIndex();
            return water[index];
        }
        IQuadEdge fwd = edge.getForward();
        if (fwd.isConstrainedRegionInterior()) {
            int index = fwd.getConstraintIndex();
            return water[index];
        }
        IQuadEdge rev = edge.getReverse();
        if (rev.isConstrainedRegionInterior()) {
            int index = rev.getConstraintIndex();
            return water[index];
        }
        return false;
    }
}

