/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.svm;

import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.tinfour.common.GeometricOperations;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.PolygonConstraint;
import org.tinfour.common.SimpleTriangle;
import org.tinfour.common.Thresholds;
import org.tinfour.common.Vertex;
import org.tinfour.semivirtual.SemiVirtualIncrementalTin;
import org.tinfour.standard.IncrementalTin;
import org.tinfour.svm.SvmBathymetryData;
import org.tinfour.svm.SvmCapacityGraph;
import org.tinfour.svm.SvmContourGraph;
import org.tinfour.svm.SvmFlatFixer;
import org.tinfour.svm.SvmRaster;
import org.tinfour.svm.SvmRefinement;
import org.tinfour.svm.SvmTriangleVolumeStore;
import org.tinfour.svm.properties.SvmProperties;
import org.tinfour.utils.HilbertSort;
import org.tinfour.utils.KahanSummation;
import org.tinfour.utils.TriangleCollector;

public class SvmComputation {
    public void processVolume(PrintStream ps, SvmProperties properties, SvmBathymetryData data) throws IOException {
        File contourOutput;
        String lengthUnits = properties.getUnitOfDistance().getLabel();
        double lengthFactor = properties.getUnitOfDistance().getScaleFactor();
        String areaUnits = properties.getUnitOfArea().getLabel();
        double areaFactor = properties.getUnitOfArea().getScaleFactor();
        String volumeUnits = properties.getUnitOfVolume().getLabel();
        double volumeFactor = properties.getUnitOfVolume().getScaleFactor();
        double shoreReferenceElevation = properties.getShorelineReferenceElevation();
        if (Double.isNaN(shoreReferenceElevation)) {
            shoreReferenceElevation = data.getShoreReferenceElevation();
        }
        List<Vertex> soundings = data.getSoundingsAndSupplements();
        List<PolygonConstraint> boundaryConstraints = data.getBoundaryConstraints();
        ArrayList<PolygonConstraint> allConstraints = new ArrayList<PolygonConstraint>();
        allConstraints.addAll(boundaryConstraints);
        if (soundings.isEmpty()) {
            ps.print("Unable to proceed, no soundings are available");
            ps.flush();
            throw new IOException("No soungings availble");
        }
        if (boundaryConstraints.isEmpty()) {
            ps.print("Unable to proceed, no boundary constraints are available");
            ps.flush();
            throw new IOException("No boundary constraints availble");
        }
        long time0 = System.nanoTime();
        Object tin = soundings.size() < 500000 ? new IncrementalTin(1.0) : new SemiVirtualIncrementalTin(1.0);
        tin.add(soundings, null);
        long time1 = System.nanoTime();
        tin.addConstraints(allConstraints, true);
        long time2 = System.nanoTime();
        long timeToBuildTin = time1 - time0;
        long timeToAddConstraints = time2 - time1;
        TriangleSurvey trigSurvey = new TriangleSurvey((IIncrementalTin)tin, shoreReferenceElevation);
        TriangleCollector.visitSimpleTriangles((IIncrementalTin)tin, (Consumer)trigSurvey);
        long timeToFixFlats = 0L;
        if (properties.isFlatFixerEnabled()) {
            SvmFlatFixer flatFixer;
            List<Vertex> fixList;
            long timeF0 = System.nanoTime();
            int nRemediationVertices = 0;
            ps.println("");
            ps.println("Remediating flat triangles");
            System.out.println("Pass   Remediated        Area     Volume Added    avg. depth");
            for (int iFlat = 0; iFlat < 500 && !(fixList = (flatFixer = new SvmFlatFixer((IIncrementalTin)tin, shoreReferenceElevation)).fixFlats(ps)).isEmpty(); ++iFlat) {
                if (iFlat % 10 == 0) {
                    double fixArea = flatFixer.getRemediatedArea();
                    double fixVolume = flatFixer.getRemediatedVolume();
                    System.out.format("%4d  %8d  %14.3f  %14.3f  %7.3f%n", iFlat, flatFixer.getRemediationCount(), fixArea / areaFactor, fixVolume / volumeFactor, fixVolume / fixArea / lengthFactor);
                }
                nRemediationVertices += fixList.size();
                soundings.addAll(fixList);
            }
            ps.println("N remediation vertices added: " + nRemediationVertices);
            tin.dispose();
            tin = soundings.size() < 500000 ? new IncrementalTin(1.0) : new SemiVirtualIncrementalTin(1.0);
            HilbertSort hilbert = new HilbertSort();
            hilbert.sort(soundings);
            tin.add(soundings, null);
            tin.addConstraints(allConstraints, true);
            long timeF1 = System.nanoTime();
            timeToFixFlats = timeF1 - timeF0;
        }
        ps.println("");
        ps.println("Processing data from Delaunay Triangulation");
        time1 = System.nanoTime();
        LakeData lakeConsumer = new LakeData((IIncrementalTin)tin, shoreReferenceElevation);
        TriangleCollector.visitSimpleTriangles((IIncrementalTin)tin, (Consumer)lakeConsumer);
        SvmTriangleVolumeStore vStore = lakeConsumer.volumeStore;
        double tableInterval = properties.getTableInterval();
        double zShore = data.shoreReferenceElevation;
        double zMin = data.getMinZ();
        int nStep = (int)(Math.ceil(zShore - zMin) / tableInterval) + 1;
        if (nStep > 10000) {
            nStep = 10000;
        }
        ArrayList<SvmTriangleVolumeStore.AreaVolumeResult> resultList = new ArrayList<SvmTriangleVolumeStore.AreaVolumeResult>(nStep);
        for (int i = 0; i < nStep; ++i) {
            double zTest = zShore - (double)i * tableInterval;
            SvmTriangleVolumeStore.AreaVolumeResult result = vStore.compute(zTest);
            resultList.add(result);
            if (result.volume == 0.0) break;
        }
        time2 = System.nanoTime();
        List<PolygonConstraint> lakeConstraints = data.getLakeConstraints();
        List<PolygonConstraint> islandConstraints = data.getIslandConstraints();
        double lakeArea = this.getAreaSum(lakeConstraints) / areaFactor;
        double islandArea = Math.abs(this.getAreaSum(islandConstraints) / areaFactor);
        double lakePerimeter = this.getPerimeterSum(lakeConstraints) / lengthFactor;
        double islandPerimeter = this.getPerimeterSum(islandConstraints) / lengthFactor;
        double netArea = lakeArea - islandArea;
        double totalShore = lakePerimeter + islandPerimeter;
        Rectangle2D bounds = data.getBounds();
        ps.format("%nData from Shapefiles --------------------------------------------------------------%n", new Object[0]);
        ps.format("  Lake area           %,18.2f %s%n", lakeArea, areaUnits);
        ps.format("  Island area         %,18.2f %s%n", islandArea, areaUnits);
        ps.format("  Net area (water)    %,18.2f %s%n", netArea, areaUnits);
        ps.format("  Lake shoreline      %,18.2f %s%n", lakePerimeter, lengthUnits);
        ps.format("  Island shoreline    %,18.2f %s%n", islandPerimeter, lengthUnits);
        ps.format("  Total shoreline     %,18.2f %s%n", totalShore, lengthUnits);
        ps.format("  N Islands           %18d%n", islandConstraints.size());
        ps.format("  N Soundings         %18d%n", data.getSoundings().size());
        ps.format("  N Supplements       %18d%n", data.getSupplements().size());
        ps.format("  Bounds%n", new Object[0]);
        ps.format("     x:    %12.3f, %12.3f, (%5.3f)%n", bounds.getMinX() / lengthFactor, bounds.getMaxX() / lengthFactor, bounds.getWidth() / lengthFactor);
        ps.format("     y:    %12.3f, %12.3f, (%5.3f)%n", bounds.getMinY() / lengthFactor, bounds.getMaxY() / lengthFactor, bounds.getHeight() / lengthFactor);
        ps.format("     z:    %12.3f, %12.3f, (%5.3f)%n", data.getMinZ() / lengthFactor, data.getMaxZ() / lengthFactor, (data.getMaxZ() - data.getMinZ()) / lengthFactor);
        if (properties.isSoundingSpacingEnabled()) {
            List<Vertex> originalSoundings = data.getSoundings();
            double[] lenArray = new double[originalSoundings.size()];
            double sumLen = 0.0;
            int nLen = 0;
            Vertex prior = null;
            for (Vertex v : originalSoundings) {
                if (prior != null) {
                    double len = v.getDistance(prior);
                    sumLen += len;
                    lenArray[nLen++] = len;
                }
                prior = v;
            }
            Arrays.sort(lenArray, 0, nLen);
            double meanLen = sumLen / (double)nLen;
            double medianLen = lenArray[nLen / 2];
            ps.format("  Mean sounding spacing:   %12.3f %s%n", meanLen / lengthFactor, lengthUnits);
            ps.format("  Median sounding spacing: %12.3f %s%n", medianLen, lengthUnits);
            ps.format("%n", new Object[0]);
        }
        double rawVolume = lakeConsumer.getVolume();
        double rawSurfArea = lakeConsumer.getSurfaceArea();
        double rawAdjMeanDepth = lakeConsumer.getAdjustedMeanDepth();
        double totalVolume = lakeConsumer.getVolume();
        double volume = lakeConsumer.getVolume() / volumeFactor;
        double surfArea = lakeConsumer.getSurfaceArea() / areaFactor;
        double avgDepth = rawVolume / rawSurfArea / lengthFactor;
        double adjMeanDepth = rawAdjMeanDepth / lengthFactor;
        double vertexSpacing = this.estimateInteriorVertexSpacing((IIncrementalTin)tin, lakeConsumer);
        double rawFlatArea = lakeConsumer.getFlatArea();
        double flatArea = lakeConsumer.getFlatArea() / areaFactor;
        ps.format("%nComputations from Constrained Delaunay Triangulation -----------------------------%n", new Object[0]);
        ps.format("  Volume              %,18.2f %s     %,28.1f %s^3%n", volume, volumeUnits, rawVolume, lengthUnits);
        ps.format("  Surface Area        %,18.2f %s     %,28.1f %s^2%n", surfArea, areaUnits, rawSurfArea, lengthUnits);
        ps.format("  Flat Area           %,18.2f %s     %,28.1f %s^2%n", flatArea, areaUnits, rawFlatArea, lengthUnits);
        ps.format("  Avg depth           %,18.2f %s%n", avgDepth, lengthUnits);
        ps.format("  Adj mean depth      %,18.2f %s%n", adjMeanDepth, lengthUnits);
        ps.format("  Mean Vertex Spacing %,18.2f %s%n", vertexSpacing, lengthUnits);
        ps.format("  N Triangles         %15d%n", lakeConsumer.nTriangles);
        ps.format("  N Flat Triangles    %15d%n", lakeConsumer.nFlatTriangles);
        if (properties.isFlatFixerEnabled()) {
            int originalTrigCount = trigSurvey.nTriangles;
            int originalFlatCount = trigSurvey.getFlatTriangleCount();
            double originalFlatArea = trigSurvey.getFlatArea() / areaFactor;
            ps.format("%nPre-Remediation statistics%n", new Object[0]);
            ps.format("  Original Flat Area  %14.10e %,20.2f %s%n", originalFlatArea, originalFlatArea, areaUnits);
            ps.format("  Original N Triangle %d%n", originalTrigCount);
            ps.format("  Original N Flat     %d%n", originalFlatCount);
        }
        ps.format("%n%n%n", new Object[0]);
        ps.format("Time to load data              %9.1f ms%n", (double)data.getTimeToLoadData() / 1000000.0);
        ps.format("Time to build TIN              %9.1f ms%n", (double)timeToBuildTin / 1000000.0);
        ps.format("Time to add shore constraint   %9.1f ms%n", (double)timeToAddConstraints / 1000000.0);
        ps.format("Time to remedy flat triangles  %9.1f ms%n", (double)timeToFixFlats / 1000000.0);
        ps.format("Time to compute lake volume    %9.1f ms%n", (double)(time2 - time1) / 1000000.0);
        ps.format("Time for all analysis          %9.1f ms%n", (double)(time2 - time0) / 1000000.0);
        ps.format("Time for all operations        %9.1f ms%n", (double)(data.getTimeToLoadData() + time2 - time0) / 1000000.0);
        ps.format("%n%nVolume Store Triangle Count: %d%n", vStore.getTriangleCount());
        File tableFile = properties.getTableFile();
        if (tableFile != null) {
            try (FileOutputStream tableOutputStream = new FileOutputStream(tableFile);
                 BufferedOutputStream bos = new BufferedOutputStream(tableOutputStream);
                 PrintStream ts = new PrintStream((OutputStream)bos, true, "UTF-8");){
                ts.println("Elevation, Area, Volume, Percent_Capacity");
                for (SvmTriangleVolumeStore.AreaVolumeResult result : resultList) {
                    ts.format("%12.3f, %12.3f, %12.3f, %6.2f%n", result.level, result.area / areaFactor, result.volume / volumeFactor, 100.0 * result.volume / totalVolume);
                }
            }
            catch (IOException ioex) {
                ps.println("Serious error writing elevation/volume table " + ioex.getMessage());
            }
        }
        File gridFile = properties.getGridFile();
        double s = properties.getGridCellSize();
        if (gridFile != null && !Double.isNaN(s)) {
            SvmRaster grid = new SvmRaster();
            grid.buildAndWriteRaster(properties, data, ps, (IIncrementalTin)tin, lakeConsumer.water, shoreReferenceElevation);
        } else {
            File gridImageFile = properties.getGridImageFile();
            if (gridImageFile != null) {
                ps.println("\nNote: The properties specify a grid-image file " + gridImageFile.getPath());
                ps.println("but not a grid file. An image file cannot be produced");
                ps.println("without a valid grid file.\n");
            }
        }
        SvmCapacityGraph capacityGraph = new SvmCapacityGraph(properties, resultList, totalVolume);
        boolean wroteGraph = capacityGraph.writeOutput();
        if (wroteGraph) {
            ps.println("Capacity graph written to " + properties.getCapacityGraphFile());
        }
        if ((contourOutput = properties.getContourGraphFile()) != null) {
            ps.println("\nIn preparation for contouring, subdividing large triangles");
            SvmRefinement refinement = new SvmRefinement();
            List<Vertex> vList = refinement.subdivideLargeTriangles(ps, (IIncrementalTin)tin, 0.95);
            if (!vList.isEmpty()) {
                tin.dispose();
                soundings.addAll(vList);
                HilbertSort hilbert = new HilbertSort();
                hilbert.sort(soundings);
                tin = soundings.size() < 500000 ? new IncrementalTin(1.0) : new SemiVirtualIncrementalTin(1.0);
                tin.add(soundings, null);
                tin.addConstraints(allConstraints, true);
            }
            SvmContourGraph.write(ps, properties, data, shoreReferenceElevation, (IIncrementalTin)tin);
        }
    }

    private double getAreaSum(List<PolygonConstraint> constraints) {
        KahanSummation areaSum = new KahanSummation();
        for (PolygonConstraint con : constraints) {
            areaSum.add(con.getArea());
        }
        return areaSum.getSum();
    }

    private double getPerimeterSum(List<PolygonConstraint> constraints) {
        KahanSummation perimeterSum = new KahanSummation();
        for (PolygonConstraint con : constraints) {
            perimeterSum.add(con.getLength());
        }
        return perimeterSum.getSum();
    }

    private double estimateInteriorVertexSpacing(IIncrementalTin tin, LakeData lakeData) {
        KahanSummation sumLength = new KahanSummation();
        int n = 0;
        for (IQuadEdge e : tin.edges()) {
            if (!lakeData.isWater(e)) continue;
            Vertex a = e.getA();
            int aAux = a.getAuxiliaryIndex();
            int bAux = a.getAuxiliaryIndex();
            if (aAux != 1 || bAux != 1) continue;
            ++n;
            sumLength.add(e.getLength());
        }
        if (n == 0) {
            return 0.0;
        }
        return sumLength.getSum() / (double)n;
    }

    private static class TriangleSurvey
    implements Consumer<SimpleTriangle> {
        double shoreReferenceElevation;
        boolean[] water;
        int nTriangles;
        int nFlatTriangles;
        KahanSummation areaSum = new KahanSummation();
        KahanSummation flatAreaSum = new KahanSummation();
        KahanSummation depthAreaSum = new KahanSummation();
        KahanSummation depthAreaWeightedSum = new KahanSummation();
        final GeometricOperations geoOp;

        TriangleSurvey(IIncrementalTin tin, double shoreReferenceElevation) {
            this.shoreReferenceElevation = shoreReferenceElevation;
            List constraintsFromTin = tin.getConstraints();
            this.water = new boolean[constraintsFromTin.size()];
            for (IConstraint con : constraintsFromTin) {
                this.water[con.getConstraintIndex()] = (Boolean)con.getApplicationData();
            }
            Thresholds thresholds = tin.getThresholds();
            this.geoOp = new GeometricOperations(thresholds);
        }

        private boolean nEqual(double a, double b) {
            return Math.abs(a - b) < 1.0E-5;
        }

        @Override
        public void accept(SimpleTriangle t) {
            Boolean appData;
            IConstraint constraint = t.getContainingRegion();
            if (constraint instanceof PolygonConstraint && (appData = (Boolean)constraint.getApplicationData()).booleanValue()) {
                IQuadEdge a = t.getEdgeA();
                IQuadEdge b = t.getEdgeB();
                IQuadEdge c = t.getEdgeC();
                Vertex vA = a.getA();
                Vertex vB = b.getA();
                Vertex vC = c.getA();
                double zA = vA.getZ();
                double zB = vB.getZ();
                double zC = vC.getZ();
                double area = this.geoOp.area(vA, vB, vC);
                if (this.nEqual(zA, this.shoreReferenceElevation) && this.nEqual(zB, this.shoreReferenceElevation) && this.nEqual(zC, this.shoreReferenceElevation)) {
                    ++this.nFlatTriangles;
                    this.flatAreaSum.add(area);
                } else if (zA < this.shoreReferenceElevation || zB < this.shoreReferenceElevation || zC < this.shoreReferenceElevation) {
                    this.depthAreaSum.add(area);
                    this.depthAreaWeightedSum.add(area * (this.shoreReferenceElevation - (zA + zB + zC) / 3.0));
                }
                ++this.nTriangles;
                this.areaSum.add(area);
            }
        }

        double getSurfaceArea() {
            return this.areaSum.getSum();
        }

        double getFlatArea() {
            return this.flatAreaSum.getSum();
        }

        int getFlatTriangleCount() {
            return this.nFlatTriangles;
        }

        double getMeanDepth() {
            return this.depthAreaWeightedSum.getSum() / this.depthAreaSum.getSum();
        }
    }

    private static class LakeData
    implements Consumer<SimpleTriangle> {
        double shoreReferenceElevation;
        boolean[] water;
        final GeometricOperations geoOp;
        int nTriangles;
        int nFlatTriangles;
        KahanSummation volumeSum = new KahanSummation();
        KahanSummation areaSum = new KahanSummation();
        KahanSummation flatAreaSum = new KahanSummation();
        KahanSummation depthAreaSum = new KahanSummation();
        KahanSummation depthAreaWeightedSum = new KahanSummation();
        SvmTriangleVolumeStore volumeStore;

        LakeData(IIncrementalTin tin, double shoreReferenceElevation) {
            this.shoreReferenceElevation = shoreReferenceElevation;
            List constraintsFromTin = tin.getConstraints();
            this.water = new boolean[constraintsFromTin.size()];
            for (IConstraint con : constraintsFromTin) {
                this.water[con.getConstraintIndex()] = (Boolean)con.getApplicationData();
            }
            Thresholds thresholds = tin.getThresholds();
            this.geoOp = new GeometricOperations(thresholds);
            this.volumeStore = new SvmTriangleVolumeStore(thresholds);
        }

        private boolean nEqual(double a, double b) {
            return Math.abs(a - b) < 1.0E-5;
        }

        @Override
        public void accept(SimpleTriangle t) {
            Boolean appData;
            IConstraint constraint = t.getContainingRegion();
            if (constraint instanceof PolygonConstraint && (appData = (Boolean)constraint.getApplicationData()).booleanValue()) {
                IQuadEdge a = t.getEdgeA();
                IQuadEdge b = t.getEdgeB();
                IQuadEdge c = t.getEdgeC();
                Vertex vA = a.getA();
                Vertex vB = b.getA();
                Vertex vC = c.getA();
                double zA = vA.getZ();
                double zB = vB.getZ();
                double zC = vC.getZ();
                double zMean = (zA + zB + zC) / 3.0;
                double area = this.geoOp.area(vA, vB, vC);
                if (this.nEqual(zA, this.shoreReferenceElevation) && this.nEqual(zB, this.shoreReferenceElevation) && this.nEqual(zC, this.shoreReferenceElevation)) {
                    ++this.nFlatTriangles;
                    this.flatAreaSum.add(area);
                } else if (zA < this.shoreReferenceElevation || zB < this.shoreReferenceElevation || zC < this.shoreReferenceElevation) {
                    this.depthAreaSum.add(area);
                    this.depthAreaWeightedSum.add(area * (this.shoreReferenceElevation - (zA + zB + zC) / 3.0));
                }
                ++this.nTriangles;
                double vtest = (this.shoreReferenceElevation - zMean) * area;
                this.volumeStore.addTriangle(vA, vB, vC, vtest);
                this.volumeSum.add(vtest);
                this.areaSum.add(area);
            }
        }

        boolean hasDepth(IQuadEdge edge) {
            IQuadEdge e = edge.getReverseFromDual();
            Vertex v = e.getA();
            return v != null && v.getZ() < this.shoreReferenceElevation - 0.1;
        }

        boolean isWater(IQuadEdge edge) {
            if (edge.isConstrainedRegionBorder()) {
                return false;
            }
            if (edge.isConstrainedRegionInterior()) {
                int index = edge.getConstraintIndex();
                return this.water[index];
            }
            return false;
        }

        double getVolume() {
            return Math.abs(this.volumeSum.getSum());
        }

        double getSurfaceArea() {
            return this.areaSum.getSum();
        }

        double getFlatArea() {
            return this.flatAreaSum.getSum();
        }

        double getAdjustedMeanDepth() {
            return this.depthAreaWeightedSum.getSum() / this.depthAreaSum.getSum();
        }
    }
}

