/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.svm;

import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import javax.imageio.ImageIO;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IIncrementalTinNavigator;
import org.tinfour.common.IQuadEdge;
import org.tinfour.interpolation.NaturalNeighborInterpolator;
import org.tinfour.svm.SvmBathymetryData;
import org.tinfour.svm.SvmBathymetryModel;
import org.tinfour.svm.SvmMain;
import org.tinfour.svm.properties.SvmProperties;
import org.tinfour.utils.KahanSummation;

class SvmRaster {
    private static final int[][] paletteB2Y = new int[][]{{0, 0, 255}, {0, 34, 255}, {0, 50, 255}, {0, 63, 255}, {0, 73, 255}, {0, 82, 255}, {0, 90, 255}, {0, 97, 255}, {0, 104, 255}, {0, 110, 255}, {0, 116, 255}, {0, 121, 255}, {0, 127, 255}, {0, 132, 255}, {0, 136, 255}, {0, 141, 255}, {0, 145, 255}, {0, 149, 255}, {0, 153, 255}, {0, 157, 255}, {0, 160, 255}, {0, 164, 255}, {0, 167, 255}, {0, 170, 255}, {0, 174, 255}, {0, 177, 255}, {0, 180, 255}, {0, 183, 255}, {0, 186, 255}, {0, 189, 255}, {0, 192, 255}, {0, 195, 249}, {0, 198, 241}, {0, 201, 233}, {0, 203, 224}, {0, 206, 216}, {0, 209, 207}, {0, 212, 199}, {0, 214, 190}, {0, 217, 181}, {0, 220, 173}, {0, 222, 164}, {0, 225, 156}, {0, 227, 147}, {0, 230, 139}, {0, 232, 131}, {0, 234, 122}, {0, 236, 114}, {0, 238, 106}, {0, 240, 98}, {0, 242, 90}, {0, 244, 82}, {0, 245, 74}, {65, 247, 67}, {94, 248, 59}, {117, 250, 51}, {136, 251, 42}, {154, 252, 34}, {170, 253, 25}, {186, 253, 15}, {200, 254, 4}, {215, 254, 0}, {228, 255, 0}, {242, 255, 0}, {255, 255, 0}};

    SvmRaster() {
    }

    private int getRgb(double z, double zMin, double zMax) {
        int b;
        int g;
        int r;
        double t = (z - zMin) / (zMax - zMin);
        double s = t * (double)paletteB2Y.length;
        if (s <= 0.0) {
            r = paletteB2Y[0][0];
            g = paletteB2Y[0][1];
            b = paletteB2Y[0][2];
        } else if (s >= (double)(paletteB2Y.length - 1)) {
            r = paletteB2Y[paletteB2Y.length - 1][0];
            g = paletteB2Y[paletteB2Y.length - 1][1];
            b = paletteB2Y[paletteB2Y.length - 1][2];
        } else {
            int i = (int)s;
            t = s - (double)i;
            double r0 = paletteB2Y[i][0];
            double g0 = paletteB2Y[i][1];
            double b0 = paletteB2Y[i][2];
            double r1 = paletteB2Y[i + 1][0];
            double g1 = paletteB2Y[i + 1][1];
            double b1 = paletteB2Y[i + 1][2];
            r = (int)(t * (r1 - r0) + r0 + 0.5);
            g = (int)(t * (g1 - g0) + g0 + 0.5);
            b = (int)(t * (b1 - b0) + b0 + 0.5);
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    void buildAndWriteRaster(SvmProperties properties, SvmBathymetryData data, PrintStream ps, IIncrementalTin tin, boolean[] water, double shoreReferenceElevation) {
        Object bos;
        String worldFileExtension;
        File gridParent;
        int k;
        File gridFile = properties.getGridFile();
        double s = properties.getGridCellSize();
        if (gridFile == null || Double.isNaN(s)) {
            return;
        }
        String gridRootName = gridFile.getName();
        if (gridRootName.length() > 4 && gridRootName.charAt(k = gridRootName.length() - 4) == '.' && Character.isLetterOrDigit(gridRootName.charAt(k + 1)) && Character.isLetterOrDigit(gridRootName.charAt(k + 2)) && Character.isLetterOrDigit(gridRootName.charAt(k + 3))) {
            gridRootName = gridRootName.substring(0, gridRootName.length() - 4);
        }
        if ((gridParent = gridFile.getParentFile()) == null) {
            gridParent = new File(".");
        }
        boolean useDepthModel = false;
        double noDataValue = -9999.0;
        if (properties.isBathymetryModelSpecified()) {
            SvmBathymetryModel bathyModel = properties.getBathymetryModel();
            if (bathyModel.isDepth()) {
                useDepthModel = true;
                noDataValue = 1.0;
            } else {
                useDepthModel = false;
                noDataValue = -9999.0;
            }
        }
        ps.println("");
        ps.println("Processing raster data");
        boolean status = this.writeAuxiliaryFile(ps, data, gridFile, "SvmRasterTemplate.aux.xml");
        if (!status) {
            return;
        }
        KahanSummation sum = new KahanSummation();
        Rectangle2D bounds = tin.getBounds();
        double xMin = bounds.getMinX();
        double yMin = bounds.getMinY();
        double xMax = bounds.getMaxX();
        double yMax = bounds.getMaxY();
        long jMin = (long)Math.floor(xMin / s);
        long iMin = (long)Math.floor(yMin / s);
        long jMax = (long)Math.ceil(xMax / s);
        long iMax = (long)Math.ceil(yMax / s);
        int nRows = (int)(iMax - iMin) + 1;
        int nCols = (int)(jMax - jMin) + 1;
        xMin = (double)jMin * s;
        xMax = (double)jMax * s;
        yMin = (double)iMin * s;
        yMax = (double)iMax * s;
        int nCells = nRows * nCols;
        double cellSize = s;
        ps.format("  N Rows:    %8d%n", nRows);
        ps.format("  N Columns: %8d%n", nCols);
        ps.format("  Cell size: %8.3f%n", s);
        ps.println("");
        File headerFile = new File(gridParent, gridRootName + ".hdr");
        gridFile = new File(gridParent, gridRootName + ".flt");
        if (headerFile.exists()) {
            headerFile.delete();
        }
        if (gridFile.exists()) {
            gridFile.delete();
        }
        try (FileOutputStream headerStream = new FileOutputStream(headerFile);
             BufferedOutputStream bos2 = new BufferedOutputStream(headerStream);
             PrintStream headerPs = new PrintStream((OutputStream)bos2, true, StandardCharsets.US_ASCII.name());){
            headerPs.format("NCOLS %d%n", nCols);
            headerPs.format("NROWS %d%n", nRows);
            headerPs.format("XLLCENTER %f%n", xMin);
            headerPs.format("YLLCENTER %f%n", yMin);
            headerPs.format("CELLSIZE %f%n", s);
            headerPs.format("NODATA_VALUE %f%n", noDataValue);
            headerPs.format("BYTEORDER MSBFIRST%n", new Object[0]);
        }
        catch (IOException ioex) {
            ps.println("Failure: Fatal I/O exception writing grid file " + headerFile + ": " + ioex.getMessage());
            return;
        }
        double zMin = Double.POSITIVE_INFINITY;
        double zMax = Double.NEGATIVE_INFINITY;
        long time0 = System.nanoTime();
        int nCovered = 0;
        int nUncovered = 0;
        try (FileOutputStream gridStream = new FileOutputStream(gridFile);
             BufferedOutputStream bos3 = new BufferedOutputStream(gridStream);
             DataOutputStream dos = new DataOutputStream(bos3);){
            IIncrementalTinNavigator navigator = tin.getNavigator();
            NaturalNeighborInterpolator nni = new NaturalNeighborInterpolator(tin);
            double reportingThreshold = 0.0;
            for (int iRow = 0; iRow < nRows; ++iRow) {
                double percentDone = (double)iRow * 100.0 / (double)nRows;
                if (percentDone >= reportingThreshold) {
                    System.out.format("Raster processing %3.0f%% done%n", reportingThreshold);
                    reportingThreshold += 10.0;
                }
                double y = yMax - (double)iRow * s;
                for (int iCol = 0; iCol < nCols; ++iCol) {
                    double x = xMin + (double)iCol * s;
                    IQuadEdge edge = navigator.getNeighborEdge(x, y);
                    IConstraint con = tin.getRegionConstraint(edge);
                    double zValue = 1.0;
                    if (con == null || !water[con.getConstraintIndex()]) {
                        zValue = noDataValue;
                        ++nUncovered;
                    } else {
                        double z = nni.interpolate(x, y, null);
                        if (Double.isFinite(z)) {
                            zValue = useDepthModel ? (z > 0.0 ? 0.0 : z) : z;
                            ++nCovered;
                            sum.add(-zValue);
                            if (zValue < zMin) {
                                zMin = zValue;
                            }
                            if (zValue > zMax) {
                                zMax = zValue;
                            }
                        } else {
                            ++nUncovered;
                            zValue = noDataValue;
                        }
                    }
                    dos.writeFloat((float)zValue);
                }
            }
        }
        catch (IOException ioex) {
            ps.println("Failure: I/O exception writing grid file " + gridFile + ": " + ioex.getMessage());
            return;
        }
        long time1 = System.nanoTime();
        ps.format("Time to Process Raster  %3.1f seconds %n", (double)(time1 - time0) / 1.0E9);
        System.out.format("Time to Process Raster  %3.1f seconds %n", (double)(time1 - time0) / 1.0E9);
        String lengthUnits = properties.getUnitOfDistance().getLabel();
        String areaUnits = properties.getUnitOfArea().getLabel();
        double areaFactor = properties.getUnitOfArea().getScaleFactor();
        String volumeUnits = properties.getUnitOfVolume().getLabel();
        double volumeFactor = properties.getUnitOfVolume().getScaleFactor();
        int n = sum.getSummandCount();
        double rawSurfArea = (double)n * s * s;
        double rawVolume = sum.getSum() * s * s;
        double surfArea = rawSurfArea / areaFactor;
        double volume = rawVolume / volumeFactor;
        ps.format("%nComputations from Raster Methods%n", new Object[0]);
        ps.format("  Volume              %,18.2f %s     %,28.1f %s^3%n", volume, volumeUnits, rawVolume, lengthUnits);
        ps.format("  Surface Area        %,18.2f %s     %,28.1f %s^2%n", surfArea, areaUnits, rawSurfArea, lengthUnits);
        ps.format("  Percent Covered     %4.1f%%%n", 100.0 * (double)nCovered / (double)nCells);
        ps.format("  Percent Uncovered   %4.1f%%%n", 100.0 * (double)nUncovered / (double)nCells);
        ps.println("");
        File imageFile = properties.getGridImageFile();
        if (imageFile == null) {
            return;
        }
        String imageFormat = null;
        String test = imageFile.getName().toLowerCase();
        String imageFileRootName = imageFile.getName();
        boolean useAlpha = false;
        if (test.endsWith(".png")) {
            imageFormat = "PNG";
            worldFileExtension = ".pgw";
            useAlpha = true;
            imageFileRootName = imageFileRootName.substring(0, imageFileRootName.length() - 4);
        } else if (test.endsWith(".jpg")) {
            imageFormat = "JPG";
            worldFileExtension = ".jgw";
            imageFileRootName = imageFileRootName.substring(0, imageFileRootName.length() - 4);
        } else if (test.endsWith(".jpeg")) {
            imageFormat = "JPG";
            worldFileExtension = ".jgw";
            imageFileRootName = imageFileRootName.substring(0, imageFileRootName.length() - 5);
        } else {
            ps.println("Error: At this time, the specified image file format is not supported");
            return;
        }
        File worldFile = new File(imageFile.getParent(), imageFileRootName + worldFileExtension);
        if (worldFile.exists()) {
            worldFile.delete();
        }
        if (imageFile.exists()) {
            imageFile.delete();
        }
        if (!(status = this.writeAuxiliaryFile(ps, data, imageFile, "SvmRasterImageTemplate.aux.xml"))) {
            return;
        }
        try (FileOutputStream worldOutputStream = new FileOutputStream(worldFile);){
            bos = new BufferedOutputStream(worldOutputStream);
            Throwable throwable = null;
            try (PrintStream wps = new PrintStream((OutputStream)bos, true, "US-ASCII");){
                wps.format("%7.6f%n", cellSize);
                wps.format("%7.6f%n", 0.0);
                wps.format("%7.6f%n", 0.0);
                wps.format("%7.6f%n", -cellSize);
                wps.format("%7.6f%n", xMin);
                wps.format("%7.6f%n", yMax);
                wps.flush();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (bos != null) {
                    if (throwable != null) {
                        try {
                            ((FilterOutputStream)bos).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((FilterOutputStream)bos).close();
                    }
                }
            }
        }
        catch (IOException wioex) {
            ps.println("Error writing World File " + wioex.getMessage());
            return;
        }
        int[] argb = new int[nCells];
        try {
            FileInputStream gridStream = new FileInputStream(gridFile);
            bos = null;
            try (BufferedInputStream bins = new BufferedInputStream(gridStream);
                 DataInputStream dins = new DataInputStream(bins);){
                for (int iRow = 0; iRow < nRows; ++iRow) {
                    for (int iCol = 0; iCol < nCols; ++iCol) {
                        int index = iRow * nCols + iCol;
                        float z = dins.readFloat();
                        if ((double)z == noDataValue) {
                            if (useAlpha) {
                                argb[index] = 0;
                                continue;
                            }
                            argb[index] = -1;
                            continue;
                        }
                        argb[index] = this.getRgb(z, zMin, zMax);
                    }
                }
            }
            catch (Throwable throwable) {
                bos = throwable;
                throw throwable;
            }
            finally {
                if (gridStream != null) {
                    if (bos != null) {
                        try {
                            gridStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)bos).addSuppressed(throwable);
                        }
                    } else {
                        gridStream.close();
                    }
                }
            }
        }
        catch (IOException ioex) {
            ps.println("Serious error: I/O exception reading grid file");
            return;
        }
        BufferedImage bImage = useAlpha ? new BufferedImage(nCols, nRows, 2) : new BufferedImage(nCols, nRows, 1);
        bImage.setRGB(0, 0, nCols, nRows, argb, 0, nCols);
        try {
            ImageIO.write((RenderedImage)bImage, imageFormat, imageFile);
        }
        catch (IOException ioex) {
            ps.println("Error writing image file " + imageFile.getPath() + ": " + ioex.getMessage());
        }
    }

    boolean testWater(IQuadEdge edge, boolean[] water) {
        if (edge.isConstrainedRegionInterior()) {
            int index = edge.getConstraintIndex();
            return water[index];
        }
        IQuadEdge fwd = edge.getForward();
        if (fwd.isConstrainedRegionInterior()) {
            int index = fwd.getConstraintIndex();
            return water[index];
        }
        IQuadEdge rev = edge.getReverse();
        if (rev.isConstrainedRegionInterior()) {
            int index = rev.getConstraintIndex();
            return water[index];
        }
        return false;
    }

    boolean writeAuxiliaryFile(PrintStream ps, SvmBathymetryData data, File file, String target) {
        StringBuilder template = new StringBuilder();
        try (InputStream ins = SvmMain.class.getResourceAsStream(target);){
            int c;
            while ((c = ins.read()) >= 0) {
                template.append((char)c);
            }
        }
        catch (IOException ioex) {
            ps.println("Failed to load auxiliary template " + ioex.getMessage());
            return false;
        }
        String tempStr = template.toString();
        int lenPrefix = tempStr.indexOf("<SRS>");
        int startPostfix = tempStr.indexOf("</SRS>");
        String prefix = tempStr.substring(0, lenPrefix + 5);
        String postfix = tempStr.substring(startPostfix, tempStr.length());
        template = new StringBuilder();
        template.append(prefix);
        template.append(data.getShapefilePrjContent());
        template.append(postfix);
        File parent = file.getParentFile();
        String name = file.getName() + ".aux.xml";
        File output = new File(parent, name);
        if (output.exists()) {
            output.delete();
        }
        try (FileOutputStream fos = new FileOutputStream(output);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            for (int i = 0; i < tempStr.length(); ++i) {
                char c = tempStr.charAt(i);
                bos.write(c);
            }
            bos.flush();
        }
        catch (IOException ioex) {
            ps.println("Serious error: unable to read template " + template + ": " + ioex.getMessage());
            return false;
        }
        return true;
    }
}

