/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.svm;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.SimpleTriangle;
import org.tinfour.common.Vertex;
import org.tinfour.interpolation.NaturalNeighborInterpolator;
import org.tinfour.utils.KahanSummation;

class SvmRefinement {
    NaturalNeighborInterpolator nni;
    int kIndex;

    SvmRefinement() {
    }

    List<Vertex> subdivideLargeTriangles(PrintStream ps, IIncrementalTin tin, double subdivisionCutoff) {
        if (subdivisionCutoff <= 0.0) {
            return new ArrayList<Vertex>();
        }
        double cutOff = subdivisionCutoff < 0.75 ? 75.0 : (subdivisionCutoff > 0.975 ? 0.99 : subdivisionCutoff);
        this.nni = new NaturalNeighborInterpolator(tin);
        this.kIndex = 0;
        int n = tin.getMaximumEdgeAllocationIndex();
        int k = 0;
        double[] areaArray = new double[2 * n];
        long time0 = System.nanoTime();
        KahanSummation asum = new KahanSummation();
        KahanSummation asum2 = new KahanSummation();
        for (SimpleTriangle trig : tin.triangles()) {
            double a;
            Object appData;
            IConstraint constraint = trig.getContainingRegion();
            if (constraint == null || !constraint.definesConstrainedRegion() || !((appData = constraint.getApplicationData()) instanceof Boolean) || !((Boolean)appData).booleanValue() || (a = trig.getArea()) == 0.0) continue;
            asum.add(a);
            asum2.add(a * a);
            if (k >= areaArray.length) continue;
            areaArray[k++] = a;
        }
        Arrays.sort(areaArray, 0, k);
        int mIndex = (int)(cutOff * (double)k);
        double areaThreshold = areaArray[mIndex];
        double areaMean = asum.getMean();
        double sumD2 = asum2.getSum();
        double sumD = asum.getSum();
        int nD = asum.getSummandCount();
        double areaStd = Math.sqrt((sumD2 - sumD / (double)nD * sumD) / (double)(nD - 1));
        ps.println("Analysis of triangles");
        ps.format("   Area mean    %15.5f%n", areaMean);
        ps.format("   Area std dev %15.5f%n", areaStd);
        ps.format("   Area thresh  %15.5f%n", areaThreshold);
        if (areaThreshold < 2.0 * areaMean) {
            areaThreshold = 2.0 * areaMean;
            for (int i = mIndex; i < k; ++i) {
                if (!(areaArray[i] > areaThreshold)) continue;
                mIndex = i;
                break;
            }
        }
        int nPartitions = k - mIndex;
        ps.println("Subdividing approximately " + nPartitions + " triangles");
        ps.println("");
        ps.println("Population percentile and counts for triangles sorted by area.");
        ps.println("The area column is the base threshold for subset.");
        ps.println("So the 50% line would give the minimum area for all");
        ps.println("triangles in the upper 50 percentile");
        ps.println("Percentile     Area     Count");
        for (int i = 50; i < 100; i += 5) {
            mIndex = (int)((double)i / 100.0 * (double)k);
            ps.format("%3d %% %16.5f %8d%n", i, areaArray[mIndex], k - mIndex);
        }
        int partitionsPerLogEntry = nPartitions / 10;
        if (partitionsPerLogEntry == 0) {
            partitionsPerLogEntry = 1;
        }
        int kPartitions = 0;
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        for (SimpleTriangle trig : tin.triangles()) {
            double a;
            Object appData;
            IConstraint constraint = trig.getContainingRegion();
            if (constraint == null || !constraint.definesConstrainedRegion() || !((appData = constraint.getApplicationData()) instanceof Boolean) || !((Boolean)appData).booleanValue() || (a = trig.getArea()) < areaThreshold) continue;
            this.partitionTriangle(vertices, trig.getVertexA(), trig.getVertexB(), trig.getVertexC(), areaThreshold, 0);
            if (++kPartitions % partitionsPerLogEntry != 0) continue;
            double percentDone = (double)kPartitions * 100.0 / (double)nPartitions;
            System.out.format("Subdivided %8d triangles, %3.0f %% done%n", kPartitions, percentDone);
        }
        int nAdded = vertices.size();
        long time1 = System.nanoTime();
        ps.println("Finished subdivision in " + (double)(time1 - time0) / 1000000.0 + " ms, added " + nAdded + " vertices");
        return vertices;
    }

    private void partitionTriangle(List<Vertex> vList, Vertex A, Vertex B, Vertex C, double threshold, int level) {
        double y;
        double x;
        double z;
        double area = this.computeArea(A, B, C);
        if (area > threshold && Double.isFinite(z = this.nni.interpolate(x = (A.getX() + B.getX() + C.getX()) / 3.0, y = (A.getY() + B.getY() + C.getY()) / 3.0, null))) {
            Vertex M = new Vertex(x, y, z, this.kIndex++);
            vList.add(M);
            if (level < 2) {
                this.partitionTriangle(vList, M, A, B, threshold, level + 1);
                this.partitionTriangle(vList, M, B, C, threshold, level + 1);
                this.partitionTriangle(vList, M, C, A, threshold, level + 1);
            }
        }
    }

    private double computeArea(Vertex a, Vertex b, Vertex c) {
        return ((c.y - a.y) * (b.x - a.x) - (c.x - a.x) * (b.y - a.y)) / 2.0;
    }
}

