/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j;

import com.github.mreutegg.laszip4j.LASExtraBytesDescription;
import com.github.mreutegg.laszip4j.LASExtraBytesType;
import com.github.mreutegg.laszip4j.laszip.LASpoint;
import java.math.BigInteger;

public final class LASExtraBytes {
    private final LASpoint point;
    private final LASExtraBytesDescription description;

    LASExtraBytes(LASpoint point, LASExtraBytesDescription description) {
        this.point = point;
        this.description = description;
    }

    public Double getValue() {
        Number v = this.getRawValue();
        LASExtraBytesType t = this.description.getType();
        return this.translateRawToDouble(v, t, 0);
    }

    public Double[] getValues() {
        Number[] raws = this.getRawValues();
        Double[] values = new Double[raws.length];
        LASExtraBytesType t = this.description.getType();
        for (int i = 0; i < raws.length; ++i) {
            values[i] = this.translateRawToDouble(raws[i], t, i);
        }
        return values;
    }

    private Double translateRawToDouble(Number v, LASExtraBytesType t, int i) {
        if (t.isUnsigned()) {
            Class<?> type = t.getClazz();
            if (type == Byte.class) {
                v = Byte.toUnsignedInt(v.byteValue());
            } else if (type == Short.class) {
                v = Short.toUnsignedInt(v.shortValue());
            } else if (type == Integer.class) {
                v = Integer.toUnsignedLong(v.intValue());
            } else if (type == Long.class) {
                v = new BigInteger(Long.toUnsignedString(v.longValue()));
            }
        }
        if (this.description.hasScaleValue()) {
            v = v.doubleValue() * this.description.getScale(i);
        }
        if (this.description.hasOffsetValue()) {
            v = v.doubleValue() + this.description.getOffset(i);
        }
        return v.doubleValue();
    }

    public Number getRawValue() {
        Class<?> type = this.description.getType().getClazz();
        int start = this.description.getOffset();
        return this.getRawValue(type, start);
    }

    public Number[] getRawValues() {
        LASExtraBytesType t = this.description.getType();
        Number[] values = new Number[t.getCardinality()];
        int offset = this.description.getOffset();
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.getRawValue(t.getClazz(), offset);
            offset += this.description.getTypeSize();
        }
        return values;
    }

    private Number getRawValue(Class<?> type, int offset) {
        if (type == Byte.class) {
            return this.point.get_attributeByte(offset);
        }
        if (type == Short.class) {
            return this.point.get_attributeShort(offset);
        }
        if (type == Integer.class) {
            return this.point.get_attributeInt(offset);
        }
        if (type == Long.class) {
            return this.point.get_attributeLong(offset);
        }
        if (type == Float.class) {
            return Float.valueOf(this.point.get_attributeFloat(offset));
        }
        if (type == Double.class) {
            return this.point.get_attributeDouble(offset);
        }
        throw new IllegalStateException("Unsupported type: " + type.getName());
    }
}

