/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j;

import com.github.mreutegg.laszip4j.LASReader;
import com.github.mreutegg.laszip4j.laslib.LASreader;
import com.github.mreutegg.laszip4j.laslib.LASwriteOpener;
import com.github.mreutegg.laszip4j.laslib.LASwriter;
import java.io.File;
import java.util.Arrays;

public final class LASWriter {
    private final LASReader reader;

    public LASWriter(LASReader reader) {
        this.reader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File out) {
        try (LASreader r = this.reader.openReader();){
            LASwriteOpener opener = new LASwriteOpener();
            opener.set_file_name(out.getAbsolutePath());
            LASwriter w = opener.open(r.header);
            int[] byReturn = r.header.number_of_points_by_return;
            Arrays.fill(byReturn, 0);
            long[] extByReturn = r.header.extended_number_of_points_by_return;
            Arrays.fill(extByReturn, 0L);
            r.header.number_of_point_records = 0;
            try {
                while (r.read_point()) {
                    w.write_point(r.point);
                    short returnNumber = r.point.get_return_number();
                    returnNumber = (short)(returnNumber - 1);
                    if (returnNumber < byReturn.length) {
                        short s = returnNumber;
                        byReturn[s] = byReturn[s] + 1;
                    }
                    if (returnNumber < extByReturn.length) {
                        short s = returnNumber;
                        extByReturn[s] = extByReturn[s] + 1L;
                    }
                    ++r.header.number_of_point_records;
                }
                w.update_header(r.header);
            }
            finally {
                w.close();
            }
        }
    }
}

