/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.laslib.LAScriterion;
import com.github.mreutegg.laszip4j.laszip.LASpoint;

class LAScriterionDropGpsTimeAbove
extends LAScriterion {
    double above_gpstime;

    @Override
    public String name() {
        return "drop_gps_time_above";
    }

    @Override
    public int get_command(StringBuilder string) {
        return Cstdio.sprintf(string, "-%s %.6f ", this.name(), this.above_gpstime);
    }

    @Override
    public int get_decompress_selective() {
        return 128;
    }

    @Override
    public boolean filter(LASpoint point) {
        return point.haveGpsTime() && point.getGps_time() > this.above_gpstime;
    }

    LAScriterionDropGpsTimeAbove(double above_gpstime) {
        this.above_gpstime = above_gpstime;
    }
}

