/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.clib.Cstdlib;
import com.github.mreutegg.laszip4j.clib.Cstring;
import com.github.mreutegg.laszip4j.laslib.LASheader;
import com.github.mreutegg.laszip4j.laslib.LASwaveform13writer;
import com.github.mreutegg.laszip4j.laslib.LASwriter;
import com.github.mreutegg.laszip4j.laslib.LASwriterBIN;
import com.github.mreutegg.laszip4j.laslib.LASwriterLAS;
import com.github.mreutegg.laszip4j.laslib.LASwriterQFIT;
import com.github.mreutegg.laszip4j.laslib.LASwriterTXT;
import com.github.mreutegg.laszip4j.laslib.LASwriterWRL;
import java.io.File;
import java.io.PrintStream;

public class LASwriteOpener {
    private static final PrintStream stderr = System.err;
    private static final PrintStream stdout = System.out;
    private int io_obuffer_size = 262144;
    private String directory = null;
    private String file_name = null;
    private String appendix = null;
    private int cut = 0;
    private boolean opts = Boolean.FALSE;
    private boolean optx = Boolean.FALSE;
    private String parse_string = null;
    private String separator = null;
    private float scale_rgb = 1.0f;
    private int format = 0;
    private boolean specified = Boolean.FALSE;
    private boolean force = Boolean.FALSE;
    private boolean ntive = true;
    private int chunk_size = 50000;
    private boolean use_stdout = Boolean.FALSE;
    private boolean use_nil = Boolean.FALSE;
    private boolean buffered;
    static String[] LAS_TOOLS_FORMAT_NAMES = new String[]{"las", "las", "laz", "bin", "qi", "wrl", "txt", "shp", "asc", "bil", "flt"};

    public boolean is_piped() {
        return this.file_name == null && this.use_stdout;
    }

    public LASwriter open(LASheader header) {
        if (this.use_nil) {
            LASwriterLAS laswriterlas = new LASwriterLAS();
            if (!laswriterlas.open(header, this.format == 2 ? (char)'\u0002' : '\u0000', 2, this.chunk_size)) {
                Cstdio.fprintf(stderr, "ERROR: cannot open laswriterlas to NULL\n", new Object[0]);
                return null;
            }
            return laswriterlas;
        }
        if (this.file_name != null) {
            if (this.format <= 2) {
                LASwriterLAS laswriterlas = new LASwriterLAS();
                if (!laswriterlas.open(this.file_name, header, this.format == 2 ? (this.ntive ? (char)'\u0003' : '\u0002') : (char)'\u0000', 2, this.chunk_size, this.io_obuffer_size)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open laswriterlas with file name '%s'\n", this.file_name);
                    return null;
                }
                return laswriterlas;
            }
            if (this.format == 6) {
                LASwriterTXT laswritertxt = new LASwriterTXT();
                if (this.opts) {
                    laswritertxt.set_pts(Boolean.TRUE);
                } else if (this.optx) {
                    laswritertxt.set_ptx(Boolean.TRUE);
                }
                if (!laswritertxt.open(this.file_name, header, this.parse_string, this.separator)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open laswritertxt with file name '%s'\n", this.file_name);
                    return null;
                }
                if (this.scale_rgb != 1.0f) {
                    laswritertxt.set_scale_rgb(this.scale_rgb);
                }
                return laswritertxt;
            }
            if (this.format == 3) {
                LASwriterBIN laswriterbin = new LASwriterBIN();
                if (!laswriterbin.open(this.file_name, header, "ts8")) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open laswriterbin with file name '%s'\n", this.file_name);
                    return null;
                }
                return laswriterbin;
            }
            if (this.format == 4) {
                LASwriterQFIT laswriterqfit = new LASwriterQFIT();
                if (!laswriterqfit.open(this.file_name, header, 40)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open laswriterqfit with file name '%s'\n", this.file_name);
                    return null;
                }
                return laswriterqfit;
            }
            if (this.format == 5) {
                LASwriterWRL laswriterwrl = new LASwriterWRL();
                if (!laswriterwrl.open(this.file_name, header, this.parse_string)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open laswriterwrl with file name '%s'\n", this.file_name);
                    return null;
                }
                return laswriterwrl;
            }
            Cstdio.fprintf(stderr, "ERROR: unknown format %d\n", this.format);
            return null;
        }
        if (this.use_stdout) {
            if (this.format <= 2) {
                LASwriterLAS laswriterlas = new LASwriterLAS();
                if (!laswriterlas.open(stdout, header, this.format == 2 ? (char)'\u0002' : '\u0000', 2, this.chunk_size)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open laswriterlas to stdout\n", new Object[0]);
                    return null;
                }
                return laswriterlas;
            }
            if (this.format == 6) {
                LASwriterTXT laswritertxt = new LASwriterTXT();
                if (this.opts) {
                    laswritertxt.set_pts(Boolean.TRUE);
                } else if (this.optx) {
                    laswritertxt.set_ptx(Boolean.TRUE);
                }
                if (!laswritertxt.open(stdout, header, this.parse_string, this.separator)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open laswritertxt to stdout\n", new Object[0]);
                    return null;
                }
                if (this.scale_rgb != 1.0f) {
                    laswritertxt.set_scale_rgb(this.scale_rgb);
                }
                return laswritertxt;
            }
            if (this.format == 3) {
                LASwriterBIN laswriterbin = new LASwriterBIN();
                if (!laswriterbin.open(stdout, header, "ts8")) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open laswriterbin to stdout\n", new Object[0]);
                    return null;
                }
                return laswriterbin;
            }
            if (this.format == 4) {
                LASwriterQFIT laswriterqfit = new LASwriterQFIT();
                if (!laswriterqfit.open(stdout, header, 40)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open laswriterbin to stdout\n", new Object[0]);
                    return null;
                }
                return laswriterqfit;
            }
            if (this.format == 5) {
                LASwriterWRL laswriterwrl = new LASwriterWRL();
                if (!laswriterwrl.open(stdout, header, this.parse_string)) {
                    Cstdio.fprintf(stderr, "ERROR: cannot open laswriterwrl with file name '%s'\n", this.file_name);
                    return null;
                }
                return laswriterwrl;
            }
            Cstdio.fprintf(stderr, "ERROR: unknown format %d\n", this.format);
            return null;
        }
        Cstdio.fprintf(stderr, "ERROR: no laswriter output specified\n", new Object[0]);
        return null;
    }

    public LASwaveform13writer open_waveform13(LASheader lasheader) {
        if (lasheader.point_data_format < 4) {
            return null;
        }
        if (lasheader.point_data_format > 5 && lasheader.point_data_format < 9) {
            return null;
        }
        if (lasheader.vlr_wave_packet_descr == null) {
            return null;
        }
        if (this.get_file_name() == null) {
            return null;
        }
        LASwaveform13writer waveform13writer = new LASwaveform13writer();
        if (waveform13writer.open(this.get_file_name(), lasheader.vlr_wave_packet_descr)) {
            return waveform13writer;
        }
        return null;
    }

    void usage() {
        Cstdio.fprintf(stderr, "Supported LAS Outputs\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -o lidar.las\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -o lidar.laz\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -o xyzta.txt -oparse xyzta (on-the-fly to ASCII)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -o terrasolid.bin\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -o nasa.qi\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -odir C:%cdata%cground (specify output directory)\n", Character.valueOf(File.pathSeparatorChar), Character.valueOf(File.pathSeparatorChar));
        Cstdio.fprintf(stderr, "  -odix _classified (specify file name appendix)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -ocut 2 (cut the last two characters from name)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -olas -olaz -otxt -obin -oqfit (specify format)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -stdout (pipe to stdout)\n", new Object[0]);
        Cstdio.fprintf(stderr, "  -nil    (pipe to NULL)\n", new Object[0]);
    }

    public boolean parse(int argc, String[] argv) {
        for (int i = 1; i < argc; ++i) {
            if (argv[i].isEmpty() || argv[i].startsWith("\u0000")) continue;
            if (Cstring.strcmp(argv[i], "-h") == 0) {
                this.usage();
                return Boolean.TRUE;
            }
            if (Cstring.strcmp(argv[i], "-o") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: file_name\n", argv[i]);
                    return Boolean.FALSE;
                }
                this.set_file_name(argv[i + 1]);
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                ++i;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-odir") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: directory\n", argv[i]);
                    return Boolean.FALSE;
                }
                this.set_directory(argv[i + 1]);
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                ++i;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-odix") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: appendix\n", argv[i]);
                    return Boolean.FALSE;
                }
                this.set_appendix(argv[i + 1]);
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                ++i;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-ocut") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: number of characters to cut\n", argv[i]);
                    return Boolean.FALSE;
                }
                this.set_cut(Cstdlib.atoi(argv[i + 1]));
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                ++i;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-oforce") == 0) {
                this.set_force(Boolean.TRUE);
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-native") == 0) {
                this.set_native(Boolean.TRUE);
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-compatible") == 0) {
                this.set_native(Boolean.FALSE);
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-olas") == 0) {
                this.specified = Boolean.TRUE;
                this.format = 1;
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-olaz") == 0) {
                this.specified = Boolean.TRUE;
                this.format = 2;
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-otxt") == 0) {
                this.specified = Boolean.TRUE;
                this.format = 6;
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-obin") == 0) {
                this.specified = Boolean.TRUE;
                this.format = 3;
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-oqi") == 0) {
                this.specified = Boolean.TRUE;
                this.format = 4;
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-owrl") == 0) {
                this.specified = Boolean.TRUE;
                this.format = 5;
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-stdout") == 0) {
                this.use_stdout = Boolean.TRUE;
                this.use_nil = Boolean.FALSE;
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-nil") == 0) {
                this.use_nil = Boolean.TRUE;
                this.use_stdout = Boolean.FALSE;
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-chunk_size") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: number_points\n", argv[i]);
                    return Boolean.FALSE;
                }
                this.set_chunk_size(Cstdlib.atoi(argv[i + 1]));
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                ++i;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-oparse") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: string\n", argv[i]);
                    return Boolean.FALSE;
                }
                this.set_parse_string(argv[i + 1]);
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                ++i;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-osep") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: separator\n", argv[i]);
                    return Boolean.FALSE;
                }
                this.set_separator(argv[i + 1]);
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                ++i;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-oscale_rgb") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: scale\n", argv[i]);
                    return Boolean.FALSE;
                }
                this.set_scale_rgb((float)Cstdlib.atof(argv[i + 1]));
                argv[i] = "\u0000";
                argv[i + 1] = "\u0000";
                ++i;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-opts") == 0) {
                this.opts = Boolean.TRUE;
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-optx") == 0) {
                this.optx = Boolean.TRUE;
                argv[i] = "\u0000";
                continue;
            }
            if (Cstring.strcmp(argv[i], "-io_obuffer") != 0) continue;
            if (i + 1 >= argc) {
                Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: size\n", argv[i]);
                return Boolean.FALSE;
            }
            this.set_io_obuffer_size(Cstdlib.atoi(argv[i + 1]));
            argv[i] = "\u0000";
            argv[i + 1] = "\u0000";
            ++i;
        }
        return Boolean.TRUE;
    }

    void set_io_obuffer_size(int io_obuffer_size) {
        this.io_obuffer_size = io_obuffer_size;
    }

    void set_directory(String directory) {
        if (directory != null) {
            if (LASwriteOpener.strstr(directory, ";") || LASwriteOpener.strstr(directory, "\"")) {
                Cstdio.fprintf(stderr, "WARNING: specified '-odir' seems to contain a substring '\\\"' such\n", new Object[0]);
                Cstdio.fprintf(stderr, "         as -odir \"D:\\\" or -odir \"..\\tiles\\\". this command will\n", new Object[0]);
                Cstdio.fprintf(stderr, "         probably fail. please use -odir \"D:\" or -odir \"..\\tiles\"\n", new Object[0]);
                Cstdio.fprintf(stderr, "         instead.\n", new Object[0]);
            }
            this.directory = directory;
            if (this.directory.endsWith("\\") || this.directory.endsWith("/") || this.directory.endsWith(":")) {
                this.directory = this.directory.substring(0, this.directory.length() - 1);
            }
            if (this.file_name != null) {
                this.add_directory();
            }
        } else {
            this.directory = null;
        }
    }

    public void set_file_name(String file_name) {
        if (file_name != null) {
            if (!this.specified) {
                int len = file_name.length();
                String format = file_name.substring(len - 4);
                this.format = LASwriteOpener.strstr(format, ".laz") || LASwriteOpener.strstr(format, ".LAZ") ? 2 : (LASwriteOpener.strstr(format, ".las") || LASwriteOpener.strstr(format, ".LAS") ? 1 : (LASwriteOpener.strstr(format, ".bin") || LASwriteOpener.strstr(format, ".BIN") ? 3 : (LASwriteOpener.strstr(format, ".qi") || LASwriteOpener.strstr(format, ".QI") ? 4 : (LASwriteOpener.strstr(format, ".wrl") || LASwriteOpener.strstr(format, ".WRL") ? 5 : 6))));
            }
            this.file_name = file_name;
            if (this.directory != null) {
                this.add_directory();
            }
            if (this.cut != 0) {
                this.cut_characters();
            }
            if (this.appendix != null) {
                this.add_appendix();
            }
        } else {
            this.file_name = null;
        }
    }

    void set_appendix(String appendix) {
        if (appendix != null) {
            this.appendix = appendix;
            if (this.file_name != null) {
                this.add_appendix();
            }
        } else {
            this.appendix = null;
        }
    }

    void set_cut(int cut) {
        this.cut = cut;
        if (cut != 0 && this.file_name != null) {
            this.cut_characters();
        }
    }

    void set_native(boolean ntive) {
        this.ntive = ntive;
    }

    public boolean set_format(int format) {
        if (format < 0 || format > 6) {
            return Boolean.FALSE;
        }
        this.specified = Boolean.TRUE;
        this.format = format;
        if (this.file_name != null) {
            int len = this.file_name.length();
            --len;
            while (len > 0 && this.file_name.charAt(len) != '.') {
                --len;
            }
            if (len != 0) {
                if (format <= 1) {
                    this.file_name = LASwriteOpener.setChar(this.file_name, len + 1, 'l');
                    this.file_name = LASwriteOpener.setChar(this.file_name, len + 2, 'a');
                    this.file_name = LASwriteOpener.setChar(this.file_name, len + 3, 's');
                } else if (format == 2) {
                    this.file_name = LASwriteOpener.setChar(this.file_name, len + 1, 'l');
                    this.file_name = LASwriteOpener.setChar(this.file_name, len + 2, 'a');
                    this.file_name = LASwriteOpener.setChar(this.file_name, len + 3, 'z');
                } else if (format == 3) {
                    this.file_name = LASwriteOpener.setChar(this.file_name, len + 1, 'b');
                    this.file_name = LASwriteOpener.setChar(this.file_name, len + 2, 'i');
                    this.file_name = LASwriteOpener.setChar(this.file_name, len + 3, 'n');
                } else if (format == 4) {
                    this.file_name = LASwriteOpener.setChar(this.file_name, len + 1, 'q');
                    this.file_name = LASwriteOpener.setChar(this.file_name, len + 2, 'i');
                } else if (format == 5) {
                    this.file_name = LASwriteOpener.setChar(this.file_name, len + 1, 'w');
                    this.file_name = LASwriteOpener.setChar(this.file_name, len + 2, 'r');
                    this.file_name = LASwriteOpener.setChar(this.file_name, len + 3, 'l');
                } else if (format == 6) {
                    this.file_name = LASwriteOpener.setChar(this.file_name, len + 1, 't');
                    this.file_name = LASwriteOpener.setChar(this.file_name, len + 2, 'x');
                    this.file_name = LASwriteOpener.setChar(this.file_name, len + 3, 't');
                } else {
                    return Boolean.FALSE;
                }
            }
        }
        return Boolean.TRUE;
    }

    boolean set_format(String format) {
        if (format != null) {
            if (LASwriteOpener.strstr(format, "laz") || LASwriteOpener.strstr(format, "LAZ")) {
                return this.set_format(2);
            }
            if (LASwriteOpener.strstr(format, "las") || LASwriteOpener.strstr(format, "LAS")) {
                return this.set_format(1);
            }
            if (LASwriteOpener.strstr(format, "bin") || LASwriteOpener.strstr(format, "BIN")) {
                return this.set_format(3);
            }
            if (LASwriteOpener.strstr(format, "qi") || LASwriteOpener.strstr(format, "QI")) {
                return this.set_format(4);
            }
            if (LASwriteOpener.strstr(format, "wrl") || LASwriteOpener.strstr(format, "WRL")) {
                return this.set_format(5);
            }
            return this.set_format(6);
        }
        this.specified = Boolean.FALSE;
        this.format = 0;
        return Boolean.TRUE;
    }

    public void set_force(boolean force) {
        this.force = force;
    }

    void set_chunk_size(int chunk_size) {
        this.chunk_size = chunk_size;
    }

    void make_numbered_file_name(String file_name, int digits) {
        int len;
        if (file_name != null) {
            len = file_name.length();
            this.file_name = file_name;
        } else {
            if (this.file_name == null) {
                this.file_name = "output.xxx";
            }
            len = this.file_name.length();
        }
        --len;
        while (len > 0 && this.file_name.charAt(len) != '.') {
            --len;
        }
        if (len > 0) {
            this.file_name = LASwriteOpener.setChar(this.file_name, len, '_');
            ++len;
        }
        while (digits > 0) {
            this.file_name = LASwriteOpener.setChar(this.file_name, len, '0');
            --digits;
            ++len;
        }
        this.file_name = LASwriteOpener.setChar(this.file_name, len, '.');
        this.file_name = LASwriteOpener.setChar(this.file_name, ++len, 'x');
        this.file_name = LASwriteOpener.setChar(this.file_name, len + 1, 'x');
        this.file_name = LASwriteOpener.setChar(this.file_name, len + 2, 'x');
    }

    public void make_file_name(String file_name, int file_number) {
        int len;
        if (file_number > -1) {
            if (file_name != null) {
                len = file_name.length();
                this.file_name = file_name;
                if (this.cut != 0) {
                    this.cut_characters();
                    len = file_name.length();
                }
            } else {
                if (this.file_name == null) {
                    this.file_name = "output_0000000.xxx";
                }
                len = this.file_name.length();
            }
            --len;
            while (len > 0 && this.file_name.charAt(len) != '.') {
                --len;
            }
            int file_num = file_number;
            for (int num = ++len - 2; num > 0 && this.file_name.charAt(num) >= '0' && this.file_name.charAt(num) <= '9'; --num) {
                this.file_name = new StringBuilder(this.file_name).deleteCharAt(num).insert(num, 48 + file_num % 10).toString();
                file_num /= 10;
            }
            if (file_num != 0) {
                Cstdio.fprintf(stderr, "WARNING: file name number %d too big to store in '%s'. use more digits.\n", file_number, this.file_name);
            }
        } else if (file_name != null) {
            this.file_name = file_name;
            for (len = file_name.length() - 1; len > 0 && this.file_name.charAt(len) != '.'; --len) {
            }
            if (this.cut != 0 && (len -= this.cut) < 0) {
                len = 0;
            }
            if (this.appendix != null) {
                this.file_name = this.file_name + this.appendix;
                len += this.appendix.length();
            } else if (this.directory == null && this.cut == 0 && file_number == -1) {
                this.file_name = LASwriteOpener.setChar(this.file_name, len, '_');
                this.file_name = LASwriteOpener.setChar(this.file_name, len + 1, '1');
                len += 2;
            }
            this.file_name = LASwriteOpener.setChar(this.file_name, len, '.');
            ++len;
        } else {
            len = 7;
            this.file_name = "output.xxx";
        }
        if (this.format <= 1) {
            this.file_name = LASwriteOpener.setChar(this.file_name, len, 'l');
            this.file_name = LASwriteOpener.setChar(this.file_name, len + 1, 'a');
            this.file_name = LASwriteOpener.setChar(this.file_name, len + 2, 's');
        } else if (this.format == 2) {
            this.file_name = LASwriteOpener.setChar(this.file_name, len, 'l');
            this.file_name = LASwriteOpener.setChar(this.file_name, len + 1, 'a');
            this.file_name = LASwriteOpener.setChar(this.file_name, len + 2, 'z');
        } else if (this.format == 3) {
            this.file_name = LASwriteOpener.setChar(this.file_name, len, 'b');
            this.file_name = LASwriteOpener.setChar(this.file_name, len + 1, 'i');
            this.file_name = LASwriteOpener.setChar(this.file_name, len + 2, 'n');
        } else if (this.format == 4) {
            this.file_name = LASwriteOpener.setChar(this.file_name, len, 'q');
            this.file_name = LASwriteOpener.setChar(this.file_name, len + 1, 'i');
        } else {
            this.file_name = LASwriteOpener.setChar(this.file_name, len, 't');
            this.file_name = LASwriteOpener.setChar(this.file_name, len + 1, 'x');
            this.file_name = LASwriteOpener.setChar(this.file_name, len + 2, 't');
        }
        if (this.directory != null) {
            this.add_directory();
        }
        if (file_name != null && Cstring.strcmp(this.file_name, file_name) == 0 && !this.force) {
            this.file_name = this.format <= 1 ? "temp.las" : (this.format == 2 ? "temp.laz" : (this.format == 3 ? "temp.bin" : (this.format == 4 ? "temp.qi" : (this.format == 5 ? "temp.wrl" : "temp.txt"))));
            Cstdio.fprintf(stderr, "WARNING: generated output name '%s'\n", file_name);
            Cstdio.fprintf(stderr, "         identical to input name. changed to '%s'.\n", this.file_name);
            Cstdio.fprintf(stderr, "         you can override this safety measure with '-oforce'.\n", new Object[0]);
        }
    }

    String get_directory() {
        return this.directory;
    }

    public String get_file_name() {
        return this.file_name;
    }

    String get_file_name_base() {
        String file_name_base = null;
        if (this.file_name != null) {
            int len;
            file_name_base = this.file_name;
            for (len = file_name_base.length() - 1; len > 0 && file_name_base.charAt(len) != '.' && file_name_base.charAt(len) != '\\' && file_name_base.charAt(len) != '/' && file_name_base.charAt(len) != ':'; --len) {
            }
            if (file_name_base.charAt(len) == '.') {
                file_name_base = file_name_base.substring(0, len);
            }
        } else if (this.directory != null) {
            file_name_base = String.format("%s\\", this.directory);
        }
        return file_name_base;
    }

    String get_file_name_only() {
        String file_name_only = null;
        if (this.file_name != null) {
            file_name_only = new File(this.file_name).getName();
        }
        return file_name_only;
    }

    String get_appendix() {
        return this.appendix;
    }

    int get_cut() {
        return this.cut;
    }

    public boolean get_native() {
        return this.ntive;
    }

    public boolean format_was_specified() {
        return this.specified;
    }

    String get_format_name() {
        return LAS_TOOLS_FORMAT_NAMES[this.get_format()];
    }

    public int get_format() {
        if (this.specified || this.file_name == null) {
            return this.format;
        }
        if (LASwriteOpener.strstr(this.file_name, ".laz") || LASwriteOpener.strstr(this.file_name, ".LAZ")) {
            return 2;
        }
        if (LASwriteOpener.strstr(this.file_name, ".las") || LASwriteOpener.strstr(this.file_name, ".LAS")) {
            return 1;
        }
        if (LASwriteOpener.strstr(this.file_name, ".bin") || LASwriteOpener.strstr(this.file_name, ".BIN")) {
            return 3;
        }
        if (LASwriteOpener.strstr(this.file_name, ".qi") || LASwriteOpener.strstr(this.file_name, ".QI")) {
            return 4;
        }
        if (LASwriteOpener.strstr(this.file_name, ".wrl") || LASwriteOpener.strstr(this.file_name, ".WRL")) {
            return 5;
        }
        return 6;
    }

    void set_parse_string(String parse_string) {
        this.parse_string = parse_string;
    }

    void set_separator(String separator) {
        this.separator = separator;
    }

    void set_scale_rgb(float scale_rgb) {
        this.scale_rgb = scale_rgb;
    }

    public boolean active() {
        return this.file_name != null || this.use_stdout || this.use_nil;
    }

    void add_directory() {
        this.add_directory(null);
    }

    void add_directory(String directory) {
        if (directory == null) {
            directory = this.directory;
        }
        if (this.file_name != null && directory != null) {
            this.file_name = new File(directory, this.file_name).getPath();
        }
    }

    void add_appendix() {
        this.add_appendix(null);
    }

    void add_appendix(String appendix) {
        if (appendix == null) {
            appendix = this.appendix;
        }
        if (this.file_name != null && appendix != null) {
            int len;
            for (len = this.file_name.length() - 1; len > 0 && this.file_name.charAt(len) != '.' && this.file_name.charAt(len) != '\\' && this.file_name.charAt(len) != '/' && this.file_name.charAt(len) != ':'; --len) {
            }
            String new_file_name = len == 0 || this.file_name.charAt(len) == '\\' || this.file_name.charAt(len) == '/' || this.file_name.charAt(len) == ':' ? this.file_name + appendix : this.file_name.substring(0, len) + appendix + this.file_name.substring(len);
            this.file_name = new_file_name;
        }
    }

    void cut_characters() {
        this.cut_characters(0);
    }

    void cut_characters(int cut) {
        if (cut == 0) {
            cut = this.cut;
        }
        if (this.file_name != null && cut != 0) {
            int len;
            for (len = this.file_name.length() - 1; len > 0 && this.file_name.charAt(len) != '.' && this.file_name.charAt(len) != '\\' && this.file_name.charAt(len) != '/' && this.file_name.charAt(len) != ':'; --len) {
            }
            String new_file_name = len == 0 || this.file_name.charAt(len) == '\\' || this.file_name.charAt(len) == '/' || this.file_name.charAt(len) == ':' ? this.file_name.substring(0, this.file_name.length() - cut) : this.file_name.substring(0, len - cut) + this.file_name.substring(len);
            this.file_name = new_file_name;
        }
    }

    private static boolean strstr(String s1, String s2) {
        return s1.contains(s2);
    }

    private static String setChar(String s, int index, char c) {
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() <= index) {
            sb.append('\u0000');
        }
        sb.setCharAt(index, c);
        return sb.toString();
    }
}

