/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ByteStreamInDataInput;
import com.github.mreutegg.laszip4j.laszip.UncheckedEOFException;
import java.io.DataInput;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public class ByteStreamInFile
extends ByteStreamInDataInput {
    private static final int MMAP_BUFFER_SIZE = Integer.getInteger("laszip4j.mmap.buffer.size", Integer.MAX_VALUE);
    private final RandomAccessFile file;
    private final RandomAccessDataInput in;

    public ByteStreamInFile(RandomAccessFile file) {
        super(ByteStreamInFile.createRandomAccessDataInput(file));
        this.file = file;
        this.in = (RandomAccessDataInput)this.dataIn;
    }

    private static RandomAccessDataInput createRandomAccessDataInput(RandomAccessFile file) {
        try {
            long length = file.length();
            if (length > (long)MMAP_BUFFER_SIZE) {
                return new MultiMMappedDataInput(file, MMAP_BUFFER_SIZE);
            }
            return new MMappedDataInput(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public long tell() {
        return this.in.position();
    }

    @Override
    public boolean seek(long position) {
        this.in.position(position);
        return true;
    }

    @Override
    public boolean seekEnd(long distance) {
        try {
            long len = this.file.length();
            if (0L <= distance && distance <= len) {
                this.in.position(len - distance);
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    static class MultiMMappedDataInput
    extends RandomAccessDataInput {
        private final List<MappedByteBuffer> buffers = new ArrayList<MappedByteBuffer>();
        private final byte[] one_byte = new byte[1];
        private final long length;
        private final int bufferSize;
        private int currentBufferIndex = 0;

        MultiMMappedDataInput(RandomAccessFile file, int bufferSize) throws IOException {
            long size;
            this.bufferSize = bufferSize;
            this.length = file.length();
            long offset = 0L;
            for (long remainingLength = this.length; remainingLength > 0L; remainingLength -= size) {
                size = Math.min(remainingLength, (long)bufferSize);
                this.buffers.add(file.getChannel().map(FileChannel.MapMode.READ_ONLY, offset, size));
                offset += size;
            }
        }

        @Override
        public void readFully(byte[] b, int off, int len) {
            while (len > 0) {
                MappedByteBuffer buffer = this.maybeTransitionToNextBuffer();
                int remainingInBuffer = Math.min(buffer.remaining(), len);
                buffer.get(b, off, remainingInBuffer);
                len -= remainingInBuffer;
                off += remainingInBuffer;
            }
        }

        @Override
        public int skipBytes(int n) {
            long remaining = this.length - this.position();
            int skip = (int)Math.min((long)n, remaining);
            this.position(this.position() + (long)skip);
            return skip;
        }

        @Override
        public byte readByte() {
            this.readFully(this.one_byte, 0, 1);
            return this.one_byte[0];
        }

        @Override
        public long position() {
            return (long)this.getCurrentBuffer().position() + (long)this.currentBufferIndex * (long)this.bufferSize;
        }

        @Override
        public void position(long position) {
            if (position > this.length) {
                throw new IllegalArgumentException("position > " + this.length + ": " + position);
            }
            this.currentBufferIndex = (int)(position / (long)this.bufferSize);
            this.getCurrentBuffer().position((int)(position % (long)this.bufferSize));
        }

        private MappedByteBuffer maybeTransitionToNextBuffer() throws UncheckedEOFException {
            MappedByteBuffer current = this.getCurrentBuffer();
            if (current.remaining() > 0) {
                return current;
            }
            if (this.currentBufferIndex + 1 < this.buffers.size()) {
                ++this.currentBufferIndex;
            } else {
                throw new UncheckedEOFException();
            }
            current = this.getCurrentBuffer();
            current.position(0);
            return current;
        }

        private MappedByteBuffer getCurrentBuffer() {
            return this.buffers.get(this.currentBufferIndex);
        }
    }

    private static class MMappedDataInput
    extends RandomAccessDataInput {
        private final MappedByteBuffer buffer;

        MMappedDataInput(RandomAccessFile file) {
            try {
                this.buffer = file.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void readFully(byte[] b, int off, int len) {
            this.buffer.get(b, off, len);
        }

        @Override
        public int skipBytes(int n) {
            int skip = Math.min(this.buffer.remaining(), n);
            this.buffer.position(this.buffer.position() + skip);
            return skip;
        }

        @Override
        public byte readByte() {
            return this.buffer.get();
        }

        @Override
        public long position() {
            return this.buffer.position();
        }

        @Override
        public void position(long position) {
            if (position > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("position > 2147483647: " + position);
            }
            this.buffer.position((int)position);
        }
    }

    private static abstract class RandomAccessDataInput
    implements DataInput {
        private RandomAccessDataInput() {
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.readFully(b, 0, b.length);
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.readByte() != 0;
        }

        @Override
        public float readFloat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double readDouble() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readLine() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readUTF() {
            throw new UnsupportedOperationException();
        }

        @Override
        public short readShort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int readUnsignedShort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return Byte.toUnsignedInt(this.readByte());
        }

        @Override
        public char readChar() throws IOException {
            int ch1 = this.readUnsignedByte();
            int ch2 = this.readUnsignedByte();
            return (char)((ch1 << 8) + ch2);
        }

        @Override
        public int readInt() throws IOException {
            int ch1 = this.readUnsignedByte();
            int ch2 = this.readUnsignedByte();
            int ch3 = this.readUnsignedByte();
            int ch4 = this.readUnsignedByte();
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
        }

        @Override
        public long readLong() throws IOException {
            return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
        }

        abstract long position();

        abstract void position(long var1);
    }
}

