/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ByteStreamOut;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteStreamOutFile
extends ByteStreamOut {
    private final RandomAccessFile file;
    private final ByteBuffer buffer = ByteBuffer.allocate(262144).order(ByteOrder.LITTLE_ENDIAN);

    public ByteStreamOutFile(RandomAccessFile file) {
        this.file = file;
    }

    @Override
    public boolean putByte(byte b) {
        try {
            this.ensureRemainingBufferSize(1);
            this.buffer.put(b);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean putBytes(byte[] bytes, int u_num_bytes) {
        try {
            if (u_num_bytes > this.buffer.capacity()) {
                this.flushBuffer();
                this.file.write(bytes, 0, u_num_bytes);
            } else {
                this.ensureRemainingBufferSize(u_num_bytes);
                this.buffer.put(bytes, 0, u_num_bytes);
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean put16bitsLE(char bytes) {
        try {
            this.ensureRemainingBufferSize(2);
            this.buffer.putChar(bytes);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean put16bitsLE(short bytes) {
        try {
            this.ensureRemainingBufferSize(2);
            this.buffer.putShort(bytes);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean put32bitsLE(int bytes) {
        try {
            this.ensureRemainingBufferSize(4);
            this.buffer.putInt(bytes);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean put64bitsLE(long bytes) {
        try {
            this.ensureRemainingBufferSize(8);
            this.buffer.putLong(bytes);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean put16bitsBE(char bytes) {
        try {
            this.ensureRemainingBufferSize(2);
            this.buffer.order(ByteOrder.BIG_ENDIAN);
            this.buffer.putChar(bytes);
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean put32bitsBE(int bytes) {
        try {
            this.ensureRemainingBufferSize(4);
            this.buffer.order(ByteOrder.BIG_ENDIAN);
            this.buffer.putInt(bytes);
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean put64bitsBE(long bytes) {
        try {
            this.ensureRemainingBufferSize(8);
            this.buffer.order(ByteOrder.BIG_ENDIAN);
            this.buffer.putLong(bytes);
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        return true;
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public long tell() {
        try {
            return this.file.getFilePointer() + (long)this.buffer.position();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean seek(long position) {
        try {
            this.flushBuffer();
            this.file.seek(position);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean seekEnd() {
        try {
            this.flushBuffer();
            this.file.seek(this.file.length());
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void close() throws IOException {
        this.flushBuffer();
        this.file.close();
    }

    private void ensureRemainingBufferSize(int numBytes) throws IOException {
        if (this.buffer.remaining() < numBytes) {
            this.flushBuffer();
        }
    }

    private void flushBuffer() throws IOException {
        if (this.buffer.position() > 0) {
            this.file.write(this.buffer.array(), 0, this.buffer.position());
            this.buffer.rewind();
        }
    }
}

