/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ArithmeticDecoder;
import com.github.mreutegg.laszip4j.laszip.ArithmeticModel;
import com.github.mreutegg.laszip4j.laszip.IntegerCompressor;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed;
import com.github.mreutegg.laszip4j.laszip.MutableInteger;
import com.github.mreutegg.laszip4j.laszip.PointDataRecord;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordGpsTime;

public class LASreadItemCompressed_GPSTIME11_v2
extends LASreadItemCompressed {
    private static int LASZIP_GPSTIME_MULTI = 500;
    private static int LASZIP_GPSTIME_MULTI_MINUS = -10;
    private static int LASZIP_GPSTIME_MULTI_UNCHANGED = LASZIP_GPSTIME_MULTI - LASZIP_GPSTIME_MULTI_MINUS + 1;
    private static int LASZIP_GPSTIME_MULTI_CODE_FULL = LASZIP_GPSTIME_MULTI - LASZIP_GPSTIME_MULTI_MINUS + 2;
    private static int LASZIP_GPSTIME_MULTI_TOTAL = LASZIP_GPSTIME_MULTI - LASZIP_GPSTIME_MULTI_MINUS + 6;
    private ArithmeticDecoder dec;
    private int last;
    private int next;
    private PointDataRecordGpsTime[] last_item;
    private int[] last_gpstime_diff = new int[4];
    private int[] multi_extreme_counter = new int[4];
    private ArithmeticModel m_gpstime_multi;
    private ArithmeticModel m_gpstime_0diff;
    private IntegerCompressor ic_gpstime;

    public LASreadItemCompressed_GPSTIME11_v2(ArithmeticDecoder dec) {
        assert (dec != null);
        this.dec = dec;
        this.m_gpstime_multi = dec.createSymbolModel(LASZIP_GPSTIME_MULTI_TOTAL);
        this.m_gpstime_0diff = dec.createSymbolModel(6);
        this.ic_gpstime = new IntegerCompressor(dec, 32, 9);
        this.last_item = new PointDataRecordGpsTime[4];
    }

    @Override
    public void init(PointDataRecord seedItem, MutableInteger notUsed) {
        this.last = 0;
        this.next = 0;
        this.last_gpstime_diff[0] = 0;
        this.last_gpstime_diff[1] = 0;
        this.last_gpstime_diff[2] = 0;
        this.last_gpstime_diff[3] = 0;
        this.multi_extreme_counter[0] = 0;
        this.multi_extreme_counter[1] = 0;
        this.multi_extreme_counter[2] = 0;
        this.multi_extreme_counter[3] = 0;
        this.dec.initSymbolModel(this.m_gpstime_multi);
        this.dec.initSymbolModel(this.m_gpstime_0diff);
        this.ic_gpstime.initDecompressor();
        for (int i = 0; i < this.last_item.length; ++i) {
            this.last_item[i] = new PointDataRecordGpsTime();
        }
        this.last_item[this.last].GPSTime = ((PointDataRecordGpsTime)seedItem).GPSTime;
    }

    @Override
    public PointDataRecord read(MutableInteger notUsed) {
        PointDataRecordGpsTime result = new PointDataRecordGpsTime();
        if (this.last_gpstime_diff[this.last] == 0) {
            int multi = this.dec.decodeSymbol(this.m_gpstime_0diff);
            if (multi == 1) {
                this.last_gpstime_diff[this.last] = this.ic_gpstime.decompress(0, 0);
                this.last_item[this.last].GPSTime += (long)this.last_gpstime_diff[this.last];
                this.multi_extreme_counter[this.last] = 0;
            } else if (multi == 2) {
                this.next = this.next + 1 & 3;
                this.last_item[this.next].GPSTime = this.ic_gpstime.decompress((int)(this.last_item[this.last].GPSTime >>> 32), 8);
                this.last_item[this.next].GPSTime <<= 32;
                this.last_item[this.next].GPSTime |= Integer.toUnsignedLong(this.dec.readInt());
                this.last = this.next;
                this.last_gpstime_diff[this.last] = 0;
                this.multi_extreme_counter[this.last] = 0;
            } else if (multi > 2) {
                this.last = this.last + multi - 2 & 3;
                result = (PointDataRecordGpsTime)this.read(notUsed);
            }
        } else {
            int multi = this.dec.decodeSymbol(this.m_gpstime_multi);
            if (multi == 1) {
                this.last_item[this.last].GPSTime += (long)this.ic_gpstime.decompress(this.last_gpstime_diff[this.last], 1);
                this.multi_extreme_counter[this.last] = 0;
            } else if (multi < LASZIP_GPSTIME_MULTI_UNCHANGED) {
                int gpstime_diff;
                if (multi == 0) {
                    gpstime_diff = this.ic_gpstime.decompress(0, 7);
                    int n = this.last;
                    this.multi_extreme_counter[n] = this.multi_extreme_counter[n] + 1;
                    if (this.multi_extreme_counter[this.last] > 3) {
                        this.last_gpstime_diff[this.last] = gpstime_diff;
                        this.multi_extreme_counter[this.last] = 0;
                    }
                } else if (multi < LASZIP_GPSTIME_MULTI) {
                    gpstime_diff = multi < 10 ? this.ic_gpstime.decompress(multi * this.last_gpstime_diff[this.last], 2) : this.ic_gpstime.decompress(multi * this.last_gpstime_diff[this.last], 3);
                } else if (multi == LASZIP_GPSTIME_MULTI) {
                    gpstime_diff = this.ic_gpstime.decompress(LASZIP_GPSTIME_MULTI * this.last_gpstime_diff[this.last], 4);
                    int n = this.last;
                    this.multi_extreme_counter[n] = this.multi_extreme_counter[n] + 1;
                    if (this.multi_extreme_counter[this.last] > 3) {
                        this.last_gpstime_diff[this.last] = gpstime_diff;
                        this.multi_extreme_counter[this.last] = 0;
                    }
                } else if ((multi = LASZIP_GPSTIME_MULTI - multi) > LASZIP_GPSTIME_MULTI_MINUS) {
                    gpstime_diff = this.ic_gpstime.decompress(multi * this.last_gpstime_diff[this.last], 5);
                } else {
                    gpstime_diff = this.ic_gpstime.decompress(LASZIP_GPSTIME_MULTI_MINUS * this.last_gpstime_diff[this.last], 6);
                    int n = this.last;
                    this.multi_extreme_counter[n] = this.multi_extreme_counter[n] + 1;
                    if (this.multi_extreme_counter[this.last] > 3) {
                        this.last_gpstime_diff[this.last] = gpstime_diff;
                        this.multi_extreme_counter[this.last] = 0;
                    }
                }
                this.last_item[this.last].GPSTime += (long)gpstime_diff;
            } else if (multi == LASZIP_GPSTIME_MULTI_CODE_FULL) {
                this.next = this.next + 1 & 3;
                this.last_item[this.next].GPSTime = this.ic_gpstime.decompress((int)(this.last_item[this.last].GPSTime >>> 32), 8);
                this.last_item[this.next].GPSTime <<= 32;
                this.last_item[this.next].GPSTime |= Integer.toUnsignedLong(this.dec.readInt());
                this.last = this.next;
                this.last_gpstime_diff[this.last] = 0;
                this.multi_extreme_counter[this.last] = 0;
            } else if (multi >= LASZIP_GPSTIME_MULTI_CODE_FULL) {
                this.last = this.last + multi - LASZIP_GPSTIME_MULTI_CODE_FULL & 3;
                result = (PointDataRecordGpsTime)this.read(notUsed);
            }
        }
        result.GPSTime = this.last_item[this.last].GPSTime;
        return result;
    }

    @Override
    public boolean chunk_sizes() {
        return false;
    }
}

