/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ArithmeticDecoder;
import com.github.mreutegg.laszip4j.laszip.ArithmeticModel;
import com.github.mreutegg.laszip4j.laszip.IntegerCompressor;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed;
import com.github.mreutegg.laszip4j.laszip.MutableInteger;
import com.github.mreutegg.laszip4j.laszip.PointDataRecord;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordPoint10;

public class LASreadItemCompressed_POINT10_v1
extends LASreadItemCompressed {
    private ArithmeticDecoder dec;
    private PointDataRecordPoint10 last_item = null;
    private int[] last_x_diff = new int[3];
    private int[] last_y_diff = new int[3];
    private int last_incr;
    private IntegerCompressor ic_dx;
    private IntegerCompressor ic_dy;
    private IntegerCompressor ic_z;
    private IntegerCompressor ic_intensity;
    private IntegerCompressor ic_scan_angle_rank;
    private IntegerCompressor ic_point_source_ID;
    private ArithmeticModel m_changed_values;
    private ArithmeticModel[] m_bit_byte = new ArithmeticModel[256];
    private ArithmeticModel[] m_classification = new ArithmeticModel[256];
    private ArithmeticModel[] m_user_data = new ArithmeticModel[256];

    public LASreadItemCompressed_POINT10_v1(ArithmeticDecoder dec) {
        assert (dec != null);
        this.dec = dec;
        this.ic_dx = new IntegerCompressor(dec, 32);
        this.ic_dy = new IntegerCompressor(dec, 32, 20);
        this.ic_z = new IntegerCompressor(dec, 32, 20);
        this.ic_intensity = new IntegerCompressor(dec, 16);
        this.ic_scan_angle_rank = new IntegerCompressor(dec, 8, 2);
        this.ic_point_source_ID = new IntegerCompressor(dec, 16);
        this.m_changed_values = dec.createSymbolModel(64);
        for (int i = 0; i < 256; ++i) {
            this.m_bit_byte[i] = null;
            this.m_classification[i] = null;
            this.m_user_data[i] = null;
        }
    }

    @Override
    public void init(PointDataRecord seedItem, MutableInteger notUsed) {
        this.last_x_diff[2] = 0;
        this.last_x_diff[1] = 0;
        this.last_x_diff[0] = 0;
        this.last_y_diff[2] = 0;
        this.last_y_diff[1] = 0;
        this.last_y_diff[0] = 0;
        this.last_incr = 0;
        this.ic_dx.initDecompressor();
        this.ic_dy.initDecompressor();
        this.ic_z.initDecompressor();
        this.ic_intensity.initDecompressor();
        this.ic_scan_angle_rank.initDecompressor();
        this.ic_point_source_ID.initDecompressor();
        this.dec.initSymbolModel(this.m_changed_values);
        for (int i = 0; i < 256; ++i) {
            if (this.m_bit_byte[i] != null) {
                this.dec.initSymbolModel(this.m_bit_byte[i]);
            }
            if (this.m_classification[i] != null) {
                this.dec.initSymbolModel(this.m_classification[i]);
            }
            if (this.m_user_data[i] == null) continue;
            this.dec.initSymbolModel(this.m_user_data[i]);
        }
        this.last_item = new PointDataRecordPoint10((PointDataRecordPoint10)seedItem);
    }

    @Override
    public PointDataRecord read(MutableInteger notUsed) {
        int median_x = this.last_x_diff[0] < this.last_x_diff[1] ? (this.last_x_diff[1] < this.last_x_diff[2] ? this.last_x_diff[1] : (this.last_x_diff[0] < this.last_x_diff[2] ? this.last_x_diff[2] : this.last_x_diff[0])) : (this.last_x_diff[0] < this.last_x_diff[2] ? this.last_x_diff[0] : (this.last_x_diff[1] < this.last_x_diff[2] ? this.last_x_diff[2] : this.last_x_diff[1]));
        int median_y = this.last_y_diff[0] < this.last_y_diff[1] ? (this.last_y_diff[1] < this.last_y_diff[2] ? this.last_y_diff[1] : (this.last_y_diff[0] < this.last_y_diff[2] ? this.last_y_diff[2] : this.last_y_diff[0])) : (this.last_y_diff[0] < this.last_y_diff[2] ? this.last_y_diff[0] : (this.last_y_diff[1] < this.last_y_diff[2] ? this.last_y_diff[2] : this.last_y_diff[1]));
        int x_diff = this.ic_dx.decompress(median_x);
        this.last_item.X += x_diff;
        int k_bits = this.ic_dx.getK();
        int y_diff = this.ic_dy.decompress(median_y, k_bits < 19 ? k_bits : 19);
        this.last_item.Y += y_diff;
        k_bits = (k_bits + this.ic_dy.getK()) / 2;
        this.last_item.Z = this.ic_z.decompress(this.last_item.Z, k_bits < 19 ? k_bits : 19);
        int changed_values = this.dec.decodeSymbol(this.m_changed_values);
        if (changed_values != 0) {
            if ((changed_values & 0x20) != 0) {
                this.last_item.Intensity = (char)this.ic_intensity.decompress(this.last_item.Intensity);
            }
            if ((changed_values & 0x10) != 0) {
                if (this.m_bit_byte[this.last_item.Flags] == null) {
                    this.m_bit_byte[this.last_item.Flags] = this.dec.createSymbolModel(256);
                    this.dec.initSymbolModel(this.m_bit_byte[this.last_item.Flags]);
                }
                this.last_item.Flags = (byte)this.dec.decodeSymbol(this.m_bit_byte[this.last_item.Flags]);
            }
            if ((changed_values & 8) != 0) {
                if (this.m_classification[this.last_item.Classification] == null) {
                    this.m_classification[this.last_item.Classification] = this.dec.createSymbolModel(256);
                    this.dec.initSymbolModel(this.m_classification[this.last_item.Classification]);
                }
                this.last_item.Classification = (short)this.dec.decodeSymbol(this.m_classification[this.last_item.Classification]);
            }
            if ((changed_values & 4) != 0) {
                this.last_item.ScanAngleRank = (byte)this.ic_scan_angle_rank.decompress(this.last_item.ScanAngleRank, k_bits < 3 ? 1 : 0);
            }
            if ((changed_values & 2) != 0) {
                if (this.m_user_data[this.last_item.UserData] == null) {
                    this.m_user_data[this.last_item.UserData] = this.dec.createSymbolModel(256);
                    this.dec.initSymbolModel(this.m_user_data[this.last_item.UserData]);
                }
                this.last_item.UserData = (short)this.dec.decodeSymbol(this.m_user_data[this.last_item.UserData]);
            }
            if ((changed_values & 1) != 0) {
                this.last_item.PointSourceID = (char)this.ic_point_source_ID.decompress(this.last_item.PointSourceID);
            }
        }
        this.last_x_diff[this.last_incr] = x_diff;
        this.last_y_diff[this.last_incr] = y_diff;
        ++this.last_incr;
        if (this.last_incr > 2) {
            this.last_incr = 0;
        }
        PointDataRecordPoint10 result = new PointDataRecordPoint10(this.last_item);
        return result;
    }

    @Override
    public boolean chunk_sizes() {
        return false;
    }
}

