/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ArithmeticDecoder;
import com.github.mreutegg.laszip4j.laszip.ByteStreamIn;
import com.github.mreutegg.laszip4j.laszip.IntegerCompressor;
import com.github.mreutegg.laszip4j.laszip.LASitem;
import com.github.mreutegg.laszip4j.laszip.LASreadItem;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed_BYTE14_v3;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed_BYTE_v1;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed_BYTE_v2;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed_GPSTIME11_v1;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed_GPSTIME11_v2;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed_POINT10_v1;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed_POINT10_v2;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed_POINT14_v3;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed_RGB12_v1;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed_RGB12_v2;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed_RGB14_v3;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed_RGBNIR14_v3;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed_WAVEPACKET13_v1;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed_WAVEPACKET14_v3;
import com.github.mreutegg.laszip4j.laszip.LASreadItemRaw;
import com.github.mreutegg.laszip4j.laszip.LASreadItemRaw_BYTE;
import com.github.mreutegg.laszip4j.laszip.LASreadItemRaw_GPSTIME11;
import com.github.mreutegg.laszip4j.laszip.LASreadItemRaw_POINT10;
import com.github.mreutegg.laszip4j.laszip.LASreadItemRaw_POINT14;
import com.github.mreutegg.laszip4j.laszip.LASreadItemRaw_RGB12;
import com.github.mreutegg.laszip4j.laszip.LASreadItemRaw_RGBNIR14;
import com.github.mreutegg.laszip4j.laszip.LASreadItemRaw_WAVEPACKET13;
import com.github.mreutegg.laszip4j.laszip.LASzip;
import com.github.mreutegg.laszip4j.laszip.MutableInteger;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import com.github.mreutegg.laszip4j.laszip.PointDataRecord;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordBytes;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordGpsTime;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordPoint10;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordPoint14;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordRGB;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordRgbNIR;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordWavepacket;
import java.io.EOFException;

public class LASreadPoint {
    private ByteStreamIn instream = null;
    private int num_readers = 0;
    private LASreadItem[] readers = null;
    private LASreadItem[] readers_raw = null;
    private LASreadItem[] readers_compressed = null;
    private ArithmeticDecoder dec = null;
    private boolean layered_las14_compression = false;
    private int chunk_size = -1;
    private int chunk_count = 0;
    private int current_chunk = 0;
    private int number_chunks = 0;
    private int tabled_chunks = 0;
    private long[] chunk_starts = null;
    private int[] chunk_totals = null;
    private int decompress_selective;
    private long point_start;
    private int point_size = 0;
    private PointDataRecord[] seek_point;
    private String last_error;
    private String last_warning;

    public LASreadPoint(int decompress_selective) {
        this.decompress_selective = decompress_selective;
        this.point_start = 0L;
        this.seek_point = null;
        this.last_error = null;
        this.last_warning = null;
    }

    public boolean setup(int num_items, LASitem[] items) {
        return this.setup(num_items, items, null);
    }

    public boolean setup(int num_items, LASitem[] items, LASzip laszip) {
        int i;
        if (laszip != null) {
            if (num_items != laszip.num_items) {
                return Boolean.FALSE;
            }
            if (items != laszip.items) {
                return Boolean.FALSE;
            }
        }
        if (this.dec != null) {
            this.dec = null;
            this.layered_las14_compression = false;
        }
        if (laszip != null && laszip.compressor != '\u0000') {
            switch (laszip.coder) {
                case '\u0000': {
                    this.dec = new ArithmeticDecoder();
                    break;
                }
                default: {
                    return Boolean.FALSE;
                }
            }
            this.layered_las14_compression = laszip.compressor == '\u0003';
        }
        this.readers = null;
        this.num_readers = num_items;
        this.chunk_size = -1;
        this.readers_raw = new LASreadItem[this.num_readers];
        for (i = 0; i < this.num_readers; ++i) {
            switch (items[i].type) {
                case POINT10: {
                    this.readers_raw[i] = new LASreadItemRaw_POINT10();
                    break;
                }
                case GPSTIME11: {
                    this.readers_raw[i] = new LASreadItemRaw_GPSTIME11();
                    break;
                }
                case RGB12: 
                case RGB14: {
                    this.readers_raw[i] = new LASreadItemRaw_RGB12();
                    break;
                }
                case WAVEPACKET13: 
                case WAVEPACKET14: {
                    this.readers_raw[i] = new LASreadItemRaw_WAVEPACKET13();
                    break;
                }
                case BYTE: 
                case BYTE14: {
                    this.readers_raw[i] = new LASreadItemRaw_BYTE(items[i].size);
                    break;
                }
                case POINT14: {
                    this.readers_raw[i] = new LASreadItemRaw_POINT14();
                    break;
                }
                case RGBNIR14: {
                    this.readers_raw[i] = new LASreadItemRaw_RGBNIR14();
                    break;
                }
                default: {
                    return Boolean.FALSE;
                }
            }
            this.point_size += items[i].size;
        }
        if (this.dec != null) {
            this.readers_compressed = new LASreadItem[this.num_readers];
            this.seek_point = new PointDataRecord[num_items];
            block25: for (i = 0; i < this.num_readers; ++i) {
                switch (items[i].type) {
                    case POINT10: {
                        this.seek_point[i] = new PointDataRecordPoint10();
                        if (items[i].version == '\u0001') {
                            this.readers_compressed[i] = new LASreadItemCompressed_POINT10_v1(this.dec);
                            continue block25;
                        }
                        if (items[i].version == '\u0002') {
                            this.readers_compressed[i] = new LASreadItemCompressed_POINT10_v2(this.dec);
                            continue block25;
                        }
                        return Boolean.FALSE;
                    }
                    case GPSTIME11: {
                        this.seek_point[i] = new PointDataRecordGpsTime();
                        if (items[i].version == '\u0001') {
                            this.readers_compressed[i] = new LASreadItemCompressed_GPSTIME11_v1(this.dec);
                            continue block25;
                        }
                        if (items[i].version == '\u0002') {
                            this.readers_compressed[i] = new LASreadItemCompressed_GPSTIME11_v2(this.dec);
                            continue block25;
                        }
                        return Boolean.FALSE;
                    }
                    case RGB12: {
                        this.seek_point[i] = new PointDataRecordRGB();
                        if (items[i].version == '\u0001') {
                            this.readers_compressed[i] = new LASreadItemCompressed_RGB12_v1(this.dec);
                            continue block25;
                        }
                        if (items[i].version == '\u0002') {
                            this.readers_compressed[i] = new LASreadItemCompressed_RGB12_v2(this.dec);
                            continue block25;
                        }
                        return Boolean.FALSE;
                    }
                    case RGB14: {
                        this.seek_point[i] = new PointDataRecordRGB();
                        if (items[i].version == '\u0004' || items[i].version == '\u0003' || items[i].version == '\u0002') {
                            this.readers_compressed[i] = new LASreadItemCompressed_RGB14_v3(this.dec, this.decompress_selective);
                            continue block25;
                        }
                        return Boolean.FALSE;
                    }
                    case WAVEPACKET13: {
                        this.seek_point[i] = new PointDataRecordWavepacket();
                        if (items[i].version == '\u0001') {
                            this.readers_compressed[i] = new LASreadItemCompressed_WAVEPACKET13_v1(this.dec);
                            continue block25;
                        }
                        return Boolean.FALSE;
                    }
                    case WAVEPACKET14: {
                        this.seek_point[i] = new PointDataRecordWavepacket();
                        if (items[i].version == '\u0004' || items[i].version == '\u0003') {
                            this.readers_compressed[i] = new LASreadItemCompressed_WAVEPACKET14_v3(this.dec, this.decompress_selective);
                            continue block25;
                        }
                        return Boolean.FALSE;
                    }
                    case BYTE: {
                        this.seek_point[i] = new PointDataRecordBytes(items[i].size);
                        if (items[i].version == '\u0001') {
                            this.readers_compressed[i] = new LASreadItemCompressed_BYTE_v1(this.dec, items[i].size);
                            continue block25;
                        }
                        if (items[i].version == '\u0002') {
                            this.readers_compressed[i] = new LASreadItemCompressed_BYTE_v2(this.dec, items[i].size);
                            continue block25;
                        }
                        return Boolean.FALSE;
                    }
                    case BYTE14: {
                        this.seek_point[i] = new PointDataRecordBytes(items[i].size);
                        if (items[i].version == '\u0004' || items[i].version == '\u0003') {
                            this.readers_compressed[i] = new LASreadItemCompressed_BYTE14_v3(this.dec, items[i].size, this.decompress_selective);
                            continue block25;
                        }
                        return Boolean.FALSE;
                    }
                    case POINT14: {
                        this.seek_point[i] = new PointDataRecordPoint14();
                        if (items[i].version == '\u0004' || items[i].version == '\u0003' || items[i].version == '\u0002') {
                            this.readers_compressed[i] = new LASreadItemCompressed_POINT14_v3(this.dec, this.decompress_selective);
                            continue block25;
                        }
                        return Boolean.FALSE;
                    }
                    case RGBNIR14: {
                        this.seek_point[i] = new PointDataRecordRgbNIR();
                        if (items[i].version == '\u0004' || items[i].version == '\u0003' || items[i].version == '\u0002') {
                            this.readers_compressed[i] = new LASreadItemCompressed_RGBNIR14_v3(this.dec, this.decompress_selective);
                            continue block25;
                        }
                        return Boolean.FALSE;
                    }
                    default: {
                        return Boolean.FALSE;
                    }
                }
            }
            if (laszip.compressor != '\u0001') {
                if (laszip.chunk_size != 0) {
                    this.chunk_size = laszip.chunk_size;
                }
                this.number_chunks = -1;
            }
        }
        return Boolean.TRUE;
    }

    public boolean init(ByteStreamIn instream) {
        if (instream == null) {
            return Boolean.FALSE;
        }
        this.instream = instream;
        for (int i = 0; i < this.num_readers; ++i) {
            ((LASreadItemRaw)this.readers_raw[i]).init(instream);
        }
        if (this.dec != null) {
            this.chunk_count = this.chunk_size;
            this.point_start = 0L;
            this.readers = null;
        } else {
            this.point_start = instream.tell();
            this.readers = this.readers_raw;
        }
        return Boolean.TRUE;
    }

    public boolean seek(int current, int target) {
        if (!this.instream.isSeekable()) {
            return Boolean.FALSE;
        }
        int delta = 0;
        if (this.dec != null) {
            if (this.point_start == 0L) {
                this.init_dec();
                this.chunk_count = 0;
            }
            if (this.chunk_starts != null) {
                int target_chunk;
                if (this.chunk_totals != null) {
                    target_chunk = this.search_chunk_table(target, 0, this.number_chunks);
                    this.chunk_size = this.chunk_totals[target_chunk + 1] - this.chunk_totals[target_chunk];
                    delta = target - this.chunk_totals[target_chunk];
                } else {
                    target_chunk = target / this.chunk_size;
                    delta = target % this.chunk_size;
                }
                if (Integer.compareUnsigned(target_chunk, this.tabled_chunks) >= 0) {
                    if (Integer.compareUnsigned(this.current_chunk, this.tabled_chunks - 1) < 0) {
                        this.dec.done();
                        this.current_chunk = this.tabled_chunks - 1;
                        this.instream.seek(this.chunk_starts[this.current_chunk]);
                        this.init_dec();
                        this.chunk_count = 0;
                    }
                    delta += this.chunk_size * (target_chunk - this.current_chunk) - this.chunk_count;
                } else if (this.current_chunk != target_chunk || Integer.compareUnsigned(current, target) > 0) {
                    this.dec.done();
                    this.current_chunk = target_chunk;
                    this.instream.seek(this.chunk_starts[this.current_chunk]);
                    this.init_dec();
                    this.chunk_count = 0;
                } else {
                    delta = target - current;
                }
            } else if (Integer.compareUnsigned(current, target) > 0) {
                this.dec.done();
                this.instream.seek(this.point_start);
                this.init_dec();
                delta = target;
            } else if (Integer.compareUnsigned(current, target) < 0) {
                delta = target - current;
            }
            while (delta != 0) {
                this.read(this.seek_point);
                --delta;
            }
        } else if (current != target) {
            this.instream.seek(this.point_start + (long)(this.point_size * target));
        }
        return Boolean.TRUE;
    }

    public boolean read(PointDataRecord[] pointRecords) {
        MutableInteger context = new MutableInteger(0);
        try {
            if (this.dec != null) {
                if (this.chunk_count == this.chunk_size) {
                    if (this.point_start != 0L) {
                        long here;
                        this.dec.done();
                        ++this.current_chunk;
                        if (this.current_chunk < this.tabled_chunks && this.chunk_starts[this.current_chunk] != (here = this.instream.tell())) {
                            --this.current_chunk;
                            throw new RuntimeException("4711");
                        }
                    }
                    this.init_dec();
                    if (this.current_chunk == this.tabled_chunks) {
                        if (this.current_chunk >= this.number_chunks) {
                            this.number_chunks += 256;
                            this.chunk_starts = MyDefs.realloc(this.chunk_starts, this.number_chunks + 1);
                        }
                        this.chunk_starts[this.tabled_chunks] = this.point_start;
                        ++this.tabled_chunks;
                    } else if (this.chunk_totals != null) {
                        this.chunk_size = this.chunk_totals[this.current_chunk + 1] - this.chunk_totals[this.current_chunk];
                    }
                    this.chunk_count = 0;
                }
                ++this.chunk_count;
                if (this.readers != null) {
                    for (int i = 0; i < this.num_readers; ++i) {
                        pointRecords[i] = this.readers[i].read(context);
                    }
                } else {
                    int i;
                    for (i = 0; i < this.num_readers; ++i) {
                        pointRecords[i] = this.readers_raw[i].read(context);
                    }
                    if (this.layered_las14_compression) {
                        this.dec.setByteStreamIn(this.instream);
                        this.instream.get32bitsLE();
                        for (i = 0; i < this.num_readers; ++i) {
                            ((LASreadItemCompressed)this.readers_compressed[i]).chunk_sizes();
                        }
                        for (i = 0; i < this.num_readers; ++i) {
                            ((LASreadItemCompressed)this.readers_compressed[i]).init(pointRecords[i], context);
                        }
                    } else {
                        for (i = 0; i < this.num_readers; ++i) {
                            ((LASreadItemCompressed)this.readers_compressed[i]).init(pointRecords[i], context);
                        }
                        this.dec.init(this.instream);
                    }
                    this.readers = this.readers_compressed;
                }
            } else {
                for (int i = 0; i < this.num_readers; ++i) {
                    pointRecords[i] = this.readers[i].read(context);
                }
            }
        }
        catch (Exception exception) {
            if (exception instanceof EOFException) {
                this.last_error = this.dec != null ? String.format("end-of-file during chunk with index %d", this.current_chunk) : "end-of-file";
            } else {
                this.last_error = String.format("chunk with index %d of %d is corrupt", this.current_chunk, this.tabled_chunks);
                if (this.current_chunk + 1 < this.tabled_chunks) {
                    this.instream.seek(this.chunk_starts[this.current_chunk + 1]);
                    this.chunk_count = this.chunk_size;
                }
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public boolean check_end() {
        if (this.readers == this.readers_compressed && this.dec != null) {
            long here;
            this.dec.done();
            ++this.current_chunk;
            if (this.current_chunk < this.tabled_chunks && this.chunk_starts[this.current_chunk] != (here = this.instream.tell())) {
                this.last_error = String.format("chunk with index %d of %d is corrupt", this.current_chunk, this.tabled_chunks);
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public boolean done() {
        this.instream = null;
        return Boolean.TRUE;
    }

    boolean init_dec() {
        if (this.number_chunks == -1) {
            if (!this.read_chunk_table()) {
                return Boolean.FALSE;
            }
            this.current_chunk = 0;
            if (this.chunk_totals != null) {
                this.chunk_size = this.chunk_totals[1];
            }
        }
        this.point_start = this.instream.tell();
        this.readers = null;
        return Boolean.TRUE;
    }

    boolean read_chunk_table() {
        long chunk_table_start_position;
        try {
            chunk_table_start_position = this.instream.get64bitsLE();
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
        long chunks_start = this.instream.tell();
        if (chunk_table_start_position + 8L == chunks_start) {
            if (this.chunk_size == -1) {
                return Boolean.FALSE;
            }
            this.number_chunks = 256;
            this.chunk_starts = new long[this.number_chunks + 1];
            if (this.chunk_starts == null) {
                return Boolean.FALSE;
            }
            this.chunk_starts[0] = chunks_start;
            this.tabled_chunks = 1;
            return Boolean.TRUE;
        }
        if (!this.instream.isSeekable()) {
            if (this.chunk_size == -1) {
                return Boolean.FALSE;
            }
            this.number_chunks = -2;
            this.tabled_chunks = 0;
            return Boolean.TRUE;
        }
        if (chunk_table_start_position == -1L) {
            if (!this.instream.seekEnd(8L)) {
                return Boolean.FALSE;
            }
            try {
                chunk_table_start_position = this.instream.get64bitsLE();
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
        try {
            this.instream.seek(chunk_table_start_position);
            int version = this.instream.get32bitsLE();
            if (version != 0) {
                throw new RuntimeException("1");
            }
            this.number_chunks = this.instream.get32bitsLE();
            this.chunk_totals = null;
            this.chunk_starts = null;
            if (this.chunk_size == -1) {
                this.chunk_totals = new int[this.number_chunks + 1];
                this.chunk_totals[0] = 0;
            }
            this.chunk_starts = new long[this.number_chunks + 1];
            this.chunk_starts[0] = chunks_start;
            this.tabled_chunks = 1;
            if (Integer.compareUnsigned(this.number_chunks, 0) > 0) {
                this.dec.init(this.instream);
                IntegerCompressor ic = new IntegerCompressor(this.dec, 32, 2);
                ic.initDecompressor();
                int i = 1;
                while (Integer.compareUnsigned(i, this.number_chunks) <= 0) {
                    if (this.chunk_size == -1) {
                        this.chunk_totals[i] = ic.decompress(i > 1 ? this.chunk_totals[i - 1] : 0, 0);
                    }
                    this.chunk_starts[i] = ic.decompress(i > 1 ? (int)this.chunk_starts[i - 1] : 0, 1);
                    ++this.tabled_chunks;
                    ++i;
                }
                this.dec.done();
                for (i = 1; i <= this.number_chunks; ++i) {
                    if (this.chunk_size == -1) {
                        int n = i;
                        this.chunk_totals[n] = this.chunk_totals[n] + this.chunk_totals[i - 1];
                    }
                    int n = i;
                    this.chunk_starts[n] = this.chunk_starts[n] + this.chunk_starts[i - 1];
                    if (this.chunk_starts[i] > this.chunk_starts[i - 1]) continue;
                    throw new RuntimeException("1");
                }
            }
        }
        catch (Exception e) {
            this.chunk_totals = null;
            if (this.chunk_size == -1) {
                return Boolean.FALSE;
            }
            if (this.number_chunks == -1) {
                this.number_chunks = 256;
                this.chunk_starts = new long[this.number_chunks + 1];
                this.chunk_starts[0] = chunks_start;
                this.tabled_chunks = 1;
            } else {
                for (int i = 1; i < this.tabled_chunks; ++i) {
                    int n = i;
                    this.chunk_starts[n] = this.chunk_starts[n] + this.chunk_starts[i - 1];
                }
            }
            this.last_warning = "corrupt chunk table";
        }
        if (!this.instream.seek(chunks_start)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    int search_chunk_table(int index, int lower, int upper) {
        if (lower + 1 == upper) {
            return lower;
        }
        int mid = (lower + upper) / 2;
        if (Integer.compareUnsigned(index, this.chunk_totals[mid]) >= 0) {
            return this.search_chunk_table(index, mid, upper);
        }
        return this.search_chunk_table(index, lower, mid);
    }

    public String error() {
        return this.last_error;
    }

    public String warning() {
        return this.last_warning;
    }
}

