/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.PointDataRecord;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class PointDataRecordWavepacket
extends PointDataRecord {
    public short DescriptorIndex = 0;
    public long OffsetToWaveformData = 0L;
    public long PacketSize = 0L;
    public float ReturnPointWaveformLocation = 0.0f;
    public float ParametricDx = 0.0f;
    public float ParametricDy = 0.0f;
    public float ParametricDz = 0.0f;

    public PointDataRecordWavepacket() {
    }

    public PointDataRecordWavepacket(PointDataRecordWavepacket other) {
        this.DescriptorIndex = other.DescriptorIndex;
        this.OffsetToWaveformData = other.OffsetToWaveformData;
        this.PacketSize = other.PacketSize;
        this.ReturnPointWaveformLocation = other.ReturnPointWaveformLocation;
        this.ParametricDx = other.ParametricDx;
        this.ParametricDy = other.ParametricDy;
        this.ParametricDz = other.ParametricDz;
    }

    public int getReturnPointWaveformLocationAsInt() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putFloat(this.ReturnPointWaveformLocation);
        return byteBuffer.getInt(0);
    }

    public void setReturnPointWaveformLocation(int value) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(value);
        this.ReturnPointWaveformLocation = byteBuffer.getFloat(0);
    }

    public int getDxAsInt() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putFloat(this.ParametricDx);
        return byteBuffer.getInt(0);
    }

    public int getDyAsInt() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putFloat(this.ParametricDy);
        return byteBuffer.getInt(0);
    }

    public int getDzAsInt() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putFloat(this.ParametricDz);
        return byteBuffer.getInt(0);
    }

    public void setDx(int value) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(value);
        this.ParametricDx = byteBuffer.getFloat(0);
    }

    public void setDy(int value) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(value);
        this.ParametricDy = byteBuffer.getFloat(0);
    }

    public void setDz(int value) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(value);
        this.ParametricDz = byteBuffer.getFloat(0);
    }

    public String toString() {
        return String.format("wave:%d %d %d %f %f %f %f", this.DescriptorIndex, this.OffsetToWaveformData, this.PacketSize, Float.valueOf(this.ReturnPointWaveformLocation), Float.valueOf(this.ParametricDx), Float.valueOf(this.ParametricDy), Float.valueOf(this.ParametricDz));
    }
}

