/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.common;

import org.tinfour.common.Circumcircle;
import org.tinfour.common.Thresholds;
import org.tinfour.common.Vertex;
import org.tinfour.vividsolutions.jts.math.DD;

public class GeometricOperations {
    private final DD q11 = new DD();
    private final DD q21 = new DD();
    private final DD q31 = new DD();
    private final DD q12 = new DD();
    private final DD q22 = new DD();
    private final DD q32 = new DD();
    private final DD q11s = new DD();
    private final DD q12s = new DD();
    private final DD q21s = new DD();
    private final DD q22s = new DD();
    private final DD q31s = new DD();
    private final DD q32s = new DD();
    private final DD q21_32 = new DD();
    private final DD q31_22 = new DD();
    private final DD q31_12 = new DD();
    private final DD q11_32 = new DD();
    private final DD q11_22 = new DD();
    private final DD q21_12 = new DD();
    private final Thresholds thresholds;
    private final double inCircleThreshold;
    private final double halfPlaneThresholdNeg;
    private final double halfPlaneThreshold;
    private final double circumcircleDeterminantThreshold;
    private long nInCircleCalls;
    private long nExtendedPrecisionInCircle;
    private long nExtendedConflict;
    private long nHalfPlaneCalls;
    private long nCircumcircle;
    private long nCircumcircleExtended;

    public GeometricOperations() {
        this.thresholds = new Thresholds(1.0);
        this.inCircleThreshold = this.thresholds.getInCircleThreshold();
        this.halfPlaneThresholdNeg = -this.thresholds.getHalfPlaneThreshold();
        this.halfPlaneThreshold = this.thresholds.getHalfPlaneThreshold();
        this.circumcircleDeterminantThreshold = this.thresholds.getCircumcircleDeterminantThreshold();
    }

    public GeometricOperations(Thresholds thresholds) {
        this.thresholds = thresholds;
        this.inCircleThreshold = thresholds.getInCircleThreshold();
        this.halfPlaneThresholdNeg = -thresholds.getHalfPlaneThreshold();
        this.halfPlaneThreshold = thresholds.getHalfPlaneThreshold();
        this.circumcircleDeterminantThreshold = thresholds.getCircumcircleDeterminantThreshold();
    }

    public double inCircle(Vertex a, Vertex b, Vertex c, Vertex d) {
        return this.inCircle(a.x, a.y, b.x, b.y, c.x, c.y, d.x, d.y);
    }

    public double inCircle(double ax, double ay, double bx, double by, double cx, double cy, double dx, double dy) {
        ++this.nInCircleCalls;
        double a11 = ax - dx;
        double a12 = ay - dy;
        double a21 = bx - dx;
        double a32 = cy - dy;
        double a31 = cx - dx;
        double a22 = by - dy;
        double inCircle = (a11 * a11 + a12 * a12) * (a21 * a32 - a31 * a22) + (a21 * a21 + a22 * a22) * (a31 * a12 - a11 * a32) + (a31 * a31 + a32 * a32) * (a11 * a22 - a21 * a12);
        if (-this.inCircleThreshold < inCircle && inCircle < this.inCircleThreshold) {
            ++this.nExtendedPrecisionInCircle;
            double inCircle2 = this.inCircleQuadPrecision(ax, ay, bx, by, cx, cy, dx, dy);
            if (inCircle2 * inCircle <= 0.0 && (inCircle != 0.0 || inCircle2 != 0.0)) {
                ++this.nExtendedConflict;
            }
            inCircle = inCircle2;
        }
        return inCircle;
    }

    public double inCircleQuadPrecision(double ax, double ay, double bx, double by, double cx, double cy, double dx, double dy) {
        ++this.nExtendedPrecisionInCircle;
        this.q11.setValue(ax).selfSubtract(dx);
        this.q21.setValue(bx).selfSubtract(dx);
        this.q31.setValue(cx).selfSubtract(dx);
        this.q12.setValue(ay).selfSubtract(dy);
        this.q22.setValue(by).selfSubtract(dy);
        this.q32.setValue(cy).selfSubtract(dy);
        this.q11s.setValue(this.q11).selfMultiply(this.q11);
        this.q12s.setValue(this.q12).selfMultiply(this.q12);
        this.q21s.setValue(this.q21).selfMultiply(this.q21);
        this.q22s.setValue(this.q22).selfMultiply(this.q22);
        this.q31s.setValue(this.q31).selfMultiply(this.q31);
        this.q32s.setValue(this.q32).selfMultiply(this.q32);
        this.q11_22.setValue(this.q11).selfMultiply(this.q22);
        this.q11_32.setValue(this.q11).selfMultiply(this.q32);
        this.q21_12.setValue(this.q21).selfMultiply(this.q12);
        this.q21_32.setValue(this.q21).selfMultiply(this.q32);
        this.q31_22.setValue(this.q31).selfMultiply(this.q22);
        this.q31_12.setValue(this.q31).selfMultiply(this.q12);
        DD s1 = this.q11s.selfAdd(this.q12s);
        DD s2 = this.q21s.selfAdd(this.q22s);
        DD s3 = this.q31s.selfAdd(this.q32s);
        DD t1 = this.q21_32.selfSubtract(this.q31_22);
        DD t2 = this.q31_12.selfSubtract(this.q11_32);
        DD t3 = this.q11_22.selfSubtract(this.q21_12);
        s1.selfMultiply(t1);
        s2.selfMultiply(t2);
        s3.selfMultiply(t3);
        s1.selfAdd(s2).selfAdd(s3);
        return s1.doubleValue();
    }

    public double halfPlane(double ax, double ay, double bx, double by, double cx, double cy) {
        ++this.nHalfPlaneCalls;
        this.q11.setValue(cx).selfSubtract(ax);
        this.q12.setValue(ay).selfSubtract(by);
        this.q21.setValue(cy).selfSubtract(ay);
        this.q22.setValue(bx).selfSubtract(ax);
        this.q11.selfMultiply(this.q12);
        this.q21.selfMultiply(this.q22);
        this.q11.selfAdd(this.q21);
        return this.q11.doubleValue();
    }

    public double direction(double ax, double ay, double bx, double by, double cx, double cy) {
        ++this.nHalfPlaneCalls;
        this.q11.setValue(bx).selfSubtract(ax);
        this.q12.setValue(by).selfSubtract(ay);
        this.q21.setValue(cx).selfSubtract(ax);
        this.q22.setValue(cy).selfSubtract(ay);
        this.q11.selfMultiply(this.q21);
        this.q12.selfMultiply(this.q22);
        this.q11.selfAdd(this.q12);
        return this.q11.doubleValue();
    }

    public double orientation(double ax, double ay, double bx, double by, double cx, double cy) {
        double a = (ax - cx) * (by - cy) - (bx - cx) * (ay - cy);
        if (a > this.halfPlaneThresholdNeg && a < this.halfPlaneThreshold) {
            this.q11.setValue(ax).selfSubtract(cx);
            this.q12.setValue(by).selfSubtract(cy);
            this.q21.setValue(bx).selfSubtract(cx);
            this.q22.setValue(ay).selfSubtract(cy);
            this.q11.selfMultiply(this.q12);
            this.q21.selfMultiply(this.q22);
            this.q11.selfSubtract(this.q21);
            return this.q11.doubleValue();
        }
        return a;
    }

    public long getInCircleCount() {
        return this.nInCircleCalls;
    }

    public long getExtendedPrecisionInCircleCount() {
        return this.nExtendedPrecisionInCircle;
    }

    public long getExtendedConflictCount() {
        return this.nExtendedConflict;
    }

    public long getHalfPlaneCount() {
        return this.nHalfPlaneCalls;
    }

    public long getCircumcircleCount() {
        return this.nCircumcircle;
    }

    public long getExtendedCircumcircleCount() {
        return this.nCircumcircleExtended;
    }

    public double area(Vertex a, Vertex b, Vertex c) {
        double h = (c.y - a.y) * (b.x - a.x) - (c.x - a.x) * (b.y - a.y);
        if (-this.inCircleThreshold < h && h < this.inCircleThreshold) {
            h = this.halfPlane(a.x, a.y, b.x, b.y, c.x, c.y);
        }
        return h / 2.0;
    }

    public double area(double ax, double ay, double bx, double by, double cx, double cy) {
        double h = (cy - ay) * (bx - ax) - (cx - ax) * (by - ay);
        if (-this.inCircleThreshold < h && h < this.inCircleThreshold) {
            h = this.halfPlane(ax, ay, bx, by, cx, cy);
        }
        return h / 2.0;
    }

    public void clearDiagnostics() {
        this.nInCircleCalls = 0L;
        this.nExtendedPrecisionInCircle = 0L;
        this.nExtendedConflict = 0L;
        this.nHalfPlaneCalls = 0L;
        this.nCircumcircle = 0L;
        this.nCircumcircleExtended = 0L;
    }

    public boolean circumcircle(Vertex a, Vertex b, Vertex c, Circumcircle result) {
        this.circumcircle(a.x, a.y, b.x, b.y, c.x, c.y, result);
        return Double.isFinite(result.getRadiusSq());
    }

    public void circumcircle(double vax, double vay, double vbx, double vby, double vcx, double vcy, Circumcircle result) {
        ++this.nCircumcircle;
        double bx = vbx - vax;
        double cy = vcy - vay;
        double by = vby - vay;
        double cx = vcx - vax;
        double d = bx * cy - by * cx;
        if (Math.abs(d) > this.circumcircleDeterminantThreshold) {
            double b2 = bx * bx + by * by;
            double c2 = cx * cx + cy * cy;
            double x = (cy * b2 - by * c2) / (d *= 2.0);
            double y = (bx * c2 - cx * b2) / d;
            result.setCircumcenter(x + vax, y + vay, x * x + y * y);
        } else {
            ++this.nCircumcircleExtended;
            this.q11.setValue(vbx).selfSubtract(vax);
            this.q12.setValue(vby).selfSubtract(vay);
            this.q21.setValue(vcx).selfSubtract(vax);
            this.q22.setValue(vcy).selfSubtract(vay);
            this.q11s.setValue(this.q11).selfMultiply(this.q22);
            this.q12s.setValue(this.q12).selfMultiply(this.q21);
            this.q11s.selfSubtract(this.q12s);
            DD det = this.q11s.multiply(2.0);
            d = det.doubleValue();
            if (d == 0.0) {
                result.setCircumcenter(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return;
            }
            this.q11s.setValue(this.q11).selfMultiply(this.q11);
            this.q12s.setValue(this.q12).selfMultiply(this.q12);
            this.q11s.selfAdd(this.q12s);
            this.q21s.setValue(this.q21).selfMultiply(this.q21);
            this.q22s.setValue(this.q22).selfMultiply(this.q22);
            this.q21s.selfAdd(this.q22s);
            this.q31.setValue(this.q22).selfMultiply(this.q11s);
            this.q32.setValue(this.q12).selfMultiply(this.q21s);
            DD xCenter = this.q31.subtract(this.q32).selfDivide(det);
            this.q31.setValue(this.q11).selfMultiply(this.q21s);
            this.q32.setValue(this.q21).selfMultiply(this.q11s);
            DD yCenter = this.q31.subtract(this.q32).selfDivide(det);
            this.q11s.setValue(xCenter).selfMultiply(xCenter);
            this.q21s.setValue(yCenter).selfMultiply(yCenter);
            this.q11s.selfAdd(this.q21s);
            xCenter.selfAdd(vax);
            yCenter.selfAdd(vay);
            result.setCircumcenter(xCenter.doubleValue(), yCenter.doubleValue(), this.q11s.doubleValue());
        }
    }

    public Thresholds getThresholds() {
        return this.thresholds;
    }
}

