/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.edge;

import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.util.Formatter;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;
import org.tinfour.edge.QuadEdgePartner;
import org.tinfour.edge.QuadEdgePinwheel;

public class QuadEdge
implements IQuadEdge {
    int index;
    QuadEdge dual;
    Vertex v;
    QuadEdge f;
    QuadEdge r;

    QuadEdge() {
        this.dual = new QuadEdgePartner(this);
    }

    QuadEdge(QuadEdge partner) {
        this.dual = partner;
    }

    public QuadEdge(int index) {
        this.dual = new QuadEdgePartner(this);
        this.index = index;
    }

    public void setVertices(Vertex a, Vertex b) {
        this.v = a;
        this.dual.v = b;
    }

    @Override
    public final Vertex getA() {
        return this.v;
    }

    public final void setA(Vertex a) {
        this.v = a;
    }

    @Override
    public final Vertex getB() {
        return this.dual.v;
    }

    public final void setB(Vertex b) {
        this.dual.v = b;
    }

    @Override
    public final QuadEdge getForward() {
        return this.f;
    }

    @Override
    public final QuadEdge getReverse() {
        return this.r;
    }

    @Override
    public final QuadEdge getForwardFromDual() {
        return this.dual.f;
    }

    @Override
    public final QuadEdge getReverseFromDual() {
        return this.dual.r;
    }

    @Override
    public final QuadEdge getDualFromReverse() {
        return this.r.dual;
    }

    public final void setForward(QuadEdge e) {
        this.f = e;
        e.r = this;
    }

    public final void setReverse(QuadEdge e) {
        this.r = e;
        e.f = this;
    }

    public final void setDualForward(QuadEdge e) {
        this.dual.f = e;
        e.r = this.dual;
    }

    public final void setDualReverse(QuadEdge e) {
        this.dual.r = e;
        e.f = this.dual;
    }

    @Override
    public final QuadEdge getDual() {
        return this.dual;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getBaseIndex() {
        return this.index;
    }

    protected void setIndex(int index) {
        this.index = index;
    }

    @Override
    public QuadEdge getBaseReference() {
        return this;
    }

    @Override
    public int getConstraintIndex() {
        return this.dual.getConstraintIndex();
    }

    @Override
    public void setConstraintIndex(int constraintIndex) {
        this.dual.setConstraintIndex(constraintIndex);
    }

    @Override
    public boolean isConstrained() {
        return this.dual.isConstrained();
    }

    @Override
    public void setConstrained(int constraintIndex) {
        this.dual.setConstrained(constraintIndex);
    }

    public void clear() {
        this.v = null;
        this.f = null;
        this.r = null;
        this.dual.v = null;
        this.dual.f = null;
        this.dual.r = null;
        this.dual.index = 0;
    }

    String getName() {
        return Integer.toString(this.getIndex());
    }

    public String toString() {
        Vertex a = this.v;
        Vertex b = this.dual.v;
        if (a == null && b == null) {
            return String.format("%9d  -- Undefined", this.getIndex());
        }
        StringBuilder sb = new StringBuilder();
        try (Formatter fmt = new Formatter(sb);){
            fmt.format("%9s  %9s <-- (%9s,%9s) --> %9s", this.getName(), this.r == null ? "null" : this.r.getName(), a == null ? "gv" : a.getLabel(), b == null ? "gv" : b.getLabel(), this.f == null ? "null" : this.f.getName());
            fmt.flush();
        }
        if (this.isConstrained()) {
            sb.append("    constrained ");
            if (this.isConstrainedRegionBorder()) {
                sb.append("region border ");
            } else if (this.isConstraintLineMember()) {
                sb.append("line ");
            }
            sb.append(Integer.toString(this.getConstraintIndex()));
        } else if (this.isConstrainedRegionInterior()) {
            sb.append("    constrained region interior ");
            sb.append(Integer.toString(this.getConstraintIndex()));
        }
        return sb.toString();
    }

    @Override
    public double getLength() {
        if (this.v == null || this.dual.v == null) {
            return Double.NaN;
        }
        double dx = this.v.x - this.dual.v.x;
        double dy = this.v.y - this.dual.v.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    public int getSide() {
        return 0;
    }

    public boolean equals(Object o) {
        if (o instanceof QuadEdge) {
            return this == o;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + this.index;
        return hash;
    }

    @Override
    public boolean isConstrainedRegionMember() {
        return this.dual.isConstrainedRegionMember();
    }

    @Override
    public boolean isConstrainedRegionInterior() {
        return this.dual.isConstrainedRegionInterior();
    }

    @Override
    public boolean isConstrainedRegionBorder() {
        return this.dual.isConstrainedRegionBorder();
    }

    @Override
    public boolean isConstraintLineMember() {
        return this.dual.isConstraintLineMember();
    }

    @Override
    public void setConstraintLineMemberFlag() {
        this.dual.setConstraintLineMemberFlag();
    }

    @Override
    public void setConstrainedRegionBorderFlag() {
        this.dual.setConstrainedRegionBorderFlag();
    }

    @Override
    public void setConstrainedRegionInteriorFlag() {
        this.dual.setConstrainedRegionInteriorFlag();
    }

    @Override
    public void setSynthetic(boolean status) {
        this.dual.setSynthetic(status);
    }

    @Override
    public boolean isSynthetic() {
        return this.dual.isSynthetic();
    }

    @Override
    public Iterable<IQuadEdge> pinwheel() {
        return new QuadEdgePinwheel(this);
    }

    @Override
    public void setLine2D(AffineTransform transform, Line2D l2d) {
        Vertex A = this.getA();
        Vertex B = this.getB();
        double[] c = new double[8];
        if (A == null && B == null) {
            l2d.setLine(0.0, 0.0, 0.0, 0.0);
            return;
        }
        if (A == null) {
            c[0] = B.getX();
            c[1] = B.getY();
            c[2] = B.getX();
            c[3] = B.getY();
        } else if (B == null) {
            c[0] = A.getX();
            c[1] = A.getY();
            c[2] = A.getX();
            c[3] = A.getY();
        } else {
            c[0] = A.getX();
            c[1] = A.getY();
            c[2] = B.getX();
            c[3] = B.getY();
        }
        transform.transform(c, 0, c, 4, 2);
        l2d.setLine(c[4], c[5], c[6], c[7]);
    }
}

