/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gis.geotiff;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.zip.Deflater;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.PixelDensity;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.tiff.TiffElement;
import org.apache.commons.imaging.formats.tiff.TiffImageData;
import org.apache.commons.imaging.formats.tiff.constants.GdalLibraryTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GeoTiffTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldType;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldTypeDouble;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldTypeShort;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoAscii;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoShorts;
import org.apache.commons.imaging.formats.tiff.write.TiffImageWriterLossy;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputField;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.tinfour.gis.geotiff.GeoKey;

public class GeoTiffTableBuilder {
    private static final int DOUBLE_REF = 34736;
    private static final int ASCII_REF = 34737;
    private static final byte PIPE_CHAR = 124;
    List<GeoTiffKey> keyList = new ArrayList<GeoTiffKey>();
    List<Double> doubleList = new ArrayList<Double>();
    ByteArrayOutputStream baos = new ByteArrayOutputStream();
    AffineTransform model2Pixel;
    AffineTransform pixel2Model;
    private ByteOrder eTiffByteOrder = ByteOrder.LITTLE_ENDIAN;
    private String gdalNoData;
    private boolean compressionEnabled = false;

    public void setCompressionEnabled(boolean enabled) {
        this.compressionEnabled = enabled;
    }

    public void setGdalNoData(String noDataValue) {
        this.gdalNoData = noDataValue;
    }

    public void addGeoKey(GeoKey geoKey, int value) {
        this.keyList.add(new GeoTiffKey(geoKey, value));
    }

    public void addGeoKey(GeoKey geoKey, double value) {
        int pos = this.doubleList.size();
        this.doubleList.add(value);
        this.keyList.add(new GeoTiffKey(geoKey, 34736, 1, pos));
    }

    public void addGeoKey(GeoKey geoKey, double[] values) {
        int pos = this.doubleList.size();
        for (double v : values) {
            this.doubleList.add(v);
        }
        this.keyList.add(new GeoTiffKey(geoKey, 34736, pos, values.length));
    }

    public void addGeoKey(GeoKey geoKey, String value) {
        int pos = this.baos.size();
        for (int i = 0; i < value.length(); ++i) {
            int a = value.charAt(i) & 0xFF;
            this.baos.write(a);
        }
        this.baos.write(124);
        this.keyList.add(new GeoTiffKey(geoKey, 34737, pos, value.length() + 1));
    }

    public void setModelToPixelTransform(AffineTransform model2Pixel) {
        try {
            this.model2Pixel = model2Pixel;
            this.pixel2Model = model2Pixel.createInverse();
        }
        catch (NoninvertibleTransformException ex) {
            throw new IllegalArgumentException("Specified transform is not invertible", ex);
        }
    }

    public void setPixelToModelTransform(AffineTransform pixel2Model) {
        try {
            this.pixel2Model = pixel2Model;
            this.model2Pixel = pixel2Model.createInverse();
        }
        catch (NoninvertibleTransformException ex) {
            throw new IllegalArgumentException("Specified transform is not invertible", ex);
        }
    }

    public void storeContent(TiffOutputDirectory tiffOutputDirectory) throws IOException, ImageWriteException {
        Object tiepoint;
        if (this.pixel2Model != null) {
            double[] a = new double[6];
            this.pixel2Model.getMatrix(a);
            double[] d = new double[3];
            d[0] = a[0];
            d[1] = a[3];
            tiffOutputDirectory.add(GeoTiffTagConstants.EXIF_TAG_MODEL_PIXEL_SCALE_TAG, d);
            tiepoint = new double[]{0.0, 0.0, 0.0, a[4], a[5], 0.0};
            tiffOutputDirectory.add(GeoTiffTagConstants.EXIF_TAG_MODEL_TIEPOINT_TAG, (double)tiepoint);
        }
        Collections.sort(this.keyList, new Comparator<GeoTiffKey>(){

            @Override
            public int compare(GeoTiffKey o1, GeoTiffKey o2) {
                return Integer.compare(o1.geoKey.getKeyCode(), o1.geoKey.getKeyCode());
            }
        });
        short[] sArray = new short[(this.keyList.size() + 1) * 4];
        sArray[0] = 1;
        sArray[1] = 1;
        sArray[2] = 0;
        sArray[3] = (short)this.keyList.size();
        int k = 4;
        tiepoint = this.keyList.iterator();
        while (tiepoint.hasNext()) {
            GeoTiffKey gk = (GeoTiffKey)tiepoint.next();
            sArray[k++] = (short)gk.geoKey.getKeyCode();
            sArray[k++] = (short)gk.reference;
            sArray[k++] = (short)gk.len;
            sArray[k++] = (short)gk.valueOrPos;
        }
        FieldTypeShort fType = FieldType.SHORT;
        byte[] bytes = ((FieldType)fType).writeData(sArray, this.eTiffByteOrder);
        TagInfoShorts tInfo = GeoTiffTagConstants.EXIF_TAG_GEO_KEY_DIRECTORY_TAG;
        TiffOutputField tiffOutputFieldGeoKey = new TiffOutputField(tInfo.tag, tInfo, fType, sArray.length, bytes);
        int nB = this.baos.size();
        if (nB > 0) {
            TagInfoAscii aTagInfo = GeoTiffTagConstants.EXIF_TAG_GEO_ASCII_PARAMS_TAG;
            bytes = this.baos.toByteArray();
            TiffOutputField tiffOutputFieldGeoAscii = new TiffOutputField(aTagInfo.tag, aTagInfo, FieldType.ASCII, bytes.length, bytes);
            tiffOutputDirectory.add(tiffOutputFieldGeoAscii);
        }
        tiffOutputDirectory.add(tiffOutputFieldGeoKey);
        int nD = this.doubleList.size();
        if (nD > 0) {
            double[] d = new double[nD];
            this.encodeDouble(tInfo, d);
            TiffOutputField tiffOutputFieldGeoDoubleParams = this.encodeDouble(GeoTiffTagConstants.EXIF_TAG_GEO_DOUBLE_PARAMS_TAG, d);
            tiffOutputDirectory.add(tiffOutputFieldGeoDoubleParams);
        }
        if (this.gdalNoData != null && !this.gdalNoData.isBlank()) {
            tiffOutputDirectory.add(GdalLibraryTagConstants.EXIF_TAG_GDAL_NO_DATA, this.gdalNoData);
        }
    }

    TiffOutputField encodeDouble(TagInfo tInfo, double[] d) throws IOException, ImageWriteException {
        FieldTypeDouble fType = FieldType.DOUBLE;
        byte[] bytes = ((FieldType)fType).writeData(d, this.eTiffByteOrder);
        TiffOutputField tiffOutputField = new TiffOutputField(tInfo.tag, tInfo, fType, d.length, bytes);
        return tiffOutputField;
    }

    TiffOutputField encodeASCII(TagInfo tInfo, String string) throws IOException, ImageWriteException {
        byte[] bytes = FieldType.ASCII.writeData(string, this.eTiffByteOrder);
        TiffOutputField tiffOutputField = new TiffOutputField(tInfo.tag, tInfo, FieldType.ASCII, bytes.length, bytes);
        return tiffOutputField;
    }

    public byte[] encodeBlock(float[] f, int nRows, int scanSize) {
        if (!this.compressionEnabled) {
            int nCells = f.length;
            byte[] b = new byte[nCells * 4];
            int k = 0;
            for (int i = 0; i < nCells; ++i) {
                int ix = Float.floatToRawIntBits(f[i]);
                b[k++] = (byte)(ix & 0xFF);
                b[k++] = (byte)(ix >> 8 & 0xFF);
                b[k++] = (byte)(ix >> 16 & 0xFF);
                b[k++] = (byte)(ix >> 24 & 0xFF);
            }
            return b;
        }
        int nBytesInRow = scanSize * 4;
        byte[] b = new byte[f.length * 4];
        for (int iRow = 0; iRow < nRows; ++iRow) {
            int i;
            int rowOffset = iRow * scanSize;
            int aOffset = rowOffset * 4;
            int bOffset = aOffset + scanSize;
            int cOffset = bOffset + scanSize;
            int dOffset = cOffset + scanSize;
            for (i = 0; i < scanSize; ++i) {
                int ix = Float.floatToRawIntBits(f[rowOffset + i]);
                b[aOffset + i] = (byte)(ix >> 24 & 0xFF);
                b[bOffset + i] = (byte)(ix >> 16 & 0xFF);
                b[cOffset + i] = (byte)(ix >> 8 & 0xFF);
                b[dOffset + i] = (byte)(ix & 0xFF);
            }
            for (i = nBytesInRow - 1; i > 0; --i) {
                b[aOffset + i] = (byte)((b[aOffset + i] & 0xFF) - (b[aOffset + i - 1] & 0xFF));
            }
        }
        Deflater deflater = new Deflater(6);
        deflater.setInput(b, 0, b.length);
        deflater.finish();
        byte[] deflaterResult = new byte[b.length + 1024];
        int dN = deflater.deflate(deflaterResult, 0, deflaterResult.length, 3);
        if (dN <= 0) {
            return null;
        }
        return Arrays.copyOf(deflaterResult, dN);
    }

    public void writeTiles(File geoTiffFile, int width, int height, int tileSize, byte[][] tiles) throws IOException, ImageWriteException {
        PixelDensity pixelDensity = PixelDensity.createFromPixelsPerInch(96.0, 96.0);
        short compression = this.compressionEnabled ? (short)8 : 1;
        short samplesPerPixel = 1;
        short bitsPerSample = 32;
        short photometricInterpretation = 0;
        short planarConfiguration = 1;
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        TiffOutputSet outputSet = new TiffOutputSet(byteOrder);
        TiffOutputDirectory directory = outputSet.addRootDirectory();
        directory.add(TiffTagConstants.TIFF_TAG_IMAGE_WIDTH, width);
        directory.add(TiffTagConstants.TIFF_TAG_IMAGE_LENGTH, height);
        directory.add(TiffTagConstants.TIFF_TAG_PHOTOMETRIC_INTERPRETATION, photometricInterpretation);
        directory.add(TiffTagConstants.TIFF_TAG_COMPRESSION, compression);
        if (this.compressionEnabled) {
            directory.add(TiffTagConstants.TIFF_TAG_PREDICTOR, (short)3);
        }
        directory.add(TiffTagConstants.TIFF_TAG_PLANAR_CONFIGURATION, planarConfiguration);
        directory.add(TiffTagConstants.TIFF_TAG_SAMPLES_PER_PIXEL, samplesPerPixel);
        directory.add(TiffTagConstants.TIFF_TAG_BITS_PER_SAMPLE, bitsPerSample);
        directory.add(TiffTagConstants.TIFF_TAG_TILE_WIDTH, tileSize);
        directory.add(TiffTagConstants.TIFF_TAG_TILE_LENGTH, tileSize);
        directory.add(TiffTagConstants.TIFF_TAG_RESOLUTION_UNIT, (short)2);
        directory.add(TiffTagConstants.TIFF_TAG_XRESOLUTION, RationalNumber.valueOf(pixelDensity.horizontalDensityInches()));
        directory.add(TiffTagConstants.TIFF_TAG_YRESOLUTION, RationalNumber.valueOf(pixelDensity.verticalDensityInches()));
        directory.add(TiffTagConstants.TIFF_TAG_SAMPLE_FORMAT, 3);
        this.storeContent(directory);
        TiffElement.DataElement[] imageData = new TiffElement.DataElement[tiles.length];
        Arrays.setAll(imageData, i -> new TiffImageData.Data(0L, tiles[i].length, tiles[i]));
        TiffImageData.Tiles abstractTiffImageData = new TiffImageData.Tiles(imageData, tileSize, tileSize);
        directory.setTiffImageData(abstractTiffImageData);
        try (FileOutputStream fos = new FileOutputStream(geoTiffFile);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            new TiffImageWriterLossy().write(bos, outputSet);
        }
    }

    private static class GeoTiffKey {
        final GeoKey geoKey;
        final int reference;
        final int valueOrPos;
        final int len;

        GeoTiffKey(GeoKey geoKey, int reference, int valueOrPos, int len) {
            this.geoKey = geoKey;
            this.reference = reference;
            this.valueOrPos = valueOrPos;
            this.len = len;
        }

        GeoTiffKey(GeoKey geoKey, int value) {
            this.geoKey = geoKey;
            this.reference = 0;
            this.valueOrPos = value;
            this.len = 1;
        }
    }
}

