/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gis.shapefile;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.tinfour.gis.shapefile.DbfFieldDate;
import org.tinfour.gis.shapefile.DbfFieldDouble;
import org.tinfour.gis.shapefile.DbfFieldInt;
import org.tinfour.gis.shapefile.DbfFieldLogical;
import org.tinfour.gis.shapefile.DbfFileReader;
import org.tinfour.io.BufferedRandomAccessFile;
import org.tinfour.io.BufferedRandomAccessReader;

public class DbfField {
    protected final String name;
    protected final char fieldType;
    protected final int dataAddress;
    protected final int fieldLength;
    protected final int fieldDecimalCount;
    protected final int offset;
    protected final StringBuilder builder;
    protected final boolean numeric;
    protected final boolean isIntegral;

    DbfField(String name, char fieldType, int dataAddress, int fieldLength, int fieldDecimalCount, int offset) {
        this.name = name;
        this.fieldType = fieldType;
        this.dataAddress = dataAddress;
        this.fieldLength = fieldLength;
        this.fieldDecimalCount = fieldDecimalCount;
        this.offset = offset;
        this.builder = new StringBuilder(fieldLength + 1);
        this.numeric = fieldType == 'N' || fieldType == 'F';
        this.isIntegral = fieldType == 'N' && fieldDecimalCount == 0;
    }

    static DbfField load(BufferedRandomAccessReader brad, int offset) throws IOException {
        String name = brad.readAscii(11);
        char fieldType = (char)brad.readUnsignedByte();
        int dataAddress = brad.readInt();
        int fieldLength = brad.readUnsignedByte();
        int fieldDecimalCount = brad.readUnsignedByte();
        if (fieldType == 'F' || fieldType == 'N' && fieldDecimalCount > 0) {
            return new DbfFieldDouble(name, fieldType, dataAddress, fieldLength, fieldDecimalCount, offset, false);
        }
        if (fieldType == 'N' && fieldDecimalCount == 0) {
            return new DbfFieldInt(name, fieldType, dataAddress, fieldLength, fieldDecimalCount, offset);
        }
        if (fieldType == 'L') {
            return new DbfFieldLogical(name, fieldType, dataAddress, fieldLength, fieldDecimalCount, offset);
        }
        if (fieldType == 'D') {
            return new DbfFieldDate(name, fieldType, dataAddress, fieldLength, fieldDecimalCount, offset);
        }
        return new DbfField(name, fieldType, dataAddress, fieldLength, fieldDecimalCount, offset);
    }

    void read(BufferedRandomAccessReader brad, long recordFilePos) throws IOException {
        brad.seek(recordFilePos + (long)this.offset);
        this.builder.setLength(0);
        if (this.isNumeric()) {
            for (int i = 0; i < this.getFieldLength(); ++i) {
                char c = (char)brad.readUnsignedByte();
                if (Character.isWhitespace(c)) continue;
                this.builder.append(c);
            }
        } else {
            char c;
            byte[] b = new byte[this.fieldLength];
            for (int i = 0; i < this.fieldLength; ++i) {
                b[i] = brad.readByte();
            }
            String s = new String(b, StandardCharsets.UTF_8);
            int lastNonBlank = -1;
            for (int i = 0; i < s.length() && (c = s.charAt(i)) != '\u0000'; ++i) {
                if (!Character.isWhitespace(c)) {
                    lastNonBlank = i;
                }
                this.builder.append(c);
            }
            this.builder.setLength(lastNonBlank + 1);
        }
    }

    void write(BufferedRandomAccessFile braf) throws IOException {
        this.write(braf, this.builder.toString());
    }

    protected void write(BufferedRandomAccessFile braf, String s) throws IOException {
        byte[] b = s.getBytes(StandardCharsets.ISO_8859_1);
        int n = b.length;
        if (n >= this.fieldLength) {
            braf.write(b, 0, this.fieldLength);
        } else {
            braf.write(b, 0, b.length);
            for (int i = b.length; i < this.fieldLength; ++i) {
                braf.write(b[i]);
            }
        }
    }

    public boolean isIntegral() {
        return this.isIntegral;
    }

    public int getInteger() {
        if (this.isIntegral) {
            return Integer.parseInt(this.builder.toString());
        }
        return 0;
    }

    public double getDouble() {
        if (this.isNumeric() && this.builder.length() > 0) {
            return Double.parseDouble(this.builder.toString());
        }
        return Double.NaN;
    }

    public String getString() {
        return this.builder.toString();
    }

    public String getName() {
        return this.name;
    }

    public char getFieldType() {
        return this.fieldType;
    }

    public int getFieldLength() {
        return this.fieldLength;
    }

    public int getFieldDecimalCount() {
        return this.fieldDecimalCount;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean getLogicalValue() {
        return false;
    }

    public void setString(String value) {
        this.builder.setLength(0);
        if (value != null && !value.isEmpty()) {
            if (value.length() > this.fieldLength) {
                this.builder.append(value.substring(this.fieldLength));
            } else {
                this.builder.append(value);
                for (int i = value.length(); i < this.fieldLength; ++i) {
                    this.builder.append(' ');
                }
            }
        }
    }

    public String toString() {
        return String.format("DbfField (%s %2d.%-2d) %s", Character.valueOf(this.fieldType), this.fieldLength, this.fieldDecimalCount, this.name);
    }

    public Object getApplicationData() {
        return this.builder.toString();
    }

    public boolean usesEngineeringNotation() {
        return false;
    }

    public List<String> getUniqueValues(DbfFileReader dbf) throws IOException {
        int nRecords = dbf.getRecordCount();
        ArrayList<String> list = new ArrayList<String>(nRecords);
        if (nRecords == 0) {
            return list;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Object sMin = "";
        Object sMax = "";
        for (int i = 1; i <= nRecords; ++i) {
            dbf.readField(i, this);
            String s = this.getString();
            if (i == 1) {
                map.put(s, s);
                list.add(s);
                sMin = s;
                sMax = s;
                continue;
            }
            if (map.containsKey(s)) continue;
            map.put(s, s);
            list.add(s);
            if (s.compareTo((String)sMin) < 0) {
                sMin = s;
            }
            if (s.compareTo((String)sMax) > 0) {
                sMax = s;
            }
            if (((String)sMin).length() > 20) {
                sMin = ((String)sMin).substring(0, 17) + "...";
            }
            if (((String)sMax).length() <= 20) continue;
            sMax = ((String)sMax).substring(0, 17) + "...";
        }
        return list;
    }

    public boolean isNull() {
        return this.builder.length() == 0;
    }
}

