/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gis.shapefile;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import org.tinfour.gis.shapefile.DbfField;
import org.tinfour.gis.shapefile.DbfFileReader;
import org.tinfour.io.BufferedRandomAccessFile;
import org.tinfour.io.BufferedRandomAccessReader;

public class DbfFieldDouble
extends DbfField {
    private static final double LOG10 = Math.log(10.0);
    private double value;
    private boolean engineeringNotation;
    private String writingFormat;

    DbfFieldDouble(String name, char fieldType, int dataAddress, int fieldLength, int fieldDecimalCount, int offset, boolean useEngineeringNotation) {
        super(name, fieldType, dataAddress, fieldLength, fieldDecimalCount, offset);
        this.engineeringNotation = useEngineeringNotation;
        this.writingFormat = useEngineeringNotation ? String.format(Locale.US, "%%%d.%de", fieldLength, fieldLength - 7) : String.format(Locale.US, "%%%d.%df", fieldLength, fieldDecimalCount);
    }

    @Override
    void read(BufferedRandomAccessReader brad, long recordFilePos) throws IOException {
        int b;
        int i;
        brad.seek(recordFilePos + (long)this.offset);
        this.builder.setLength(0);
        this.engineeringNotation = false;
        double sign = 1.0;
        long s = 0L;
        long f = 0L;
        long d = 1L;
        for (i = 0; i < this.fieldLength; ++i) {
            b = brad.readUnsignedByte();
            this.builder.append((char)b);
            if (b == 32) {
                continue;
            }
            if (b == 45) {
                sign = -1.0;
                ++i;
                break;
            }
            if (b == 43) {
                ++i;
                break;
            }
            if (48 <= b && b <= 57) {
                s = b - 48;
                ++i;
                break;
            }
            if (b == 46 || b == 44) break;
            this.value = Double.NaN;
            this.builder.setLength(0);
            return;
        }
        if (i == this.fieldLength) {
            this.value = Double.NaN;
            this.builder.setLength(0);
            return;
        }
        while (i < this.fieldLength) {
            b = brad.readUnsignedByte();
            this.builder.append((char)b);
            if (b == 46 || b == 44) {
                ++i;
                break;
            }
            s = s * 10L + (long)(b - 48);
            ++i;
        }
        this.engineeringNotation = false;
        while (i < this.fieldLength) {
            b = brad.readUnsignedByte();
            this.builder.append((char)b);
            if (b == 32) break;
            if (b == 101 || b == 69) {
                this.engineeringNotation = true;
                break;
            }
            d *= 10L;
            f = f * 10L + (long)(b - 48);
            ++i;
        }
        this.value = sign * ((double)s + (double)f / (double)d);
        if (this.engineeringNotation) {
            if (i > this.fieldLength - 3) {
                this.value = Double.NaN;
            } else {
                s = 0L;
                ++i;
                b = brad.readUnsignedByte();
                this.builder.append((char)b);
                sign = b == 45 ? -1.0 : 1.0;
                ++i;
                d = 0L;
                while (i < this.fieldLength) {
                    b = brad.readUnsignedByte();
                    this.builder.append((char)b);
                    if (b == 32) break;
                    d = d * 10L + (long)(b - 48);
                    ++i;
                }
                if (d != 0L) {
                    double e = sign * (double)d;
                    this.value *= Math.exp(LOG10 * e);
                }
            }
        }
    }

    @Override
    void write(BufferedRandomAccessFile braf) throws IOException {
        String s = String.format(Locale.US, this.writingFormat, this.value);
        byte[] b = s.getBytes();
        if (b.length > this.fieldLength) {
            throw new IOException("Formatted output exceeds fieldLength of " + this.fieldLength + ": \"" + s + "\"");
        }
        braf.write(b, 0, this.fieldLength);
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    public void setDouble(double value) {
        this.value = value;
    }

    public void setInteger(int value) {
        this.value = value;
    }

    @Override
    public boolean usesEngineeringNotation() {
        return this.engineeringNotation;
    }

    @Override
    public int getInteger() {
        if (Double.isNaN(this.value)) {
            return 0;
        }
        if (this.value < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        if (this.value > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        return (int)this.value;
    }

    @Override
    public Object getApplicationData() {
        return this.value;
    }

    public double[] getUniqueValueArray(DbfFileReader dbf) throws IOException {
        Double vMin = Double.POSITIVE_INFINITY;
        Double vMax = Double.NEGATIVE_INFINITY;
        int nRecords = dbf.getRecordCount();
        double[] vArray = new double[nRecords];
        if (nRecords == 0) {
            return new double[0];
        }
        int k = 0;
        for (int i = 1; i <= nRecords; ++i) {
            dbf.readField(i, this);
            double v = this.getDouble();
            if (v < vMin) {
                vMin = v;
            }
            if (v > vMax) {
                vMax = v;
            }
            vArray[k++] = v;
        }
        Arrays.sort(vArray);
        int nUniqueValues = 1;
        double prior = vArray[0];
        for (int i = 1; i < nRecords; ++i) {
            if (vArray[i] == prior) continue;
            prior = vArray[i];
            vArray[nUniqueValues] = vArray[i];
            ++nUniqueValues;
        }
        return Arrays.copyOf(vArray, nUniqueValues);
    }
}

