/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gis.shapefile;

public enum ShapefileType {
    NullShape(0, false, false),
    Point(1, false, false),
    PolyLine(3, false, false),
    Polygon(5, false, false),
    MultiPoint(8, false, false),
    PointZ(11, true, false),
    PolyLineZ(13, true, false),
    PolygonZ(15, true, false),
    MultiPointZ(18, true, false),
    PointM(21, false, true),
    PolyLineM(23, false, true),
    PolygonM(25, false, true),
    MultiPointM(28, false, true),
    MultiPatch(31, false, true);

    private final int shapeTypeCode;
    private final boolean hasZ;
    private final boolean hasM;

    private ShapefileType(int shapeTypeCode, boolean hasZ, boolean hasM) {
        this.shapeTypeCode = shapeTypeCode;
        this.hasZ = hasZ;
        this.hasM = hasM;
    }

    public static ShapefileType getShapefileType(int code) {
        for (ShapefileType v : ShapefileType.values()) {
            if (v.shapeTypeCode != code) continue;
            return v;
        }
        return null;
    }

    public int getTypeCode() {
        return this.shapeTypeCode;
    }

    public boolean isPolygon() {
        return this == PolygonZ || this == Polygon || this == PolygonM;
    }

    public boolean isPolyLine() {
        return this == PolyLineZ || this == PolyLine || this == PolyLineM;
    }

    public boolean is3D() {
        return this.hasZ;
    }

    public boolean hasZ() {
        return this.hasZ;
    }

    public boolean hasM() {
        return this.hasM;
    }
}

