/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.interpolation;

import org.tinfour.common.Vertex;

public class NaturalNeighborElements {
    ResultType resultType;
    public double x;
    public double y;
    double areaOfEmbeddedPolygon;
    double[] lambda;
    Vertex[] neighbors;

    NaturalNeighborElements(double x, double y) {
        this.resultType = ResultType.EXTERIOR;
        this.x = x;
        this.y = y;
        this.areaOfEmbeddedPolygon = 0.0;
        this.lambda = new double[0];
        this.neighbors = new Vertex[0];
    }

    public NaturalNeighborElements(double x, double y, double[] lambda, Vertex[] neighbors, double areaOfEmbeddedPolygon) {
        this.resultType = ResultType.SUCCESS;
        this.x = x;
        this.y = y;
        this.areaOfEmbeddedPolygon = areaOfEmbeddedPolygon;
        this.lambda = lambda;
        this.neighbors = neighbors;
    }

    NaturalNeighborElements(double x, double y, Vertex neighbor) {
        this.resultType = ResultType.COLOCATION;
        this.x = x;
        this.y = y;
        this.areaOfEmbeddedPolygon = 0.0;
        this.lambda = new double[]{1.0};
        this.neighbors = new Vertex[]{neighbor};
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public double[] getSibsonCoordinates() {
        return this.lambda;
    }

    public Vertex[] getNaturalNeighbors() {
        return this.neighbors;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.x;
    }

    public double getAreaOfEnvelope() {
        double areaSum = 0.0;
        if (this.neighbors.length > 2) {
            Vertex a = this.neighbors[this.neighbors.length - 1];
            for (Vertex b : this.neighbors) {
                double aX = a.getX() - this.x;
                double aY = a.getY() - this.y;
                double bX = b.getX() - this.x;
                double bY = b.getY() - this.y;
                areaSum += aX * bY - aY * bX;
                a = b;
            }
        }
        return Math.abs(areaSum / 2.0);
    }

    public double getAreaOfEmbeddedPolygon() {
        return this.areaOfEmbeddedPolygon;
    }

    public int getElementCount() {
        return this.neighbors.length;
    }

    public static enum ResultType {
        SUCCESS,
        COLOCATION,
        EXTERIOR;

    }
}

