/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.svm;

import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.tinfour.common.IConstraint;
import org.tinfour.common.LinearConstraint;
import org.tinfour.common.PolygonConstraint;
import org.tinfour.common.Vertex;
import org.tinfour.gis.utils.ConstraintReaderShapefile;
import org.tinfour.gis.utils.VertexReaderLas;
import org.tinfour.svm.SvmBathymetryModel;
import org.tinfour.svm.SvmShapefileVertexReader;
import org.tinfour.utils.HilbertSort;
import org.tinfour.utils.Tincalc;
import org.tinfour.utils.loaders.ICoordinateTransform;
import org.tinfour.utils.loaders.IVerticalCoordinateTransform;
import org.tinfour.utils.loaders.VertexReaderText;

public class SvmBathymetryData {
    public static final int BATHYMETRY_SOURCE = 1;
    public static final int SUPPLEMENTAL_SOURCE = 2;
    public static final int FLAT_ADJUSTMENT = 3;
    private double zMin;
    private double zMax;
    private double zMean;
    private int zMaxIndex;
    private int zMinIndex;
    private final List<Vertex> soundings = new ArrayList<Vertex>();
    private final List<Vertex> supplement = new ArrayList<Vertex>();
    private final List<PolygonConstraint> boundaryConstraints = new ArrayList<PolygonConstraint>();
    private final List<PolygonConstraint> lakeConstraints = new ArrayList<PolygonConstraint>();
    private final List<PolygonConstraint> islandConstraints = new ArrayList<PolygonConstraint>();
    private final List<LinearConstraint> interiorConstraints = new ArrayList<LinearConstraint>();
    private List<Vertex> surveyPerimeter;
    double shoreReferenceElevation;
    private Rectangle2D soundingBounds;
    private Rectangle2D constraintBounds;
    private double nominalPointSpacing;
    private long timeToLoadData;
    private String prjContent;
    private final SvmBathymetryModel bathymetryModel;

    private SvmBathymetryData() {
        this.bathymetryModel = SvmBathymetryModel.Elevation;
    }

    public SvmBathymetryData(SvmBathymetryModel model) {
        if (model == null) {
            throw new IllegalArgumentException("A null bathymetry model specification is not supported");
        }
        this.bathymetryModel = model;
    }

    private List<Vertex> loadVertices(File vertexFile, String dbfBathymetryField, IVerticalCoordinateTransform verticalTransform, ICoordinateTransform horizontalTransform) throws IOException {
        List<Vertex> list;
        String extension = this.getFileExtension(vertexFile);
        if ("csv".equalsIgnoreCase(extension) || "txt".equalsIgnoreCase(extension) || "tab".equalsIgnoreCase(extension)) {
            VertexReaderText vertexReader = new VertexReaderText(vertexFile);
            vertexReader.setVerticalCoordinateTransform(verticalTransform);
            vertexReader.setCoordinateTransform(horizontalTransform);
            if (dbfBathymetryField != null && !dbfBathymetryField.isBlank()) {
                String[] a = dbfBathymetryField.split(",");
                if (a.length != 3 && (a = dbfBathymetryField.split("\t")).length != 3) {
                    a = dbfBathymetryField.split(" ");
                }
                vertexReader.setTargetHeaders(a);
            }
            list = vertexReader.read(null);
        } else if ("shp".equalsIgnoreCase(extension)) {
            SvmShapefileVertexReader vls = new SvmShapefileVertexReader(vertexFile);
            vls.setDbfFieldForZ(dbfBathymetryField);
            vls.setVerticalCoordinateTransform(verticalTransform);
            vls.setCoordinateTransform(horizontalTransform);
            list = vls.read(null);
            List<LinearConstraint> cList = vls.getLinearConstraints();
            this.interiorConstraints.addAll(cList);
        } else if ("las".equalsIgnoreCase(extension) || "laz".equalsIgnoreCase("laz")) {
            VertexReaderLas reader = new VertexReaderLas(vertexFile);
            list = reader.read(null);
        } else {
            throw new IllegalArgumentException("Unsupported file format " + extension + " for input soundings " + vertexFile.getPath());
        }
        return list;
    }

    public void loadSamples(File inputSoundingsFile, String dbfBathymetryField, IVerticalCoordinateTransform verticalTransform, ICoordinateTransform horizontalTransform) throws IOException {
        long time0 = System.nanoTime();
        List<Vertex> list = this.loadVertices(inputSoundingsFile, dbfBathymetryField, verticalTransform, horizontalTransform);
        for (Vertex v : list) {
            v.setAuxiliaryIndex(1);
        }
        this.soundings.addAll(list);
        String tmpStr = this.loadShapePrjFile(inputSoundingsFile);
        if (tmpStr != null) {
            this.prjContent = tmpStr;
        }
        double z0 = Double.POSITIVE_INFINITY;
        double z1 = Double.NEGATIVE_INFINITY;
        double zSum = 0.0;
        int indexOfMaxZ = -1;
        int indexOfMinZ = -1;
        Vertex v0 = this.soundings.get(0);
        Rectangle2D.Double r2d = new Rectangle2D.Double(v0.getX(), v0.getY(), 0.0, 0.0);
        for (Vertex v : this.soundings) {
            r2d.add(v.getX(), v.getY());
            double z = v.getZ();
            if (z > z1) {
                z1 = z;
                indexOfMaxZ = v.getIndex();
            }
            if (z < z0) {
                z0 = z;
                indexOfMinZ = v.getIndex();
            }
            zSum += z;
        }
        this.zMin = z0;
        this.zMax = z1;
        this.zMean = zSum / (double)this.soundings.size();
        this.zMaxIndex = indexOfMaxZ;
        this.zMinIndex = indexOfMinZ;
        this.soundingBounds = r2d;
        double area = this.soundingBounds.getWidth() * this.soundingBounds.getHeight();
        if (area == 0.0) {
            throw new IllegalArgumentException("Degenerate set of input samples, " + inputSoundingsFile.getPath());
        }
        int n = this.soundings.size();
        this.nominalPointSpacing = Tincalc.sampleSpacing(area, n);
        long time1 = System.nanoTime();
        this.timeToLoadData += time1 - time0;
    }

    public void loadSupplement(File inputSupplementFile, String dbfBathymetryField, IVerticalCoordinateTransform verticalTransform, ICoordinateTransform horizontalTransform) throws IOException {
        long time0 = System.nanoTime();
        List<Vertex> list = this.loadVertices(inputSupplementFile, dbfBathymetryField, verticalTransform, horizontalTransform);
        for (Vertex v : list) {
            v.setAuxiliaryIndex(2);
        }
        this.getSupplements().addAll(list);
        long time1 = System.nanoTime();
        this.timeToLoadData += time1 - time0;
    }

    public void loadBoundaryConstraints(File inputBoundaryFile, String dbfFieldForZ, IVerticalCoordinateTransform verticalTransform, ICoordinateTransform horizontalTransform) throws IOException {
        String tmpStr;
        long time0 = System.nanoTime();
        try (ConstraintReaderShapefile reader = new ConstraintReaderShapefile(inputBoundaryFile);){
            reader.setCoordinateTransform(horizontalTransform);
            reader.setDbfFieldForZ(dbfFieldForZ);
            reader.setVerticalCoordinateTransform(verticalTransform);
            List<IConstraint> list = reader.read();
            this.shoreReferenceElevation = Double.NaN;
            for (IConstraint c : list) {
                if (!(c instanceof PolygonConstraint)) continue;
                PolygonConstraint p = (PolygonConstraint)c;
                p.setApplicationData(true);
                this.boundaryConstraints.add(p);
                if (p.getArea() > 0.0) {
                    this.lakeConstraints.add(p);
                } else {
                    this.islandConstraints.add(p);
                }
                List<Vertex> vList = p.getVertices();
                if (Double.isNaN(this.shoreReferenceElevation)) {
                    Vertex v = vList.get(0);
                    this.shoreReferenceElevation = v.getZ();
                }
                if (this.constraintBounds == null) {
                    this.constraintBounds = p.getBounds();
                    continue;
                }
                this.constraintBounds.add(p.getBounds());
            }
        }
        if (this.prjContent == null && (tmpStr = this.loadShapePrjFile(inputBoundaryFile)) != null) {
            this.prjContent = tmpStr;
        }
        long time1 = System.nanoTime();
        this.timeToLoadData += time1 - time0;
    }

    public double getMinZ() {
        return this.zMin;
    }

    public double getMaxZ() {
        return this.zMax;
    }

    public double getMeanZ() {
        return this.zMean;
    }

    public double getNominalPointSpacing() {
        return this.nominalPointSpacing;
    }

    public List<Vertex> getSoundings() {
        ArrayList<Vertex> result = new ArrayList<Vertex>(this.soundings.size());
        result.addAll(this.soundings);
        return result;
    }

    public void addSoundings(List<Vertex> extraSoundings) {
        this.soundings.addAll(extraSoundings);
    }

    public List<Vertex> getSoundingsAndSupplements() {
        ArrayList<Vertex> result = new ArrayList<Vertex>(this.soundings.size() + this.supplement.size());
        result.addAll(this.soundings);
        result.addAll(this.supplement);
        return result;
    }

    public List<Vertex> getReducedListOfSoundings(int nTarget) {
        int n = this.soundings.size();
        if (n > 16) {
            HilbertSort hilbertSort = new HilbertSort();
            hilbertSort.sort(this.soundings);
        }
        ArrayList<Vertex> result = new ArrayList<Vertex>(nTarget + 10);
        int skip = (int)((double)this.soundings.size() / (double)nTarget + 0.5);
        if (skip == 0) {
            skip = 1;
        }
        int k = 0;
        for (int i = 0; i < nTarget && k < n; k += skip, ++i) {
            result.add(this.soundings.get(k));
        }
        return result;
    }

    public Rectangle2D getSoundingBounds() {
        return new Rectangle2D.Double(this.soundingBounds.getX(), this.soundingBounds.getY(), this.soundingBounds.getWidth(), this.soundingBounds.getHeight());
    }

    public Rectangle2D getBounds() {
        Rectangle2D bounds = null;
        if (this.soundingBounds != null) {
            bounds = new Rectangle2D.Double(this.soundingBounds.getX(), this.soundingBounds.getY(), this.soundingBounds.getWidth(), this.soundingBounds.getHeight());
        }
        if (this.constraintBounds != null) {
            if (bounds == null) {
                bounds = new Rectangle2D.Double(this.constraintBounds.getX(), this.constraintBounds.getY(), this.constraintBounds.getWidth(), this.constraintBounds.getHeight());
            } else {
                bounds.add(this.constraintBounds);
            }
        }
        if (bounds == null) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        return bounds;
    }

    public double getShoreReferenceElevation() {
        return this.shoreReferenceElevation;
    }

    public List<PolygonConstraint> getBoundaryConstraints() {
        return this.boundaryConstraints;
    }

    public long getTimeToLoadData() {
        return this.timeToLoadData;
    }

    public void printSummary(PrintStream ps) {
        double x0 = this.soundingBounds.getMinX();
        double y0 = this.soundingBounds.getMinY();
        double x1 = this.soundingBounds.getMaxX();
        double y1 = this.soundingBounds.getMaxY();
        ps.format("Input Data%n", new Object[0]);
        ps.format("  Soundings%n", new Object[0]);
        ps.format("     Count:               %7d%n", this.soundings.size());
        ps.format("     Min (x,y,z):         %9.1f, %9.1f, %9.2f (feature %d)%n", x0, y0, this.zMin, this.zMinIndex);
        ps.format("     Max (x,y,z):         %9.1f, %9.1f, %9.2f (feature %d)%n", x1, y1, this.zMax, this.zMaxIndex);
        ps.format("     width,height:        %9.1f, %9.1f%n", x1 - x0, y1 - y0);
        ps.format("     Est. sample spacing: %9.1f%n", this.nominalPointSpacing);
    }

    private String getFileExtension(File file) {
        String name;
        int i;
        if (file != null && (i = (name = file.getName()).lastIndexOf(46)) > 0 && i < name.length() - 1) {
            return name.substring(i + 1, name.length());
        }
        return null;
    }

    String matchCase(String source, String target) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < target.length(); ++i) {
            char s = i < source.length() ? source.charAt(i) : source.charAt(source.length() - 1);
            char t = target.charAt(i);
            if (Character.isLowerCase(s) && Character.isUpperCase(t)) {
                t = Character.toLowerCase(t);
            } else if (Character.isUpperCase(s) && Character.isLowerCase(t)) {
                t = Character.toUpperCase(t);
            }
            sb.append(t);
        }
        return sb.toString();
    }

    public List<PolygonConstraint> getLakeConstraints() {
        return this.lakeConstraints;
    }

    public List<PolygonConstraint> getIslandConstraints() {
        return this.islandConstraints;
    }

    public List<Vertex> getSupplements() {
        return this.supplement;
    }

    private String loadShapePrjFile(File target) throws IOException {
        String extension = this.getFileExtension(target);
        if (!"shp".equals(extension)) {
            return null;
        }
        File parent = target.getParentFile();
        if (parent == null) {
            parent = new File(".");
        }
        String name = target.getName();
        String baseName = name.substring(0, name.length() - 4);
        String targetName = baseName + "." + this.matchCase(extension, "prj");
        File targetFile = new File(parent, targetName);
        StringBuilder sb = new StringBuilder();
        try (FileInputStream fins = new FileInputStream(targetFile);
             BufferedInputStream bins = new BufferedInputStream(fins);){
            int c;
            while ((c = bins.read()) > 0) {
                sb.append((char)c);
            }
        }
        return sb.toString();
    }

    public String getShapefilePrjContent() {
        return this.prjContent;
    }

    public SvmBathymetryModel getBathymetryModel() {
        return this.bathymetryModel;
    }

    public void setSurveyPerimeter(List<Vertex> perimeterVertices) {
        this.surveyPerimeter = perimeterVertices;
    }

    public List<Vertex> getSurveyPerimeter() {
        return this.surveyPerimeter;
    }

    void replaceSoundings(List<Vertex> replacements) {
        this.soundings.clear();
        this.supplement.clear();
        this.soundings.addAll(replacements);
    }

    List<LinearConstraint> getInteriorConstraints() {
        return this.interiorConstraints;
    }
}

