/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.svm;

import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.tinfour.common.GeometricOperations;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.LinearConstraint;
import org.tinfour.common.PolygonConstraint;
import org.tinfour.common.SimpleTriangle;
import org.tinfour.common.Thresholds;
import org.tinfour.common.Vertex;
import org.tinfour.semivirtual.SemiVirtualIncrementalTin;
import org.tinfour.standard.IncrementalTin;
import org.tinfour.svm.SvmBathymetryData;
import org.tinfour.svm.SvmBathymetryModel;
import org.tinfour.svm.SvmCapacityGraph;
import org.tinfour.svm.SvmContourGraph;
import org.tinfour.svm.SvmDrawdownGraph;
import org.tinfour.svm.SvmFlatFixer;
import org.tinfour.svm.SvmRaster;
import org.tinfour.svm.SvmRasterGeoTiff;
import org.tinfour.svm.SvmRefinement;
import org.tinfour.svm.SvmSinglePointAnomalyFilter;
import org.tinfour.svm.SvmTriangleVolumeTabulator;
import org.tinfour.svm.properties.SvmProperties;
import org.tinfour.utils.HilbertSort;
import org.tinfour.utils.KahanSummation;
import org.tinfour.utils.TriangleCollector;

public class SvmComputation {
    private static final int N_VERTICES_FOR_SEMI_VIRTUAL = 100000;

    public void processVolume(PrintStream ps, SvmProperties properties, SvmBathymetryData data) throws IOException {
        File contourOutput;
        SvmDrawdownGraph drawdownGraph;
        SvmCapacityGraph capacityGraph;
        boolean wroteGraph;
        SvmBathymetryModel bathymetryModel = properties.getBathymetryModel();
        double nominalPointSpacing = data.getNominalPointSpacing() < 1.0 ? 1.0 : data.getNominalPointSpacing();
        String lengthUnits = properties.getUnitOfDistance().getLabel();
        double lengthFactor = properties.getUnitOfDistance().getScaleFactor();
        String areaUnits = properties.getUnitOfArea().getLabel();
        double areaFactor = properties.getUnitOfArea().getScaleFactor();
        String volumeUnits = properties.getUnitOfVolume().getLabel();
        double volumeFactor = properties.getUnitOfVolume().getScaleFactor();
        double shoreReferenceElevation = properties.getShorelineReferenceElevation();
        if (Double.isNaN(shoreReferenceElevation)) {
            shoreReferenceElevation = data.getShoreReferenceElevation();
        }
        List<Vertex> soundings = data.getSoundingsAndSupplements();
        List<PolygonConstraint> boundaryConstraints = data.getBoundaryConstraints();
        List<LinearConstraint> interiorConstraints = data.getInteriorConstraints();
        ArrayList<IConstraint> allConstraints = new ArrayList<IConstraint>();
        allConstraints.addAll(interiorConstraints);
        allConstraints.addAll(boundaryConstraints);
        if (soundings.isEmpty()) {
            ps.print("Unable to proceed, no soundings are available");
            ps.flush();
            throw new IOException("No soungings availble");
        }
        if (boundaryConstraints.isEmpty()) {
            ps.print("Unable to proceed, no boundary constraints are available");
            ps.flush();
            throw new IOException("No boundary constraints availble");
        }
        long time0 = System.nanoTime();
        IIncrementalTin tin = soundings.size() < 100000 ? new IncrementalTin(nominalPointSpacing) : new SemiVirtualIncrementalTin(nominalPointSpacing);
        HilbertSort hilbert1 = new HilbertSort();
        hilbert1.sort(soundings);
        tin.add(soundings, null);
        long time1 = System.nanoTime();
        tin.addConstraints(allConstraints, true);
        long time2 = System.nanoTime();
        long timeToBuildTin = time1 - time0;
        long timeToAddConstraints = time2 - time1;
        long spTime0 = System.nanoTime();
        SampleSpacing spacing = this.evaluateSampleSpacing(tin);
        long spTime1 = System.nanoTime();
        long timeToFindSampleSpacing = spTime1 - spTime0;
        if (properties.isExperimentalFilterEnabled()) {
            ps.println("Processing experimental filter");
            spTime0 = System.nanoTime();
            SvmSinglePointAnomalyFilter filter = new SvmSinglePointAnomalyFilter(properties);
            int nFilter = filter.process(ps, tin);
            ps.format("  Slope of anomaly  %10.3f%n", filter.getSlopeOfAnomaly());
            ps.format("  Slope of support  %10.3f%n", filter.getSlopeOfSupport());
            ps.format("  Points removed    %10d%n", nFilter);
            if (nFilter > 0) {
                ArrayList<Vertex> filteredSamples = new ArrayList<Vertex>(soundings.size());
                for (Vertex v : soundings) {
                    if (v.isWithheld()) continue;
                    filteredSamples.add(v);
                }
                soundings = filteredSamples;
                data.replaceSoundings(filteredSamples);
                spTime1 = System.nanoTime();
                long timeToFilter = spTime1 - spTime0;
                ps.format("  Time for experimental filter   %9.1f ms%n", (double)timeToFilter / 1000000.0);
                File filterOutputFile = properties.getExperimentalFilterFile();
                if (filterOutputFile != null) {
                    try (FileOutputStream tableOutputStream = new FileOutputStream(filterOutputFile);
                         BufferedOutputStream bos = new BufferedOutputStream(tableOutputStream);
                         PrintStream fs = new PrintStream((OutputStream)bos, true, "UTF-8");){
                        fs.println("x\ty\tz\tindex");
                        for (Vertex v : soundings) {
                            fs.format("%12.6f\t%12.6f\t%5.4f\t%d%n", v.getX(), v.getY(), v.getZ(), v.getIndex());
                        }
                        fs.flush();
                    }
                    catch (IOException ioex) {
                        ps.println("IOException writing filter output " + ioex.getMessage());
                    }
                }
            }
        }
        double zFlatShore = shoreReferenceElevation;
        if (bathymetryModel == SvmBathymetryModel.Depth) {
            zFlatShore = 0.0;
        }
        TriangleSurvey trigSurvey = new TriangleSurvey(tin, zFlatShore);
        TriangleCollector.visitSimpleTriangles(tin, trigSurvey);
        long timeToFixFlats = 0L;
        if (properties.isFlatFixerEnabled()) {
            long timeF0 = System.nanoTime();
            int nRemediationVertices = 0;
            ps.println("");
            ps.println("Remediating flat triangles");
            for (int iFlat = 0; iFlat < 500; ++iFlat) {
                SvmFlatFixer flatFixer = new SvmFlatFixer(tin, zFlatShore);
                List<Vertex> fixList = flatFixer.fixFlats(ps);
                if (fixList.isEmpty()) {
                    if (iFlat != 0) break;
                    if (flatFixer.getFlatCount() == 0) {
                        ps.println("No flat triangles were detected");
                        System.out.println("No flat triangles were detected");
                        break;
                    }
                    ps.println("Insufficient data to fix flat triangles for " + flatFixer.getFlatCount() + " found");
                    System.out.println("Insufficient data to fix flat triangles for " + flatFixer.getFlatCount() + " found");
                    break;
                }
                if (iFlat == 0) {
                    System.out.println("Pass   Remediated        Area     Volume Added    avg. depth");
                }
                if (iFlat % 10 == 0) {
                    double fixArea = flatFixer.getRemediatedArea();
                    double fixVolume = flatFixer.getRemediatedVolume();
                    System.out.format("%4d  %8d  %14.3f  %14.3f  %7.3f%n", iFlat, flatFixer.getRemediationCount(), fixArea / areaFactor, fixVolume / volumeFactor, fixVolume / fixArea / lengthFactor);
                }
                nRemediationVertices += fixList.size();
                soundings.addAll(fixList);
            }
            ps.println("N remediation vertices added: " + nRemediationVertices);
            tin.dispose();
            tin = soundings.size() < 100000 ? new IncrementalTin(nominalPointSpacing) : new SemiVirtualIncrementalTin(nominalPointSpacing);
            HilbertSort hilbert = new HilbertSort();
            hilbert.sort(soundings);
            tin.add(soundings, null);
            tin.addConstraints(allConstraints, true);
            long timeF1 = System.nanoTime();
            timeToFixFlats = timeF1 - timeF0;
        }
        ps.println("");
        ps.println("Processing data from Delaunay Triangulation");
        time1 = System.nanoTime();
        double tableInterval = properties.getTableInterval();
        double zShore = data.shoreReferenceElevation;
        double zMin = data.getMinZ();
        int nStep = (int)(Math.ceil(zShore - zMin) / tableInterval) + 1;
        if (nStep > 10000) {
            nStep = 10000;
        }
        if (nStep < 0) {
            String gripe = "Error in elevation or data extraction model and attribute settings";
            ps.println(gripe);
            throw new IllegalArgumentException(gripe);
        }
        double[] zArray = new double[nStep];
        for (int i = 0; i < nStep; ++i) {
            zArray[i] = zShore - (double)i * tableInterval;
        }
        SvmTriangleVolumeTabulator volumeTabulator = new SvmTriangleVolumeTabulator(tin, zShore, zArray);
        volumeTabulator.process(tin);
        time2 = System.nanoTime();
        List<PolygonConstraint> lakeConstraints = data.getLakeConstraints();
        List<PolygonConstraint> islandConstraints = data.getIslandConstraints();
        double lakeArea = this.getAreaSum(lakeConstraints) / areaFactor;
        double islandArea = Math.abs(this.getAreaSum(islandConstraints) / areaFactor);
        double lakePerimeter = this.getPerimeterSum(lakeConstraints) / lengthFactor;
        double islandPerimeter = this.getPerimeterSum(islandConstraints) / lengthFactor;
        double netArea = lakeArea - islandArea;
        double totalShore = lakePerimeter + islandPerimeter;
        Rectangle2D bounds = data.getBounds();
        ps.format("%nData from Shapefiles and Source Data --------------------------------------------%n", new Object[0]);
        if (properties.doesLocaleUseCommaForDecimal()) {
            ps.format("  Lake area           %18.2f %s%n", lakeArea, areaUnits);
            ps.format("  Island area         %18.2f %s%n", islandArea, areaUnits);
            ps.format("  Net area (water)    %18.2f %s%n", netArea, areaUnits);
            ps.format("  Lake shoreline      %18.2f %s%n", lakePerimeter, lengthUnits);
            ps.format("  Island shoreline    %18.2f %s%n", islandPerimeter, lengthUnits);
            ps.format("  Total shoreline     %18.2f %s%n", totalShore, lengthUnits);
        } else {
            ps.format("  Lake area           %,18.2f %s%n", lakeArea, areaUnits);
            ps.format("  Island area         %,18.2f %s%n", islandArea, areaUnits);
            ps.format("  Net area (water)    %,18.2f %s%n", netArea, areaUnits);
            ps.format("  Lake shoreline      %,18.2f %s%n", lakePerimeter, lengthUnits);
            ps.format("  Island shoreline    %,18.2f %s%n", islandPerimeter, lengthUnits);
            ps.format("  Total shoreline     %,18.2f %s%n", totalShore, lengthUnits);
        }
        ps.format("  N Islands           %18d%n", islandConstraints.size());
        ps.format("  N Soundings         %18d%n", data.getSoundings().size());
        ps.format("  N Supplements       %18d%n", data.getSupplements().size());
        ps.format("  Bounds%n", new Object[0]);
        ps.format("     x:    %12.3f to %12.3f, (%5.3f)%n", bounds.getMinX() / lengthFactor, bounds.getMaxX() / lengthFactor, bounds.getWidth() / lengthFactor);
        ps.format("     y:    %12.3f to %12.3f, (%5.3f)%n", bounds.getMinY() / lengthFactor, bounds.getMaxY() / lengthFactor, bounds.getHeight() / lengthFactor);
        ps.format("     z:    %12.3f to %12.3f, (%5.3f)%n", data.getMinZ() / lengthFactor, data.getMaxZ() / lengthFactor, (data.getMaxZ() - data.getMinZ()) / lengthFactor);
        ps.format("  Sounding spacing%n", new Object[0]);
        ps.format("     mean            %12.3f %s%n", spacing.mean / lengthFactor, lengthUnits);
        ps.format("     std dev         %12.3f %s%n", spacing.sigma / lengthFactor, lengthUnits);
        ps.format("     25th percentile %12.3f %s%n", spacing.percentile25 / lengthFactor, lengthUnits);
        ps.format("     median          %12.3f %s%n", spacing.median / lengthFactor, lengthUnits);
        ps.format("     75th percentile %12.3f %s%n", spacing.percentile75 / lengthFactor, lengthUnits);
        ps.format("     maximim         %12.3f %s%n", spacing.lenMax / lengthFactor, lengthUnits);
        ps.format("     minimum         %14.5f %s%n", spacing.lenMin / lengthFactor, lengthUnits);
        ps.format("%n", new Object[0]);
        double rawVolume = volumeTabulator.getVolume();
        double rawSurfArea = volumeTabulator.getSurfaceArea();
        double rawAdjMeanDepth = volumeTabulator.getAdjustedMeanDepth();
        double totalVolume = volumeTabulator.getVolume();
        double volume = volumeTabulator.getVolume() / volumeFactor;
        double surfArea = volumeTabulator.getSurfaceArea() / areaFactor;
        double totalArea = volumeTabulator.getSurfaceArea();
        double avgDepth = rawVolume / rawSurfArea / lengthFactor;
        double adjMeanDepth = rawAdjMeanDepth / lengthFactor;
        double rawFlatArea = volumeTabulator.getFlatArea();
        double flatArea = volumeTabulator.getFlatArea() / areaFactor;
        List<SvmTriangleVolumeTabulator.AreaVolumeSum> resultList = volumeTabulator.getResults();
        ps.format("%nComputations from Constrained Delaunay Triangulation -----------------------------%n", new Object[0]);
        if (properties.doesLocaleUseCommaForDecimal()) {
            ps.format("  Volume              %18.2f %-12s     %24.1f %s^3%n", volume, volumeUnits, rawVolume, lengthUnits);
            ps.format("  Surface Area        %18.2f %-12s     %24.1f %s^2%n", surfArea, areaUnits, rawSurfArea, lengthUnits);
            ps.format("  Flat Area           %18.2f %-12s     %24.1f %s^2%n", flatArea, areaUnits, rawFlatArea, lengthUnits);
            ps.format("  Avg depth           %18.2f %s%n", avgDepth, lengthUnits);
            ps.format("  Adj mean depth      %18.2f %s%n", adjMeanDepth, lengthUnits);
            ps.format("  Mean Vertex Spacing %18.2f %s%n", spacing.mean, lengthUnits);
        } else {
            ps.format("  Volume              %,18.2f %-12s     %,24.1f %s^3%n", volume, volumeUnits, rawVolume, lengthUnits);
            ps.format("  Surface Area        %,18.2f %-12s     %,24.1f %s^2%n", surfArea, areaUnits, rawSurfArea, lengthUnits);
            ps.format("  Flat Area           %,18.2f %-12s     %,24.1f %s^2%n", flatArea, areaUnits, rawFlatArea, lengthUnits);
            ps.format("  Avg depth           %,18.2f %s%n", avgDepth, lengthUnits);
            ps.format("  Adj mean depth      %,18.2f %s%n", adjMeanDepth, lengthUnits);
            ps.format("  Mean Vertex Spacing %,18.2f %s%n", spacing.mean, lengthUnits);
        }
        ps.format("  N Triangles         %15d%n", volumeTabulator.nTriangles);
        ps.format("  N Flat Triangles    %15d%n", volumeTabulator.nFlatTriangles);
        if (properties.isFlatFixerEnabled()) {
            int originalTrigCount = trigSurvey.nTriangles;
            int originalFlatCount = trigSurvey.getFlatTriangleCount();
            double originalFlatArea = trigSurvey.getFlatArea() / areaFactor;
            ps.format("%nPre-Remediation statistics%n", new Object[0]);
            ps.format("  Original Flat Area  %14.10e %,20.2f %s%n", originalFlatArea, originalFlatArea, areaUnits);
            ps.format("  Original N Triangle %d%n", originalTrigCount);
            ps.format("  Original N Flat     %d%n", originalFlatCount);
        }
        ps.format("%n%n%n", new Object[0]);
        ps.format("Time to load data              %9.1f ms%n", (double)data.getTimeToLoadData() / 1000000.0);
        ps.format("Time to build TIN              %9.1f ms%n", (double)timeToBuildTin / 1000000.0);
        ps.format("Time to add shore constraint   %9.1f ms%n", (double)timeToAddConstraints / 1000000.0);
        ps.format("Time to find sample spacing    %9.1f ms%n", (double)timeToFindSampleSpacing / 1000000.0);
        ps.format("Time to remedy flat triangles  %9.1f ms%n", (double)timeToFixFlats / 1000000.0);
        ps.format("Time to compute lake volume    %9.1f ms%n", (double)(time2 - time1) / 1000000.0);
        ps.format("Time for all analysis          %9.1f ms%n", (double)(time2 - time0) / 1000000.0);
        ps.format("Time for all operations        %9.1f ms%n", (double)(data.getTimeToLoadData() + time2 - time0) / 1000000.0);
        ps.format("%n%nVolume Store Triangle Count: %d%n", volumeTabulator.nTriangles);
        ps.flush();
        File tableFile = properties.getTableFile();
        if (tableFile != null) {
            String tableFileName = tableFile.getName();
            boolean csvFlag = tableFileName.toLowerCase().endsWith(".csv");
            if (csvFlag && properties.doesLocaleUseCommaForDecimal()) {
                System.out.println("\nNote: Using CSV file for table output may conflict with formatting specified by Locale\n");
            }
            try (FileOutputStream tableOutputStream = new FileOutputStream(tableFile);
                 BufferedOutputStream bos = new BufferedOutputStream(tableOutputStream);
                 PrintStream ts = new PrintStream((OutputStream)bos, true, "UTF-8");){
                String lineFormat;
                if (csvFlag) {
                    ts.println("Elevation, Drawdown, Area, Percent_area, Volume, Volume_loss, Percent_volume");
                    lineFormat = "%12.3f, %12.3f, %12.3f, %6.2f, %12.3f, %12.3f, %6.2f%n";
                } else {
                    ts.println("Elevation\tDrawdown\tArea\tPercent_area\tVolume\tVolume_loss\tPercent_volume");
                    lineFormat = "%12.3f\t%12.3f\t%12.3f\t%6.2f\t%12.3f\t%12.3f\t%6.2f%n";
                }
                for (SvmTriangleVolumeTabulator.AreaVolumeSum avSum : resultList) {
                    double drawdown;
                    double elevation;
                    if (bathymetryModel == SvmBathymetryModel.Elevation) {
                        elevation = avSum.level;
                        drawdown = elevation - shoreReferenceElevation;
                    } else {
                        elevation = avSum.level + shoreReferenceElevation;
                        drawdown = avSum.level;
                    }
                    double areaAtLevel = avSum.areaSum.getSum();
                    double volumeAtLevel = avSum.volumeSum.getSum();
                    ts.format(lineFormat, elevation, drawdown, areaAtLevel / areaFactor, 100.0 * areaAtLevel / totalArea, volumeAtLevel / volumeFactor, (totalVolume - volumeAtLevel) / volumeFactor, 100.0 * volumeAtLevel / totalVolume);
                    if (volumeAtLevel != 0.0) continue;
                    break;
                }
            }
            catch (IOException ioex) {
                ps.println("Serious error writing elevation/volume table " + ioex.getMessage());
            }
        }
        SvmRasterGeoTiff rTiff = new SvmRasterGeoTiff();
        rTiff.buildAndWriteRaster(properties, data, ps, tin, volumeTabulator.water, shoreReferenceElevation);
        File gridFile = properties.getGridFile();
        double s = properties.getGridCellSize();
        if (gridFile != null && !Double.isNaN(s)) {
            SvmRaster grid = new SvmRaster();
            grid.buildAndWriteRaster(properties, data, ps, tin, volumeTabulator.water, shoreReferenceElevation);
        } else {
            File gridImageFile = properties.getGridImageFile();
            if (gridImageFile != null) {
                ps.println("\nNote: The properties specify a grid-image file " + gridImageFile.getPath());
                ps.println("but not a grid file. An image file cannot be produced");
                ps.println("without a valid grid file.\n");
            }
        }
        if (properties.isCapacityGraphEnabled() && (wroteGraph = (capacityGraph = new SvmCapacityGraph(properties, resultList, totalVolume)).writeOutput())) {
            ps.println("Capacity graph written to " + properties.getCapacityGraphFile());
        }
        if (properties.isDrawdownGraphEnabled() && (wroteGraph = (drawdownGraph = new SvmDrawdownGraph(properties, resultList, totalVolume)).writeOutput())) {
            ps.println("Drawdown graph written to " + properties.getDrawdownGraphFile());
        }
        if ((contourOutput = properties.getContourGraphFile()) != null) {
            long subtime0 = System.currentTimeMillis();
            System.out.println("\nIn preparation for contouring, subdividing large triangles");
            ps.println("\nIn preparation for contouring, subdividing large triangles");
            SvmRefinement refinement = new SvmRefinement();
            List<Vertex> vList = refinement.subdivideLargeTriangles(ps, tin, 0.95);
            long subtime1 = System.currentTimeMillis();
            System.out.println("\nCompleted subdividing large triangles in " + (subtime1 - subtime0) + " ms");
            if (!vList.isEmpty()) {
                tin.dispose();
                soundings.addAll(vList);
                HilbertSort hilbert = new HilbertSort();
                hilbert.sort(soundings);
                tin = soundings.size() < 100000 ? new IncrementalTin(nominalPointSpacing) : new SemiVirtualIncrementalTin(nominalPointSpacing);
                tin.add(soundings, null);
                tin.addConstraints(allConstraints, true);
            }
            SvmContourGraph.write(ps, properties, data, shoreReferenceElevation, tin);
        }
    }

    private double getAreaSum(List<PolygonConstraint> constraints) {
        KahanSummation areaSum = new KahanSummation();
        for (PolygonConstraint con : constraints) {
            areaSum.add(con.getArea());
        }
        return areaSum.getSum();
    }

    private double getPerimeterSum(List<PolygonConstraint> constraints) {
        KahanSummation perimeterSum = new KahanSummation();
        for (PolygonConstraint con : constraints) {
            perimeterSum.add(con.getLength());
        }
        return perimeterSum.getSum();
    }

    private SampleSpacing evaluateSampleSpacing(IIncrementalTin tin) {
        List<IConstraint> constraintsFromTin = tin.getConstraints();
        boolean[] water = new boolean[constraintsFromTin.size()];
        for (IConstraint con : constraintsFromTin) {
            water[con.getConstraintIndex()] = (Boolean)con.getApplicationData();
        }
        KahanSummation sumLen = new KahanSummation();
        KahanSummation sumLen2 = new KahanSummation();
        int nEdgeMax = tin.getMaximumEdgeAllocationIndex();
        float[] lenArray = new float[nEdgeMax];
        int nLen = 0;
        double lenMin = Double.POSITIVE_INFINITY;
        double lenMax = Double.NEGATIVE_INFINITY;
        for (IQuadEdge edge : tin.edges()) {
            int conIndex;
            if (!edge.isConstrainedRegionInterior() || !water[conIndex = edge.getConstraintIndex()]) continue;
            Vertex a = edge.getA();
            Vertex b = edge.getB();
            int aAux = a.getAuxiliaryIndex();
            int bAux = b.getAuxiliaryIndex();
            if (aAux != 1 || bAux != 1) continue;
            double len = edge.getLength();
            sumLen.add(len);
            sumLen2.add(len * len);
            lenArray[nLen++] = (float)len;
            if (len < lenMin) {
                lenMin = len;
            }
            if (!(len > lenMax)) continue;
            lenMax = len;
        }
        Arrays.sort(lenArray, 0, nLen);
        double sLen = sumLen.getSum();
        double sLen2 = sumLen2.getSum();
        double sigma = Double.NaN;
        double mean = sumLen.getMean();
        double median = lenArray[nLen / 2];
        if (nLen > 2) {
            sigma = Math.sqrt((sLen2 - sLen / (double)nLen * sLen) / (double)(nLen - 1));
        }
        double percentile25 = lenArray[(int)((double)nLen * 0.25 + 0.5)];
        double percentile75 = lenArray[(int)((double)nLen * 0.75 + 0.5)];
        return new SampleSpacing(nLen, mean, sigma, median, lenMin, lenMax, percentile25, percentile75);
    }

    private static class SampleSpacing {
        final int nSamples;
        final double sigma;
        final double mean;
        final double median;
        final double lenMin;
        final double lenMax;
        final double percentile25;
        final double percentile75;

        SampleSpacing(int nSamples, double mean, double sigma, double median, double lenMin, double lenMax, double percentile25, double percentile75) {
            this.nSamples = nSamples;
            this.mean = mean;
            this.sigma = sigma;
            this.median = median;
            this.lenMin = lenMin;
            this.lenMax = lenMax;
            this.percentile25 = percentile25;
            this.percentile75 = percentile75;
        }
    }

    private static class TriangleSurvey
    implements Consumer<SimpleTriangle> {
        double shoreReferenceElevation;
        boolean[] water;
        int nTriangles;
        int nFlatTriangles;
        KahanSummation areaSum = new KahanSummation();
        KahanSummation flatAreaSum = new KahanSummation();
        KahanSummation depthAreaSum = new KahanSummation();
        KahanSummation depthAreaWeightedSum = new KahanSummation();
        final GeometricOperations geoOp;

        TriangleSurvey(IIncrementalTin tin, double shoreReferenceElevation) {
            this.shoreReferenceElevation = shoreReferenceElevation;
            List<IConstraint> constraintsFromTin = tin.getConstraints();
            this.water = new boolean[constraintsFromTin.size()];
            for (IConstraint con : constraintsFromTin) {
                this.water[con.getConstraintIndex()] = (Boolean)con.getApplicationData();
            }
            Thresholds thresholds = tin.getThresholds();
            this.geoOp = new GeometricOperations(thresholds);
        }

        private boolean nEqual(double a, double b) {
            return Math.abs(a - b) < 0.001;
        }

        @Override
        public void accept(SimpleTriangle t) {
            Boolean appData;
            IConstraint constraint = t.getContainingRegion();
            if (constraint instanceof PolygonConstraint && (appData = (Boolean)constraint.getApplicationData()).booleanValue()) {
                IQuadEdge a = t.getEdgeA();
                IQuadEdge b = t.getEdgeB();
                IQuadEdge c = t.getEdgeC();
                Vertex vA = a.getA();
                Vertex vB = b.getA();
                Vertex vC = c.getA();
                double zA = vA.getZ();
                double zB = vB.getZ();
                double zC = vC.getZ();
                double area = this.geoOp.area(vA, vB, vC);
                if (this.nEqual(zA, this.shoreReferenceElevation) && this.nEqual(zB, this.shoreReferenceElevation) && this.nEqual(zC, this.shoreReferenceElevation)) {
                    ++this.nFlatTriangles;
                    this.flatAreaSum.add(area);
                } else if (zA < this.shoreReferenceElevation || zB < this.shoreReferenceElevation || zC < this.shoreReferenceElevation) {
                    this.depthAreaSum.add(area);
                    this.depthAreaWeightedSum.add(area * (this.shoreReferenceElevation - (zA + zB + zC) / 3.0));
                }
                ++this.nTriangles;
                this.areaSum.add(area);
            }
        }

        double getSurfaceArea() {
            return this.areaSum.getSum();
        }

        double getFlatArea() {
            return this.flatAreaSum.getSum();
        }

        int getFlatTriangleCount() {
            return this.nFlatTriangles;
        }

        double getMeanDepth() {
            return this.depthAreaWeightedSum.getSum() / this.depthAreaSum.getSum();
        }
    }
}

