/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.svm;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IIncrementalTinNavigator;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.PolygonConstraint;
import org.tinfour.common.Vertex;
import org.tinfour.contour.Contour;
import org.tinfour.contour.ContourBuilderForTin;
import org.tinfour.contour.ContourIntegrityCheck;
import org.tinfour.contour.ContourRegion;
import org.tinfour.gis.shapefile.ShapefileRecord;
import org.tinfour.gis.shapefile.ShapefileType;
import org.tinfour.gis.shapefile.ShapefileWriter;
import org.tinfour.gis.shapefile.ShapefileWriterSpecification;
import org.tinfour.svm.SvmBathymetryData;
import org.tinfour.svm.SvmBathymetryModel;
import org.tinfour.svm.properties.SvmProperties;
import org.tinfour.utils.AxisIntervals;
import org.tinfour.utils.SmoothingFilter;
import org.tinfour.utils.rendering.RenderingSurfaceAid;

class SvmContourGraph {
    private static final int[][] paletteB2Y = new int[][]{{0, 0, 255}, {0, 34, 255}, {0, 50, 255}, {0, 63, 255}, {0, 73, 255}, {0, 82, 255}, {0, 90, 255}, {0, 97, 255}, {0, 104, 255}, {0, 110, 255}, {0, 116, 255}, {0, 121, 255}, {0, 127, 255}, {0, 132, 255}, {0, 136, 255}, {0, 141, 255}, {0, 145, 255}, {0, 149, 255}, {0, 153, 255}, {0, 157, 255}, {0, 160, 255}, {0, 164, 255}, {0, 167, 255}, {0, 170, 255}, {0, 174, 255}, {0, 177, 255}, {0, 180, 255}, {0, 183, 255}, {0, 186, 255}, {0, 189, 255}, {0, 192, 255}, {0, 195, 249}, {0, 198, 241}, {0, 201, 233}, {0, 203, 224}, {0, 206, 216}, {0, 209, 207}, {0, 212, 199}, {0, 214, 190}, {0, 217, 181}, {0, 220, 173}, {0, 222, 164}, {0, 225, 156}, {0, 227, 147}, {0, 230, 139}, {0, 232, 131}, {0, 234, 122}, {0, 236, 114}, {0, 238, 106}, {0, 240, 98}, {0, 242, 90}, {0, 244, 82}, {0, 245, 74}, {65, 247, 67}, {94, 248, 59}, {117, 250, 51}, {136, 251, 42}, {154, 252, 34}, {170, 253, 25}, {186, 253, 15}, {200, 254, 4}, {215, 254, 0}, {228, 255, 0}, {242, 255, 0}, {255, 255, 0}};
    static final String[] targetExtensions = new String[]{"shp", "shx", "dbf", "sbn", "prj"};

    private static Color getColor(double index, double iMin, double iMax) {
        int i = (int)((double)(paletteB2Y.length - 1) * index / (iMax - iMin));
        return new Color(paletteB2Y[i][0], paletteB2Y[i][1], paletteB2Y[i][2]);
    }

    private SvmContourGraph() {
    }

    /*
     * WARNING - void declaration
     */
    static void write(PrintStream ps, SvmProperties properties, SvmBathymetryData data, double shoreReferenceElevation, IIncrementalTin tin) {
        int i;
        Path2D path;
        double s;
        double simplificationFactor;
        File output;
        boolean useDepthModel = false;
        boolean hasShorelineElevation = false;
        boolean produceElevations = false;
        if (shoreReferenceElevation > 0.0) {
            hasShorelineElevation = true;
        }
        int smoothingFactor = properties.getContourGraphSmoothingFactor(25);
        if (properties.isBathymetryModelSpecified()) {
            SvmBathymetryModel bathyModel = properties.getBathymetryModel();
            if (bathyModel.isDepth()) {
                useDepthModel = true;
                produceElevations = hasShorelineElevation;
            } else {
                useDepthModel = false;
                produceElevations = true;
            }
        }
        if ((output = properties.getContourGraphFile()) == null) {
            return;
        }
        SmoothingFilter filter = null;
        if (smoothingFactor == 0) {
            ps.println("No contour smoothing applied");
        } else {
            ps.println("Constructing smoothing filter");
            filter = new SmoothingFilter(tin, smoothingFactor);
            ps.println("Time to construct smoothing filter " + filter.getTimeToConstructFilter() + " ms");
        }
        double zMin = data.getMinZ();
        double zMax = data.getMaxZ();
        ArrayList<PolygonConstraint> boundaryConstraints = new ArrayList<PolygonConstraint>();
        List<IConstraint> allConstraints = tin.getConstraints();
        int maxIndex = 0;
        for (IConstraint iConstraint : allConstraints) {
            if (!(iConstraint instanceof PolygonConstraint)) continue;
            if (iConstraint.getConstraintIndex() > maxIndex) {
                maxIndex = iConstraint.getConstraintIndex();
            }
            boundaryConstraints.add((PolygonConstraint)iConstraint);
        }
        boolean[] water = new boolean[maxIndex + 1];
        for (PolygonConstraint p : boundaryConstraints) {
            Object o = p.getApplicationData();
            if (!(o instanceof Boolean) || !((Boolean)o).booleanValue()) continue;
            water[p.getConstraintIndex()] = true;
        }
        ps.println("\nChecking for vertices lying outside of constraints");
        IIncrementalTinNavigator iIncrementalTinNavigator = tin.getNavigator();
        long time0 = System.currentTimeMillis();
        int nOutsiders = 0;
        List<Vertex> vList = tin.getVertices();
        double[] zArray = null;
        if (filter != null) {
            filter.getVertexAdjustments();
        }
        for (Vertex v : vList) {
            double y;
            int index = v.getIndex();
            double x = v.getX();
            IQuadEdge test = iIncrementalTinNavigator.getNeighborEdge(x, y = v.getY());
            IConstraint con = tin.getRegionConstraint(test);
            if (con != null && water[con.getConstraintIndex()]) continue;
            ++nOutsiders;
            if (zArray == null || !(zArray[index] < shoreReferenceElevation)) continue;
            zArray[index] = shoreReferenceElevation;
        }
        if (zArray != null && filter != null) {
            filter.setVertexAdjustments(zArray);
        }
        long time1 = System.currentTimeMillis();
        ps.println("Found " + nOutsiders + " vertices outside constraints,check required " + (time1 - time0) + " ms");
        double[] aArray = null;
        double contourInterval = properties.getContourGraphInterval();
        if (contourInterval > 0.0) {
            long i0 = (long)Math.ceil(zMin / contourInterval);
            long i1 = (long)Math.floor(zMax / contourInterval);
            int nC = (int)(i1 - i0 + 1L);
            if (nC >= 1 && nC <= 100) {
                aArray = new double[nC];
                for (int i2 = 0; i2 < nC; ++i2) {
                    aArray[i2] = (double)((long)i2 + i0) * contourInterval;
                }
            }
        }
        AxisIntervals aIntervals = AxisIntervals.computeIntervals(zMin, zMax, 2, 1, 40, false);
        if (aArray == null) {
            aArray = aIntervals.getLabelCoordinates();
        }
        int i0 = -1;
        int i1 = 0;
        for (int i3 = 0; i3 < aArray.length; ++i3) {
            if (i0 == -1 && aArray[i3] > zMin) {
                i0 = i3;
            }
            if (!(aArray[i3] < shoreReferenceElevation)) continue;
            i1 = i3;
        }
        if (i0 == -1) {
            ps.format("Failed to construct intervals for contour plot", new Object[0]);
            return;
        }
        double[] zContour = new double[i1 - i0 + 1];
        for (int i4 = i0; i4 <= i1; ++i4) {
            zContour[i4 - i0] = aArray[i4];
        }
        double[] zBandMin = new double[zContour.length + 1];
        double[] zBandMax = new double[zContour.length + 1];
        zBandMin[0] = zContour[0] - contourInterval;
        zBandMax[0] = zContour[0];
        for (int i5 = 1; i5 < zContour.length; ++i5) {
            zBandMin[i5] = zContour[i5 - 1];
            zBandMax[i5] = zContour[i5];
        }
        zBandMin[zContour.length] = zBandMax[zContour.length - 1];
        zBandMax[zContour.length] = shoreReferenceElevation;
        if (filter == null) {
            simplificationFactor = 0.0;
        } else if (contourInterval > 0.0) {
            s = contourInterval / 8.0;
            simplificationFactor = s * s;
        } else if (zContour.length > 2) {
            s = (zContour[1] - zContour[0]) / 8.0;
            simplificationFactor = s * s;
        } else {
            simplificationFactor = 0.5;
        }
        ps.println("\nBuilding contours for graph");
        ContourBuilderForTin builder = new ContourBuilderForTin(tin, filter, zContour, true);
        builder.simplify(simplificationFactor);
        double areaFactor = properties.getUnitOfArea().getScaleFactor();
        builder.summarize(ps, areaFactor);
        ContourIntegrityCheck check = new ContourIntegrityCheck(builder);
        check.inspect();
        ps.println("Contour integrity check status: " + check.getMessage());
        Dimension dimension = properties.getContourGraphDimensions();
        int width = dimension.width;
        int height = dimension.height;
        Rectangle2D bounds = tin.getBounds();
        double x0 = bounds.getMinX();
        double y0 = bounds.getMinY();
        double x1 = bounds.getMaxX();
        double y1 = bounds.getMaxY();
        RenderingSurfaceAid rsa = new RenderingSurfaceAid(width, height, 10, x0, y0, x1, y1);
        rsa.fillBackground(Color.white);
        BufferedImage bImage = rsa.getBufferedImage();
        Graphics2D g2d = rsa.getGraphics2D();
        AffineTransform af = rsa.getCartesianToPixelTransform();
        g2d.setStroke(new BasicStroke(1.0f, 0, 2));
        int iN = zContour.length;
        Color color = SvmContourGraph.getColor(iN, 0.0, iN);
        g2d.setColor(color);
        for (PolygonConstraint polygonConstraint : boundaryConstraints) {
            if (water[polygonConstraint.getConstraintIndex()]) {
                g2d.setColor(color);
            } else {
                g2d.setColor(Color.white);
            }
            Path2D path2D = polygonConstraint.getPath2D(af);
            g2d.fill(path2D);
            g2d.draw(path2D);
        }
        List<ContourRegion> regions = builder.getRegions();
        for (ContourRegion contourRegion : regions) {
            int n = contourRegion.getRegionIndex();
            if (n >= iN) continue;
            color = SvmContourGraph.getColor(n, 0.0, iN);
            g2d.setColor(color);
            path = contourRegion.getPath2D(af);
            g2d.fill(path);
            g2d.draw(path);
        }
        g2d.setColor(Color.darkGray);
        g2d.setStroke(new BasicStroke(1.0f, 0, 2));
        List<Contour> list = builder.getContours();
        for (Contour contour : list) {
            if (contour.getContourType() != Contour.ContourType.Interior) continue;
            path = contour.getPath2D(af);
            g2d.draw(path);
        }
        g2d.setStroke(new BasicStroke(1.0f, 0, 2));
        g2d.setColor(Color.white);
        for (PolygonConstraint polygonConstraint : boundaryConstraints) {
            if (!(polygonConstraint.getArea() < 0.0)) continue;
            path = polygonConstraint.getPath2D(af);
            g2d.fill(path);
        }
        g2d.setColor(Color.black);
        g2d.setStroke(new BasicStroke(0.5f, 0, 2));
        for (IConstraint iConstraint : boundaryConstraints) {
            if (!(iConstraint instanceof PolygonConstraint)) continue;
            PolygonConstraint p = (PolygonConstraint)iConstraint;
            Path2D path3 = p.getPath2D(af);
            g2d.draw(path3);
        }
        g2d.setColor(Color.gray);
        g2d.drawRect(0, 0, width - 1, height - 1);
        BufferedImage bufferedImage = new BufferedImage(width, height + 200, 2);
        g2d = bufferedImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, width + 1, height + 200 + 1);
        g2d.drawImage((Image)bImage, 0, 0, null);
        Font font = new Font("Arial", 0, 22);
        Font legendFont = new Font("Arial", 1, 22);
        String labFmt = aIntervals.getLabelFormat();
        if (contourInterval - Math.floor(contourInterval) > 1.0E-5 && labFmt.contains(".0f")) {
            labFmt = "%3.1f";
        }
        String[] label = new String[zContour.length + 1];
        String testFmt = labFmt + " to " + labFmt;
        if (useDepthModel) {
            label[0] = String.format("Below " + labFmt, shoreReferenceElevation - zContour[0]);
            for (i = 1; i < zContour.length; ++i) {
                label[i] = String.format(testFmt, shoreReferenceElevation - zContour[i - 1], shoreReferenceElevation - zContour[i]);
            }
            label[zContour.length] = String.format("Above " + labFmt, shoreReferenceElevation - zContour[zContour.length - 1]);
        } else {
            label[0] = String.format("Below " + labFmt, zContour[0]);
            for (i = 1; i < zContour.length; ++i) {
                label[i] = String.format(testFmt, zContour[i - 1], zContour[i]);
            }
            label[zContour.length] = String.format("Above " + labFmt, zContour[zContour.length - 1]);
        }
        FontRenderContext frc = new FontRenderContext(null, true, true);
        TextLayout[] layout = new TextLayout[label.length];
        double xLabMax = 0.0;
        double yLabMax = 0.0;
        for (int i6 = 0; i6 < label.length; ++i6) {
            layout[i6] = new TextLayout(label[i6], font, frc);
            Rectangle2D r2d = layout[i6].getBounds();
            if (r2d.getMaxX() > xLabMax) {
                xLabMax = r2d.getMaxX();
            }
            if (!(r2d.getMaxY() > yLabMax)) continue;
            yLabMax = r2d.getMaxY();
        }
        if (yLabMax < 20.0) {
            yLabMax = 20.0;
        }
        double yLegend = (double)(height + 10) + yLabMax;
        g2d.setFont(legendFont);
        g2d.setColor(Color.black);
        g2d.drawString(properties.getContourGraphLegendText(), 20, (int)yLegend);
        int nCol = (label.length + 4) / 5;
        double colWidth = 35.0 + xLabMax + 30.0;
        int k = 0;
        block31: for (int iCol = 0; iCol < nCol; ++iCol) {
            double xCol = colWidth * (double)iCol + 30.0;
            for (int iRow = 0; iRow < 5; ++iRow) {
                double yRow = (double)iRow * (yLabMax + 5.0) + yLegend + yLabMax;
                color = SvmContourGraph.getColor(k, 0.0, iN);
                g2d.setColor(color);
                Rectangle2D.Double double_ = new Rectangle2D.Double(xCol, yRow, 30.0, yLabMax);
                g2d.fill(double_);
                g2d.setColor(Color.gray);
                g2d.draw(double_);
                g2d.setColor(Color.black);
                Rectangle2D rectangle2D = layout[k].getBounds();
                float xLab = (float)(xCol + 35.0);
                float yLab = (float)(yRow + yLabMax / 2.0 - rectangle2D.getY() / 2.0);
                layout[k].draw(g2d, xLab, yLab);
                if (++k == label.length) break block31;
            }
        }
        try {
            ImageIO.write((RenderedImage)bufferedImage, "PNG", output);
        }
        catch (IOException ioex) {
            ps.println("IOException writing " + output.getAbsolutePath() + ", " + ioex.getMessage());
        }
        File regionShapefileRef = properties.getContourRegionShapefile();
        File contourShapefileRef = properties.getContourLineShapefile();
        boolean appendShoreline = properties.isContourShapefileShorelineEnabled();
        if (regionShapefileRef == null || contourShapefileRef == null) {
            return;
        }
        ArrayList<Contour> shorelineContours = new ArrayList<Contour>();
        ArrayList<ContourRegion> shorelineRegions = new ArrayList<ContourRegion>();
        if (appendShoreline) {
            for (PolygonConstraint polygonConstraint : boundaryConstraints) {
                int rightIndex;
                int leftIndex;
                double pcArea = polygonConstraint.getArea();
                if (pcArea > 0.0) {
                    leftIndex = zContour.length;
                    rightIndex = zContour.length + 1;
                } else {
                    leftIndex = zContour.length;
                    rightIndex = zContour.length + 1;
                }
                double zShore = useDepthModel ? 0.0 : shoreReferenceElevation;
                Contour contour = new Contour(leftIndex, rightIndex, zShore, true);
                List<Vertex> pcvList = polygonConstraint.getVertices();
                for (Vertex v : pcvList) {
                    contour.add(v.getX(), v.getY());
                }
                contour.complete();
                ContourRegion cr = new ContourRegion(contour);
                shorelineRegions.add(cr);
                shorelineContours.add(contour);
                list.add(contour);
            }
        }
        if (regionShapefileRef != null) {
            SvmContourGraph.removeOldShapefiles(ps, regionShapefileRef);
            ps.println("Writing shapefile " + regionShapefileRef.getPath());
            if (appendShoreline) {
                SvmContourGraph.organizeNestedRegions(regions, shorelineRegions);
                regions = shorelineRegions;
            }
            int iRegion = 0;
            for (ContourRegion region : regions) {
                if (region.getContourRegionType() == ContourRegion.ContourRegionType.Perimeter) continue;
                region.setApplicationIndex(++iRegion);
            }
            ShapefileWriterSpecification shapefileWriterSpecification = new ShapefileWriterSpecification();
            shapefileWriterSpecification.setShapefileType(ShapefileType.Polygon);
            shapefileWriterSpecification.addIntegerField("feature_id", 8);
            shapefileWriterSpecification.addIntegerField("parent_id", 8);
            shapefileWriterSpecification.addIntegerField("band_idx", 4);
            shapefileWriterSpecification.addFloatingPointField("band_min", 9, 3, false);
            shapefileWriterSpecification.addFloatingPointField("band_max", 9, 3, false);
            shapefileWriterSpecification.addFloatingPointField("Shape_area", 13, 6, true);
            shapefileWriterSpecification.setShapefilePrjContent(data.getShapefilePrjContent());
            try (ShapefileWriter regionWriter = new ShapefileWriter(regionShapefileRef, shapefileWriterSpecification);){
                for (ContourRegion region : regions) {
                    int rIndex;
                    if (region.getContourRegionType() == ContourRegion.ContourRegionType.Perimeter || (rIndex = region.getRegionIndex()) > iN) continue;
                    double bandMin = zBandMin[rIndex];
                    double bandMax = zBandMax[rIndex];
                    ShapefileRecord record = regionWriter.createRecord();
                    List<ContourRegion> holes = region.getEnclosedRegions();
                    double[] xy = region.getXY();
                    record.addPolygon(xy.length / 2, xy, false);
                    for (ContourRegion hole : holes) {
                        xy = hole.getXY();
                        record.addPolygon(xy.length / 2, xy, true);
                    }
                    int parent_id = 0;
                    ContourRegion parent = region.getParent();
                    if (parent != null) {
                        parent_id = parent.getApplicationIndex();
                    }
                    regionWriter.setDbfFieldValue("feature_id", region.getApplicationIndex());
                    regionWriter.setDbfFieldValue("parent_id", parent_id);
                    regionWriter.setDbfFieldValue("band_idx", region.getRegionIndex());
                    regionWriter.setDbfFieldValue("Shape_area", region.getAdjustedArea());
                    if (useDepthModel) {
                        regionWriter.setDbfFieldValue("band_min", shoreReferenceElevation - bandMin);
                        regionWriter.setDbfFieldValue("band_max", shoreReferenceElevation - bandMax);
                    } else {
                        regionWriter.setDbfFieldValue("band_min", bandMin);
                        regionWriter.setDbfFieldValue("band_max", bandMax);
                    }
                    regionWriter.writeRecord(record);
                }
            }
            catch (IOException ioex) {
                ps.println("Encounted IOException while writing contour-region shapefile " + ioex.getMessage());
                return;
            }
        }
        if (contourShapefileRef != null) {
            SvmContourGraph.removeOldShapefiles(ps, contourShapefileRef);
            ps.println("Writing shapefile " + contourShapefileRef.getPath());
            ShapefileWriterSpecification contourSpec = new ShapefileWriterSpecification();
            contourSpec.setShapefileType(ShapefileType.PolyLine);
            contourSpec.addIntegerField("feature_id", 8);
            contourSpec.addIntegerField("cntr_idx", 4);
            contourSpec.addFloatingPointField("depth", 9, 3, false);
            if (produceElevations) {
                contourSpec.addFloatingPointField("elevation", 9, 3, false);
            }
            contourSpec.addFloatingPointField("Shape_len", 13, 6, true);
            contourSpec.addIntegerField("shore", 1);
            contourSpec.setShapefilePrjContent(data.getShapefilePrjContent());
            boolean bl = false;
            try (ShapefileWriter contourWriter = new ShapefileWriter(contourShapefileRef, contourSpec);){
                for (Contour contour : list) {
                    double zElevation;
                    double zDepth;
                    void var87_114;
                    if (contour.isBoundary()) continue;
                    int shoreCode = 0;
                    if (shorelineContours.contains(contour)) {
                        shoreCode = 1;
                    }
                    ++var87_114;
                    int cIndex = contour.getLeftIndex();
                    double z = contour.getZ();
                    ShapefileRecord record = contourWriter.createRecord();
                    double[] xy = contour.getXY();
                    record.addPolyLine(xy.length / 2, xy);
                    double dSum = 0.0;
                    for (int i7 = 1; i7 < xy.length / 2; ++i7) {
                        double dx = xy[i7 * 2] - xy[i7 * 2 - 2];
                        double dy = xy[i7 * 2 + 1] - xy[i7 * 2 - 1];
                        dSum += Math.sqrt(dx * dx + dy * dy);
                    }
                    if (useDepthModel) {
                        zDepth = Math.abs(z);
                        zElevation = shoreReferenceElevation + z;
                    } else {
                        zDepth = shoreReferenceElevation - z;
                        zElevation = z;
                    }
                    contourWriter.setDbfFieldValue("feature_id", (int)var87_114);
                    contourWriter.setDbfFieldValue("cntr_idx", cIndex);
                    contourWriter.setDbfFieldValue("depth", zDepth);
                    if (produceElevations) {
                        contourWriter.setDbfFieldValue("elevation", zElevation);
                    }
                    contourWriter.setDbfFieldValue("Shape_len", dSum);
                    contourWriter.setDbfFieldValue("shore", shoreCode);
                    contourWriter.writeRecord(record);
                }
            }
            catch (IOException ioex) {
                ps.println("Encounted IOException while writing contour-line shapefile " + ioex.getMessage());
                return;
            }
        }
    }

    static void removeOldShapefiles(PrintStream ps, File shapefile) {
        String ext = SvmContourGraph.getFileExtension(shapefile);
        if (!"shp".equalsIgnoreCase(ext)) {
            return;
        }
        File parent = shapefile.getParentFile();
        if (parent == null) {
            parent = new File(".");
        }
        Object name = shapefile.getName();
        String basename = ((String)name).substring(0, ((String)name).length() - 4);
        for (String s : targetExtensions) {
            name = basename + "." + SvmContourGraph.matchCase(ext, s);
            File target = new File(parent, (String)name);
            if (!target.exists()) continue;
            target.delete();
        }
    }

    private static String getFileExtension(File file) {
        String name;
        int i;
        if (file != null && (i = (name = file.getName()).lastIndexOf(46)) > 0 && i < name.length() - 1) {
            return name.substring(i + 1, name.length());
        }
        return null;
    }

    private static String matchCase(String source, String target) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (i = 0; i < target.length(); ++i) {
            char s = i < source.length() ? source.charAt(i) : source.charAt(source.length() - 1);
            char t = target.charAt(i);
            if (Character.isLowerCase(s) && Character.isUpperCase(t)) {
                t = Character.toLowerCase(t);
            } else if (Character.isUpperCase(s) && Character.isLowerCase(t)) {
                t = Character.toUpperCase(t);
            }
            sb.append(t);
        }
        return sb.toString();
    }

    private static void organizeNestedRegions(List<ContourRegion> regions, List<ContourRegion> regionList) {
        for (ContourRegion region : regions) {
            if (region.getContourRegionType() == ContourRegion.ContourRegionType.Perimeter) {
                region.removeChildren();
                continue;
            }
            regionList.add(region);
        }
        int nRegion = regionList.size();
        if (nRegion < 2) {
            return;
        }
        Collections.sort(regionList, (o1, o2) -> Double.compare(o2.getAbsArea(), o1.getAbsArea()));
        int iRegion = 0;
        for (ContourRegion region : regionList) {
            region.setApplicationIndex(++iRegion);
        }
        for (int i = 0; i < nRegion - 1; ++i) {
            ContourRegion rI = regionList.get(i);
            if (rI.hasChildren()) continue;
            double[] xy = rI.getXY();
            for (int j = i + 1; j < nRegion; ++j) {
                Point2D testPoint;
                ContourRegion rJ = regionList.get(j);
                if (rJ.getParent() != null || !rI.isPointInsideRegion(xy, (testPoint = rJ.getTestPoint()).getX(), testPoint.getY())) continue;
                rI.addChild(rJ);
            }
        }
    }
}

