/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.svm;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.imageio.ImageIO;
import org.tinfour.svm.SvmBathymetryModel;
import org.tinfour.svm.SvmTriangleVolumeTabulator;
import org.tinfour.svm.properties.SvmProperties;
import org.tinfour.svm.properties.SvmUnitSpecification;
import org.tinfour.utils.AxisIntervals;

class SvmDrawdownGraph {
    private final SvmProperties properties;
    private final List<SvmTriangleVolumeTabulator.AreaVolumeSum> resultList;
    private final double totalVolume;
    private final double levelMin;
    private final double levelMax;
    private final double levelOffset;
    private final SvmUnitSpecification unitOfVolume;
    private final SvmUnitSpecification unitOfLength;
    private static final int defaultImageHeightInPixels = 400;
    private static final double defaultImageHeightInPoints = 300.0;
    private static final double defaultFontSizeTitle = 14.0;
    private static final double defaultFontSizeAxis = 12.0;
    private static final double fLeft = 0.1;
    private static final double fTop = 0.125;
    private static final double fRight = 0.9;
    private static final double fBottom = 0.875;
    static final Color lineColor = Color.gray;
    static final Color labColor = Color.black;

    private double computeFontSize(double dSize, double dHeight) {
        double f = dSize / 300.0;
        double dHeightInPoints = dHeight * 72.0 / 96.0;
        double fSize = f * dHeightInPoints;
        if (fSize < 1.0) {
            fSize = 1.0;
        }
        return fSize;
    }

    SvmDrawdownGraph(SvmProperties properties, List<SvmTriangleVolumeTabulator.AreaVolumeSum> sourceResultList, double totalVolume) {
        ArrayList<SvmTriangleVolumeTabulator.AreaVolumeSum> resultList = new ArrayList<SvmTriangleVolumeTabulator.AreaVolumeSum>();
        resultList.addAll(sourceResultList);
        Collections.sort(resultList, new Comparator<SvmTriangleVolumeTabulator.AreaVolumeSum>(){

            @Override
            public int compare(SvmTriangleVolumeTabulator.AreaVolumeSum o1, SvmTriangleVolumeTabulator.AreaVolumeSum o2) {
                return Double.compare(o1.level, o2.level);
            }
        });
        this.properties = properties;
        this.resultList = resultList;
        this.totalVolume = totalVolume;
        double zMin = ((SvmTriangleVolumeTabulator.AreaVolumeSum)resultList.get((int)0)).level;
        double zMax = ((SvmTriangleVolumeTabulator.AreaVolumeSum)resultList.get((int)(resultList.size() - 1))).level;
        if (zMin > zMax) {
            double swap = zMin;
            zMin = zMax;
            zMax = swap;
        }
        this.levelMin = zMin;
        this.levelMax = zMax;
        this.unitOfVolume = properties.getUnitOfVolume();
        this.unitOfLength = properties.getUnitOfDistance();
        SvmBathymetryModel model = properties.getBathymetryModel();
        this.levelOffset = model == SvmBathymetryModel.Depth ? properties.getShorelineReferenceElevation() : 0.0;
    }

    boolean writeOutput() throws IOException {
        int i;
        double y;
        int i2;
        double yLabel;
        double xLabel;
        File outputFile = this.properties.getDrawdownGraphFile();
        if (outputFile == null) {
            return false;
        }
        Dimension dimension = this.properties.getDrawdownGraphDimensions();
        String title = this.properties.getDrawdownGraphTitle();
        int width = dimension.width;
        int height = dimension.height;
        BufferedImage bImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = bImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, width, height);
        g2d.setColor(lineColor);
        g2d.drawRect(0, 0, width - 1, height - 1);
        double wInPixels = dimension.getWidth();
        double hInPixels = dimension.getHeight();
        double mInPixels = Math.min(wInPixels, hInPixels);
        double titleFontSize = this.computeFontSize(14.0, mInPixels);
        double axisFontSize = this.computeFontSize(12.0, mInPixels);
        Font titleFont = new Font("SansSerif", 1, (int)titleFontSize);
        Font axisFont = new Font("SansSerif", 0, (int)axisFontSize);
        FontRenderContext frc = new FontRenderContext(null, true, true);
        TextLayout testLayout = new TextLayout("00000", axisFont, frc);
        Rectangle2D fontR2D = testLayout.getBounds();
        double axisFontHeight = fontR2D.getHeight();
        double axisFontWidth = fontR2D.getWidth();
        int yFontAllowance = (int)(axisFontHeight * 1.4);
        int xFontAllowance = (int)(axisFontWidth * 1.3);
        AffineTransform af = AffineTransform.getQuadrantRotateInstance(3);
        Font axisFontRotated = axisFont.deriveFont(af);
        double volumeUnitsAdjustment = this.unitOfVolume.getScaleFactor();
        double gLeft = wInPixels * 0.1;
        double gRight = wInPixels * 0.9;
        double gTop = hInPixels * 0.125;
        double gBottom = hInPixels * 0.875;
        double gdx = gRight - gLeft;
        double gdy = gBottom - gTop;
        TextLayout titleLayout = null;
        Rectangle2D titleR2D = null;
        if (title != null && !title.isBlank()) {
            AttributedString aTitle = new AttributedString(title);
            aTitle.addAttribute(TextAttribute.FONT, titleFont);
            aTitle.addAttribute(TextAttribute.KERNING, TextAttribute.KERNING_ON);
            titleLayout = new TextLayout(aTitle.getIterator(), frc);
            titleR2D = titleLayout.getBounds();
            gdy = gBottom - (gTop += (double)((int)titleR2D.getHeight() + 10));
        }
        double cHead = 110.0;
        AxisIntervals cIntervals = AxisIntervals.computeIntervals(0.0, cHead, yFontAllowance, yFontAllowance / 2, (int)gdy, true);
        double cUnitsPerPixel = cIntervals.getUnitsPerPixel();
        double[] cCoords = cIntervals.getLabelCoordinates();
        String[] cLabels = cIntervals.getLabels();
        double cDeltaPix = cHead / cUnitsPerPixel;
        double cDeltaPix100 = 100.0 / cUnitsPerPixel;
        double vWithScale = this.totalVolume / volumeUnitsAdjustment;
        double vUnitsPerPixel = vWithScale / cDeltaPix100;
        AxisIntervals vIntervals = AxisIntervals.computeIntervals(0.0, vWithScale * (cHead / 100.0), yFontAllowance, yFontAllowance / 2, (int)gdy, false);
        double[] vCoords = vIntervals.getLabelCoordinates();
        String[] vLabels = vIntervals.getLabels();
        AxisIntervals xIntervals = AxisIntervals.computeIntervals(this.levelMin + this.levelOffset, this.levelMax + this.levelOffset, xFontAllowance, xFontAllowance / 2, (int)(gdx - axisFontHeight * 2.0), true);
        double xUnitsPerPixel = xIntervals.getUnitsPerPixel();
        double[] xCoords = xIntervals.getLabelCoordinates();
        String[] xLabels = xIntervals.getLabels();
        double xDelta = xCoords[xCoords.length - 1] - xCoords[0];
        double xDeltaPix = xDelta / xUnitsPerPixel;
        AxisIntervals dIntervals = AxisIntervals.computeIntervals(this.levelMin - this.levelMax, 0.0, xFontAllowance, xFontAllowance / 2, (int)(gdx - axisFontHeight * 2.0), false);
        double[] dCoords = dIntervals.getLabelCoordinates();
        String[] dLabels = dIntervals.getLabels();
        testLayout = new TextLayout("100", axisFont, frc);
        fontR2D = testLayout.getBounds();
        double cWidth = fontR2D.getWidth();
        double vWidth = 0.0;
        for (int i3 = 0; i3 < vLabels.length; ++i3) {
            testLayout = new TextLayout(vLabels[i3], axisFont, frc);
            fontR2D = testLayout.getBounds();
            if (!(fontR2D.getWidth() > vWidth)) continue;
            vWidth = fontR2D.getWidth();
        }
        double x0 = wInPixels / 2.0 - xDeltaPix / 2.0 + (cWidth - vWidth);
        double x1 = x0 + xDeltaPix;
        double y0 = gTop;
        double y1 = gTop + cDeltaPix;
        g2d.setColor(lineColor);
        g2d.setStroke(new BasicStroke(1.0f));
        if (titleLayout != null) {
            xLabel = (x0 + x1) / 2.0 - titleR2D.getCenterX();
            yLabel = -titleR2D.getY() + titleR2D.getHeight();
            g2d.setColor(labColor);
            titleLayout.draw(g2d, (float)xLabel, (float)yLabel);
            g2d.setColor(lineColor);
        }
        Rectangle2D.Double graphRect = new Rectangle2D.Double(x0, y0, xDeltaPix, cDeltaPix);
        g2d.draw(graphRect);
        Line2D.Double l2d = new Line2D.Double();
        double yBoxTop = Double.POSITIVE_INFINITY;
        double xLabelMin = Double.POSITIVE_INFINITY;
        for (int i4 = 0; i4 < cCoords.length; ++i4) {
            double y2 = y1 - cCoords[i4] / cUnitsPerPixel;
            ((Line2D)l2d).setLine(x0 - 5.0, y2, x0, y2);
            g2d.draw(l2d);
            TextLayout tLayout = new TextLayout(cLabels[i4], axisFont, frc);
            Rectangle2D r2d = tLayout.getBounds();
            yLabel = y2 - r2d.getCenterY();
            xLabel = x0 - r2d.getMaxX() - 10.0;
            g2d.setColor(labColor);
            tLayout.draw(g2d, (float)xLabel, (float)yLabel);
            g2d.setColor(lineColor);
            yBoxTop = y2;
            if (!(xLabel < xLabelMin)) continue;
            xLabelMin = xLabel;
        }
        String cLabel = "Estimated Capacity (percent)";
        TextLayout cLayout = new TextLayout(cLabel, axisFontRotated, frc);
        Rectangle2D cr2d = cLayout.getBounds();
        xLabel = xLabelMin + cr2d.getWidth() - axisFontHeight * 2.0;
        yLabel = (y0 + y1) / 2.0 - cr2d.getCenterY();
        g2d.setColor(labColor);
        cLayout.draw(g2d, (float)xLabel, (float)yLabel);
        g2d.setColor(lineColor);
        double vMaxTextX = 0.0;
        for (i2 = 0; i2 < vCoords.length; ++i2) {
            vLabels[i2] = vLabels[i2].trim();
            TextLayout tLayout = new TextLayout(vLabels[i2], axisFont, frc);
            Rectangle2D r2d = tLayout.getBounds();
            if (!(r2d.getMaxX() > vMaxTextX)) continue;
            vMaxTextX = r2d.getWidth();
        }
        for (i2 = 0; i2 < vCoords.length && !((y = y1 - vCoords[i2] / vUnitsPerPixel) < yBoxTop); ++i2) {
            ((Line2D)l2d).setLine(x0, y, x1 + 5.0, y);
            g2d.draw(l2d);
            TextLayout tLayout = new TextLayout(vLabels[i2], axisFont, frc);
            Rectangle2D r2d = tLayout.getBounds();
            yLabel = y - r2d.getCenterY();
            xLabel = x1 + 10.0 + vMaxTextX - r2d.getWidth();
            g2d.setColor(labColor);
            tLayout.draw(g2d, (float)xLabel, (float)yLabel);
            g2d.setColor(lineColor);
        }
        String vLabel = "Computed Volume (" + this.unitOfVolume.getLabel() + ")";
        TextLayout vLayout = new TextLayout(vLabel, axisFontRotated, frc);
        Rectangle2D vr2d = vLayout.getBounds();
        xLabel = x1 + 10.0 + vMaxTextX - vr2d.getX() + axisFontHeight * 2.0;
        yLabel = (y0 + y1) / 2.0 - vr2d.getCenterY();
        g2d.setColor(labColor);
        vLayout.draw(g2d, (float)xLabel, (float)yLabel);
        g2d.setColor(lineColor);
        yLabel = y1 + axisFontHeight * 2.0;
        for (i = 0; i < xCoords.length; ++i) {
            double x = x1 - (xCoords[i] - xCoords[0]) / xUnitsPerPixel;
            l2d = new Line2D.Double(x, y0, x, y1 + 5.0);
            g2d.draw(l2d);
            TextLayout tLayout = new TextLayout(xLabels[i], axisFont, frc);
            Rectangle2D r2d = tLayout.getBounds();
            xLabel = x - r2d.getCenterX();
            g2d.setColor(labColor);
            tLayout.draw(g2d, (float)xLabel, (float)yLabel);
            g2d.setColor(lineColor);
        }
        yLabel = y0 - 7.0;
        for (i = 0; i < dLabels.length; ++i) {
            double level = this.levelMax + this.levelOffset + dCoords[i];
            double x = x1 - (level - xCoords[0]) / xUnitsPerPixel;
            l2d = new Line2D.Double(x, y0, x, y0 - 5.0);
            g2d.draw(l2d);
            TextLayout tLayout = new TextLayout(dLabels[i], axisFont, frc);
            Rectangle2D r2d = tLayout.getBounds();
            xLabel = x - r2d.getCenterX();
            g2d.setColor(labColor);
            tLayout.draw(g2d, (float)xLabel, (float)yLabel);
            g2d.setColor(lineColor);
        }
        String aLabel = "Surface Elevation (" + this.unitOfLength.getLabel() + ")";
        TextLayout aLayout = new TextLayout(aLabel, axisFont, frc);
        Rectangle2D ar2d = aLayout.getBounds();
        xLabel = (x0 + x1) / 2.0 - ar2d.getCenterX();
        yLabel = y1 + axisFontHeight * 4.0 - ar2d.getX();
        g2d.setColor(labColor);
        aLayout.draw(g2d, (float)xLabel, (float)yLabel);
        g2d.setColor(lineColor);
        String bLabel = "Water level change (" + this.unitOfLength.getLabel() + ")";
        TextLayout bLayout = new TextLayout(bLabel, axisFont, frc);
        Rectangle2D br2d = bLayout.getBounds();
        xLabel = (x0 + x1) / 2.0 - br2d.getCenterX();
        yLabel = y0 - 7.0 - axisFontHeight * 2.0;
        g2d.setColor(labColor);
        bLayout.draw(g2d, (float)xLabel, (float)yLabel);
        g2d.setColor(lineColor);
        g2d.setClip(graphRect);
        float lineWeight = 2.0f;
        if (width > 1000) {
            lineWeight = 4.0f;
        }
        g2d.setColor(Color.BLUE);
        g2d.setStroke(new BasicStroke(lineWeight, 0, 1));
        Path2D.Double path = new Path2D.Double();
        boolean moveFlag = true;
        for (SvmTriangleVolumeTabulator.AreaVolumeSum avr : this.resultList) {
            double level = avr.level + this.levelOffset;
            double percent = 100.0 * avr.getVolume() / this.totalVolume;
            double x = x1 - (level - xCoords[0]) / xUnitsPerPixel;
            double y3 = y1 - percent / cUnitsPerPixel;
            if (moveFlag) {
                moveFlag = false;
                ((Path2D)path).moveTo(x, y3);
                continue;
            }
            ((Path2D)path).lineTo(x, y3);
        }
        List<Point2D> eList = this.extrapolate();
        for (Point2D p2d : eList) {
            double level = p2d.getX() + this.levelOffset;
            double percent = p2d.getY();
            double x = x1 - (level - xCoords[0]) / xUnitsPerPixel;
            double y4 = y1 - percent / cUnitsPerPixel;
            ((Path2D)path).lineTo(x, y4);
        }
        g2d.draw(path);
        g2d.setClip(null);
        ImageIO.write((RenderedImage)bImage, "PNG", outputFile);
        return false;
    }

    private List<Point2D> extrapolate() {
        double s4 = 0.0;
        double s3 = 0.0;
        double s2 = 0.0;
        double p1 = 0.0;
        double p2 = 0.0;
        for (SvmTriangleVolumeTabulator.AreaVolumeSum avr : this.resultList) {
            double x = avr.level - this.levelMax;
            double y = avr.getVolume() / this.totalVolume - 1.0;
            double x2 = x * x;
            s2 += x2;
            s3 += x2 * x;
            s4 += x2 * x2;
            p1 += x * y;
            p2 += x2 * y;
        }
        double det = s4 * s2 - s3 * s3;
        double a = (s2 * p2 - s3 * p1) / det;
        double b = (s4 * p1 - s3 * p2) / det;
        ArrayList<Point2D> eList = new ArrayList<Point2D>();
        for (int i = 0; i < 100; ++i) {
            double x = (double)i / 2.0;
            double y = a * x * x + b * x;
            double level = x + this.levelMax;
            double capacity = (y + 1.0) * 100.0;
            eList.add(new Point2D.Double(level, capacity));
            if (capacity >= 110.0) break;
        }
        return eList;
    }
}

