/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.svm;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.tinfour.common.GeometricOperations;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Thresholds;
import org.tinfour.common.Vertex;

class SvmFlatFixer {
    private final IIncrementalTin tin;
    private final double zShore;
    private int nFlats;
    private int nRemediations;
    private double remediatedArea;
    private double remediatedVolume;

    private boolean isEquiv(double a, double b) {
        return Math.abs(a - b) < 1.0E-6;
    }

    SvmFlatFixer(IIncrementalTin tin, double zShore) {
        this.tin = tin;
        this.zShore = zShore;
    }

    List<Vertex> fixFlats(PrintStream ps) {
        Vertex D;
        Vertex C;
        int index;
        Thresholds thresholds = this.tin.getThresholds();
        GeometricOperations geoOp = new GeometricOperations(thresholds);
        ArrayList<IQuadEdge> fixList = new ArrayList<IQuadEdge>();
        int iMax = this.tin.getMaximumEdgeAllocationIndex();
        BitSet visited = new BitSet(iMax);
        List<IQuadEdge> perimeter = this.tin.getPerimeter();
        for (IQuadEdge edge : perimeter) {
            index = edge.getIndex();
            visited.set(index);
            visited.set(index ^ 1);
        }
        for (IQuadEdge edge : this.tin.edges()) {
            index = edge.getIndex();
            if (visited.get(index)) continue;
            visited.set(index);
            visited.set(index ^ 1);
            if (edge.isConstrained()) continue;
            Vertex A = edge.getA();
            Vertex B = edge.getB();
            if (!this.isEquiv(A.getZ(), this.zShore) || !this.isEquiv(B.getZ(), this.zShore)) continue;
            IQuadEdge dual = edge.getDual();
            C = edge.getForward().getB();
            D = dual.getForward().getB();
            if (C == null || D == null) continue;
            if (this.isEquiv(C.getZ(), this.zShore)) {
                ++this.nFlats;
                if (this.isEquiv(D.getZ(), this.zShore)) continue;
                fixList.add(edge);
                continue;
            }
            if (!this.isEquiv(D.getZ(), this.zShore)) continue;
            ++this.nFlats;
            fixList.add(dual);
        }
        ArrayList<Vertex> fixVertices = new ArrayList<Vertex>(fixList.size());
        for (IQuadEdge edge : fixList) {
            double mZ;
            IQuadEdge dual = edge.getDual();
            Vertex A = edge.getA();
            Vertex B = edge.getB();
            C = edge.getForward().getB();
            D = dual.getForward().getB();
            double area = geoOp.area(A, B, C);
            if (area < 1.0) continue;
            double mX = (A.getX() + B.getX()) / 2.0;
            double mY = (A.getY() + B.getY()) / 2.0;
            ++this.nRemediations;
            double sC = C.getDistance(mX, mY);
            double sD = D.getDistance(mX, mY);
            if (D.getAuxiliaryIndex() == 3) {
                mZ = D.getZ();
            } else {
                mZ = (sC * D.getZ() + sD * C.getZ()) / (sC + sD);
                if (mZ > this.zShore - 1.0) {
                    mZ = this.zShore - 1.0;
                }
            }
            Vertex M = this.tin.splitEdge(edge, mZ, false);
            M.setSynthetic(true);
            M.setAuxiliaryIndex(3);
            fixVertices.add(M);
            double meanDepth = (this.zShore - mZ) / 3.0;
            double volume = area * meanDepth;
            this.remediatedArea += area;
            this.remediatedVolume += volume;
        }
        return fixVertices;
    }

    int getFlatCount() {
        return this.nFlats;
    }

    int getRemediationCount() {
        return this.nRemediations;
    }

    double getRemediatedArea() {
        return this.remediatedArea;
    }

    double getRemediatedVolume() {
        return this.remediatedVolume;
    }
}

