/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.svm;

import org.tinfour.gis.las.ILasRecordFilter;
import org.tinfour.gis.las.LasPoint;

public class SvmLasFilter
implements ILasRecordFilter {
    boolean allRecordsAccepted;
    boolean filterFirst;
    boolean filterLast;
    boolean[] cFlag = new boolean[256];

    public SvmLasFilter() {
        this.allRecordsAccepted = true;
    }

    public SvmLasFilter(String specification) {
        if (specification == null || specification.isBlank()) {
            this.allRecordsAccepted = true;
            return;
        }
        String[] a = specification.split(",");
        for (int i = 0; i < a.length; ++i) {
            String s = a[i].trim();
            if ("z".equalsIgnoreCase(s)) {
                this.allRecordsAccepted = true;
                continue;
            }
            if ("first".equalsIgnoreCase(s)) {
                this.filterFirst = true;
                continue;
            }
            if ("last".equalsIgnoreCase(s)) {
                this.filterLast = true;
                continue;
            }
            if (s.indexOf(45) > 0) {
                String[] b = s.split("-");
                int x0 = this.parseClassification(b[0]);
                int x1 = this.parseClassification(b[1]);
                if (x1 < x0) {
                    throw new IllegalArgumentException("Out-of-order entry for LAZ/LAS classification range: " + s);
                }
                for (int x = x0; x <= x1; ++x) {
                    this.cFlag[x] = true;
                }
                continue;
            }
            int x = this.parseClassification(s);
            this.cFlag[x] = true;
        }
    }

    private int parseClassification(String sClassification) {
        if (sClassification == null || sClassification.isBlank()) {
            throw new IllegalArgumentException("Blank entry for LAZ/LAS classification");
        }
        String s = sClassification.trim();
        try {
            int x = Integer.parseInt(s);
            if (x < 0 || x > 255) {
                throw new IllegalArgumentException("LAZ/LAZ classification out-of-range [0..255]: " + s);
            }
            return x;
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid numeric specification where LAS/LAZ classification expected: " + s);
        }
    }

    @Override
    public boolean accept(LasPoint record) {
        if (this.allRecordsAccepted) {
            return record.withheld ^ true;
        }
        if (this.filterFirst && record.returnNumber == 1) {
            return record.withheld ^ true;
        }
        if (this.filterLast && record.returnNumber == record.numberOfReturns) {
            return record.withheld ^ true;
        }
        if (this.cFlag[record.classification & 0xFF]) {
            return record.withheld ^ true;
        }
        return false;
    }

    public boolean areAllRecordsAccepted() {
        return this.allRecordsAccepted;
    }
}

