/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.svm;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.imaging.ImageWriteException;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IIncrementalTinNavigator;
import org.tinfour.common.IQuadEdge;
import org.tinfour.gis.geotiff.GeoKey;
import org.tinfour.gis.geotiff.GeoTiffTableBuilder;
import org.tinfour.gis.geotiff.GtModelType;
import org.tinfour.interpolation.NaturalNeighborInterpolator;
import org.tinfour.svm.SvmBathymetryData;
import org.tinfour.svm.SvmBathymetryModel;
import org.tinfour.svm.SvmMain;
import org.tinfour.svm.properties.SvmProperties;
import org.tinfour.svm.properties.SvmUnitSpecification;
import org.tinfour.utils.KahanSummation;

class SvmRasterGeoTiff {
    SvmRasterGeoTiff() {
    }

    void buildAndWriteRaster(SvmProperties properties, SvmBathymetryData data, PrintStream ps, IIncrementalTin tin, boolean[] water, double shoreReferenceElevation) {
        File geoTiffParent;
        String ext;
        File geoTiffFile = properties.getGeoTiffFile();
        double s = properties.getGridCellSize();
        if (geoTiffFile == null || Double.isNaN(s)) {
            return;
        }
        String geoTiffFileRootName = geoTiffFile.getName();
        int kTemp = geoTiffFileRootName.lastIndexOf(46);
        if (kTemp > 0 && (".tif".equalsIgnoreCase(ext = geoTiffFileRootName.substring(kTemp)) || ".tiff".equalsIgnoreCase(ext))) {
            geoTiffFileRootName = geoTiffFileRootName.substring(0, kTemp);
        }
        if ((geoTiffParent = geoTiffFile.getParentFile()) == null) {
            geoTiffParent = new File(".");
        }
        boolean useDepthModel = false;
        if (properties.isBathymetryModelSpecified()) {
            SvmBathymetryModel bathyModel = properties.getBathymetryModel();
            useDepthModel = bathyModel.isDepth();
        }
        float noDataValue = -1000000.0f;
        String gdalNoDataString = "-1000000";
        if (properties.isGeoTiffNoDataCodeSpecified()) {
            noDataValue = properties.getGeoTiffNoDataCode();
            gdalNoDataString = noDataValue == (float)((int)noDataValue) ? String.format("%d", (int)noDataValue) : String.format("%f", Float.valueOf(noDataValue));
        }
        boolean dataCompressionEnabled = properties.isGeoTiffDataCompressionEnabled();
        ps.println("");
        ps.format("Processing GeoTiff data%n", new Object[0]);
        ps.format("  GDAL no-data code:  %s%n", gdalNoDataString);
        ps.format("  Data Compression:   %s%n", Boolean.toString(dataCompressionEnabled));
        boolean status = this.writeAuxiliaryFiles(ps, data, geoTiffFile, "SvmRasterTemplate.aux.xml");
        if (!status) {
            return;
        }
        KahanSummation sum = new KahanSummation();
        Rectangle2D bounds = tin.getBounds();
        double xMin = bounds.getMinX();
        double yMin = bounds.getMinY();
        double xMax = bounds.getMaxX();
        double yMax = bounds.getMaxY();
        long jMin = (long)Math.floor(xMin / s);
        long iMin = (long)Math.floor(yMin / s);
        long jMax = (long)Math.ceil(xMax / s);
        long iMax = (long)Math.ceil(yMax / s);
        int nRows = (int)(iMax - iMin) + 1;
        int nCols = (int)(jMax - jMin) + 1;
        xMin = (double)jMin * s;
        xMax = (double)jMax * s;
        yMin = (double)iMin * s;
        yMax = (double)iMax * s;
        long nCells = nRows * nCols;
        ps.format("  N Rows:    %8d%n", nRows);
        ps.format("  N Columns: %8d%n", nCols);
        ps.format("  Cell size: %8.3f%n", s);
        ps.println("");
        int tileSize = 256;
        int nRowsOfTiles = (nRows + tileSize - 1) / tileSize;
        int nColsOfTiles = (nCols + tileSize - 1) / tileSize;
        long rowWaste = (long)nRowsOfTiles * (long)tileSize - (long)nRows;
        long colWaste = (long)nColsOfTiles * (long)tileSize - (long)nCols;
        long totalWaste = rowWaste * colWaste;
        double wasteRatio = (double)totalWaste / (double)nCells;
        if (wasteRatio > 0.125) {
            nRowsOfTiles = (nRows + (tileSize /= 2) - 1) / tileSize;
            nColsOfTiles = (nCols + tileSize - 1) / tileSize;
            rowWaste = nRowsOfTiles * tileSize - nRows;
            colWaste = nColsOfTiles * tileSize - nCols;
            totalWaste = rowWaste * colWaste;
        }
        int nTiles = nRowsOfTiles * nColsOfTiles;
        int nCellsInTile = tileSize * tileSize;
        byte[][] tiles = new byte[nTiles][];
        double zMin = Double.POSITIVE_INFINITY;
        double zMax = Double.NEGATIVE_INFINITY;
        long time0 = System.nanoTime();
        int nCovered = 0;
        int nUncovered = 0;
        IIncrementalTinNavigator navigator = tin.getNavigator();
        NaturalNeighborInterpolator nni = new NaturalNeighborInterpolator(tin);
        GeoTiffTableBuilder gkTab = new GeoTiffTableBuilder();
        gkTab.setCompressionEnabled(dataCompressionEnabled);
        for (int iTileRow = 0; iTileRow < nRowsOfTiles; ++iTileRow) {
            int row0 = iTileRow * tileSize;
            int row1 = row0 + tileSize;
            if (row1 > nRows) {
                row1 = nRows;
            }
            for (int iTileCol = 0; iTileCol < nColsOfTiles; ++iTileCol) {
                int col0 = iTileCol * tileSize;
                int col1 = col0 + tileSize;
                if (col1 > nCols) {
                    col1 = nCols;
                }
                float[] f = new float[nCellsInTile];
                Arrays.fill(f, noDataValue);
                for (int iRow = row0; iRow < row1; ++iRow) {
                    double y = yMax - (double)iRow * s;
                    int fOffset = (iRow - row0) * tileSize;
                    for (int iCol = col0; iCol < col1; ++iCol) {
                        float zValue;
                        double x = xMin + (double)iCol * s;
                        IQuadEdge edge = navigator.getNeighborEdge(x, y);
                        IConstraint con = tin.getRegionConstraint(edge);
                        if (con == null || !water[con.getConstraintIndex()]) {
                            zValue = noDataValue;
                            ++nUncovered;
                        } else {
                            double z = nni.interpolate(x, y, null);
                            if (Double.isFinite(z)) {
                                zValue = useDepthModel ? (z > 0.0 ? 0.0f : (float)z) : (float)z;
                                ++nCovered;
                                sum.add(-zValue);
                                if ((double)zValue < zMin) {
                                    zMin = zValue;
                                }
                                if ((double)zValue > zMax) {
                                    zMax = zValue;
                                }
                            } else {
                                ++nUncovered;
                                zValue = noDataValue;
                            }
                        }
                        f[fOffset + iCol - col0] = zValue;
                    }
                }
                int iTile = iTileRow * nColsOfTiles + iTileCol;
                tiles[iTile] = gkTab.encodeBlock(f, tileSize, tileSize);
            }
        }
        ps.format("Covered cells %5.1f%%%n", 100.0 * (double)nCovered / (double)(nCovered + nUncovered));
        if (!properties.isGeoTiffProjectionCodeSpecified()) {
            ps.println("\nWarning: no projection code was specified for GeoTIFF\n");
        }
        int projectionCode = properties.getGeoTiffProjectionCode();
        int unitOfMeasureCode = 9001;
        SvmUnitSpecification unitOfDistance = properties.getUnitOfDistance();
        String uLab = unitOfDistance.getLabel().toLowerCase();
        if ("ft".equalsIgnoreCase(uLab)) {
            unitOfMeasureCode = 9002;
        } else if (uLab.startsWith("y")) {
            unitOfMeasureCode = 9012;
        }
        try {
            gkTab.addGeoKey(GeoKey.GTModelTypeGeoKey, GtModelType.ProjectedCoordinateSystem.getCode());
            gkTab.addGeoKey(GeoKey.GTRasterTypeGeoKey, 1);
            gkTab.addGeoKey(GeoKey.ProjectedCRSGeoKey, projectionCode);
            gkTab.addGeoKey(GeoKey.ProjLinearUnitsGeoKey, unitOfMeasureCode);
            gkTab.addGeoKey(GeoKey.GeogAngularUnitsGeoKey, 9102);
            gkTab.addGeoKey(GeoKey.GTCitationGeoKey, "SVM Test Output");
            double[] a = new double[]{s, 0.0, 0.0, s, xMin, yMax};
            AffineTransform af = new AffineTransform(a);
            gkTab.setPixelToModelTransform(af);
            gkTab.setGdalNoData(gdalNoDataString);
            gkTab.writeTiles(geoTiffFile, nCols, nRows, tileSize, tiles);
        }
        catch (IOException | ImageWriteException ex) {
            ps.println("IOException writing GeoTIFF file " + ex.getMessage());
        }
        long time1 = System.nanoTime();
        ps.format("Time to Process GeoTiff  %3.1f seconds %n", (double)(time1 - time0) / 1.0E9);
    }

    boolean testWater(IQuadEdge edge, boolean[] water) {
        if (edge.isConstrainedRegionInterior()) {
            int index = edge.getConstraintIndex();
            return water[index];
        }
        IQuadEdge fwd = edge.getForward();
        if (fwd.isConstrainedRegionInterior()) {
            int index = fwd.getConstraintIndex();
            return water[index];
        }
        IQuadEdge rev = edge.getReverse();
        if (rev.isConstrainedRegionInterior()) {
            int index = rev.getConstraintIndex();
            return water[index];
        }
        return false;
    }

    private boolean writeAuxiliaryFiles(PrintStream ps, SvmBathymetryData data, File file, String target) {
        BufferedOutputStream bos;
        FileOutputStream fos;
        StringBuilder template = new StringBuilder();
        try (InputStream ins = SvmMain.class.getResourceAsStream(target);){
            int c;
            while ((c = ins.read()) >= 0) {
                template.append((char)c);
            }
        }
        catch (IOException ioex) {
            ps.println("Failed to load auxiliary template " + ioex.getMessage());
            return false;
        }
        String tempStr = template.toString();
        int lenPrefix = tempStr.indexOf("<SRS>");
        int startPostfix = tempStr.indexOf("</SRS>");
        String prefix = tempStr.substring(0, lenPrefix + 5);
        String postfix = tempStr.substring(startPostfix, tempStr.length());
        template = new StringBuilder();
        template.append(prefix);
        template.append(data.getShapefilePrjContent());
        template.append(postfix);
        File parent = file.getParentFile();
        String name = file.getName() + ".aux.xml";
        File output = new File(parent, name);
        if (output.exists()) {
            output.delete();
        }
        try {
            fos = new FileOutputStream(output);
            try {
                bos = new BufferedOutputStream(fos);
                try {
                    byte[] b = template.toString().getBytes(StandardCharsets.ISO_8859_1);
                    bos.write(b);
                    bos.flush();
                }
                finally {
                    bos.close();
                }
            }
            finally {
                fos.close();
            }
        }
        catch (IOException ioex) {
            ps.println("Serious error: unable to write auxiliary file " + output.getPath() + ": " + ioex.getMessage());
            return false;
        }
        name = file.getName() + ".prj";
        output = new File(parent, name);
        if (output.exists()) {
            output.delete();
        }
        try {
            fos = new FileOutputStream(output);
            try {
                bos = new BufferedOutputStream(fos);
                try {
                    String prjString = data.getShapefilePrjContent();
                    byte[] b = prjString.getBytes(StandardCharsets.ISO_8859_1);
                    bos.write(b);
                    bos.flush();
                }
                finally {
                    bos.close();
                }
            }
            finally {
                fos.close();
            }
        }
        catch (IOException ioex) {
            ps.println("Serious error: unable to write .prj file: " + output.getPath() + ": " + ioex.getMessage());
            return false;
        }
        return true;
    }
}

