/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.svm;

import java.io.PrintStream;
import java.util.BitSet;
import java.util.Iterator;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;
import org.tinfour.svm.properties.SvmProperties;

class SvmSinglePointAnomalyFilter {
    private static final double DEFAULT_SLOPE_OF_ANOMALY = 0.5;
    private static final double DEFAULT_SLOPE_OF_SUPPORT = 0.015;
    private final double slopeOfAnomaly;
    private final double slopeOfSupport;

    SvmSinglePointAnomalyFilter(SvmProperties properties) {
        this.slopeOfAnomaly = properties.getExperimentalFilterSlopeOfAnomaly(0.5);
        this.slopeOfSupport = properties.getExperimentalFilterSlopeOfSupport(0.015);
    }

    int process(PrintStream ps, IIncrementalTin tin) {
        int maxEdgeIndex = tin.getMaximumEdgeAllocationIndex();
        BitSet edgeSet = new BitSet(maxEdgeIndex);
        for (IQuadEdge edge : tin.getPerimeter()) {
            int baseIndex = edge.getBaseIndex();
            edgeSet.set(baseIndex);
            edgeSet.set(baseIndex | 1);
        }
        double mCutOff = this.slopeOfSupport;
        double mReject = this.slopeOfAnomaly;
        double mMax = 0.0;
        int nNegReject = 0;
        int nPosReject = 0;
        Iterator<IQuadEdge> iterator = tin.edges().iterator();
        while (iterator.hasNext()) {
            IQuadEdge qEdge;
            IQuadEdge edge = qEdge = iterator.next();
            int iEdge = 0;
            while (iEdge < 2) {
                int eIndex = edge.getIndex();
                if (!edgeSet.get(eIndex)) {
                    edgeSet.set(eIndex);
                    Vertex a = edge.getA();
                    if (!a.isConstraintMember()) {
                        double aZ = a.getZ();
                        int nPos = 0;
                        int nNeg = 0;
                        int n = 0;
                        double m = 0.0;
                        int nSupport = 0;
                        for (IQuadEdge e : edge.pinwheel()) {
                            edgeSet.set(e.getIndex());
                            Vertex b = edge.getB();
                            double bZ = b.getZ();
                            double d = e.getLength();
                            double mZ = (bZ - aZ) / d;
                            if (mZ > 0.0) {
                                ++nPos;
                            } else {
                                ++nNeg;
                            }
                            double mAbs = Math.abs(mZ);
                            m += mAbs;
                            if (mAbs < mCutOff) {
                                ++nSupport;
                            }
                            ++n;
                            if (!(mAbs > mMax)) continue;
                            mMax = mAbs;
                        }
                        if (nSupport == 0 && nPos > 0 && nNeg == 0 && (m /= (double)n) > mReject) {
                            a.setWithheld(true);
                            ++nPosReject;
                        }
                        if (nSupport == 0 && nPos == 0 && nNeg > 0 && (m /= (double)n) > mReject) {
                            a.setWithheld(true);
                            ++nNegReject;
                        }
                    }
                }
                ++iEdge;
                edge = edge.getDual();
            }
        }
        ps.println("Single-point Anomaly Filter Rejected " + (nPosReject + nNegReject) + " soundings");
        ps.format("  Pos: %8d%n", nPosReject);
        ps.format("  Neg: %8d%n", nNegReject);
        return nPosReject + nNegReject;
    }

    double getSlopeOfAnomaly() {
        return this.slopeOfAnomaly;
    }

    double getSlopeOfSupport() {
        return this.slopeOfSupport;
    }
}

