/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.svm;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.tinfour.common.GeometricOperations;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.PolygonConstraint;
import org.tinfour.common.Thresholds;
import org.tinfour.common.Vertex;
import org.tinfour.svm.properties.SvmProperties;
import org.tinfour.utils.KahanSummation;

class SvmTriangleVolumeTabulator {
    private final double shoreReferenceElevation;
    boolean[] water;
    private final GeometricOperations geoOp;
    int nTriangles;
    int nFlatTriangles;
    KahanSummation flatAreaSum = new KahanSummation();
    KahanSummation depthAreaSum = new KahanSummation();
    KahanSummation depthAreaWeightedSum = new KahanSummation();
    private double maxArea = 0.0;
    final AreaVolumeSum[] avSumArray;

    SvmTriangleVolumeTabulator(IIncrementalTin tin, double shoreReferenceElevation, double[] zArray) {
        Thresholds thresholds = tin.getThresholds();
        this.geoOp = new GeometricOperations(thresholds);
        this.shoreReferenceElevation = shoreReferenceElevation;
        List<IConstraint> constraintsFromTin = tin.getConstraints();
        this.water = new boolean[constraintsFromTin.size()];
        for (IConstraint con : constraintsFromTin) {
            this.water[con.getConstraintIndex()] = (Boolean)con.getApplicationData();
        }
        this.avSumArray = new AreaVolumeSum[zArray.length];
        for (int i = 0; i < zArray.length; ++i) {
            this.avSumArray[i] = new AreaVolumeSum(zArray[i]);
        }
    }

    void addTriangle(Vertex a, Vertex b, Vertex c) {
        Vertex v2;
        Vertex v1;
        Vertex v0;
        ++this.nTriangles;
        double aZ = a.getZ();
        double bZ = b.getZ();
        double cZ = c.getZ();
        if (aZ <= bZ) {
            if (aZ <= cZ) {
                v0 = a;
                v1 = b;
                v2 = c;
            } else {
                v0 = c;
                v1 = a;
                v2 = b;
            }
        } else if (bZ <= cZ) {
            v0 = b;
            v1 = c;
            v2 = a;
        } else {
            v0 = c;
            v1 = b;
            v2 = a;
        }
        if (v2.getZ() < v1.getZ()) {
            Vertex swap = v1;
            v1 = v2;
            v2 = swap;
        }
        double x0 = v0.getX();
        double y0 = v0.getY();
        double z0 = v0.getZ();
        double x1 = v1.getX();
        double y1 = v1.getY();
        double z1 = v1.getZ();
        double x2 = v2.getX();
        double y2 = v2.getY();
        double z2 = v2.getZ();
        assert (z0 <= z1 && z1 <= z2) : "vertex ordering failure";
        double zPartialMean = (2.0 * z2 - z1 - z0) / 3.0;
        double area = Math.abs(this.geoOp.area(v0, v1, v2));
        double partialVolume = area * zPartialMean;
        if (area > this.maxArea) {
            this.maxArea = area;
        }
        if (this.nEqual(aZ, this.shoreReferenceElevation) && this.nEqual(bZ, this.shoreReferenceElevation) && this.nEqual(cZ, this.shoreReferenceElevation)) {
            ++this.nFlatTriangles;
            this.flatAreaSum.add(area);
        } else if (aZ < this.shoreReferenceElevation || bZ < this.shoreReferenceElevation || cZ < this.shoreReferenceElevation) {
            this.depthAreaSum.add(area);
            double deltaZ = this.shoreReferenceElevation - (aZ + bZ + cZ) / 3.0;
            this.depthAreaWeightedSum.add(area * deltaZ);
        }
        for (int i = 0; i < this.avSumArray.length; ++i) {
            double bY;
            double bX;
            double aY;
            double aX;
            AreaVolumeSum avc = this.avSumArray[i];
            double z = avc.level;
            if (z <= z0) {
                if (z != z0 || z0 != z1 || z1 != z2) continue;
                avc.addTriangleArea(area);
                continue;
            }
            if (z >= z2) {
                double v = partialVolume + area * (z - z2);
                avc.addTriangleResult(area, v);
                continue;
            }
            if (z > z1) {
                aX = this.interp(z, z0, z2, x0, x2);
                aY = this.interp(z, z0, z2, y0, y2);
                bX = this.interp(z, z1, z2, x1, x2);
                bY = this.interp(z, z1, z2, y1, y2);
                double dryTrigArea = Math.abs(this.geoOp.area(aX, aY, bX, bY, x2, y2));
                double dryTrigVolume = dryTrigArea * (2.0 * (z2 - z)) / 3.0;
                double dryPolyArea = area - dryTrigArea;
                double dryPolyVolume = dryPolyArea * (z2 - z);
                double v = partialVolume - dryTrigVolume - dryPolyVolume;
                avc.addTriangleResult(area - dryTrigArea, v);
                continue;
            }
            aX = this.interp(z, z0, z1, x0, x1);
            aY = this.interp(z, z0, z1, y0, y1);
            bX = this.interp(z, z0, z2, x0, x2);
            bY = this.interp(z, z0, z2, y0, y2);
            double absArea = Math.abs(this.geoOp.area(aX, aY, bX, bY, x0, y0));
            double v = absArea * (z - z0) / 3.0;
            avc.addTriangleResult(absArea, v);
        }
    }

    private double interp(double z, double z0, double z1, double c0, double c1) {
        return (c0 * (z1 - z) + c1 * (z - z0)) / (z1 - z0);
    }

    int getTriangleCount() {
        return this.nTriangles;
    }

    private boolean nEqual(double a, double b) {
        return Math.abs(a - b) < 1.0E-5;
    }

    double getVolume() {
        return Math.abs(this.avSumArray[0].volumeSum.getSum());
    }

    double getSurfaceArea() {
        return this.avSumArray[0].areaSum.getSum();
    }

    double getFlatArea() {
        return this.flatAreaSum.getSum();
    }

    double getAdjustedMeanDepth() {
        return this.depthAreaWeightedSum.getSum() / this.depthAreaSum.getSum();
    }

    void summarize(SvmProperties properties, PrintStream ps) {
        double areaFactor = properties.getUnitOfArea().getScaleFactor();
        double volumeFactor = properties.getUnitOfVolume().getScaleFactor();
        for (int i = 0; i < this.avSumArray.length; ++i) {
            AreaVolumeSum a = this.avSumArray[i];
            ps.format("%3d   %12.3f   %8d  %12.3f  %12.3f%n", i, a.level, a.areaSum.getSummandCount(), a.areaSum.getSum() / areaFactor, a.volumeSum.getSum() / volumeFactor);
            if (a.volumeSum.getSum() == 0.0) break;
        }
    }

    void process(IIncrementalTin tin) {
        BitSet visited = new BitSet(tin.getMaximumEdgeAllocationIndex());
        Iterator<IQuadEdge> iterator = tin.edges().iterator();
        while (iterator.hasNext()) {
            IQuadEdge testEdge;
            IQuadEdge edge = testEdge = iterator.next();
            for (int i = 0; i < 2; ++i) {
                int eIndex = edge.getIndex();
                if (!visited.get(eIndex)) {
                    visited.set(eIndex);
                    IQuadEdge forward = edge.getForward();
                    IQuadEdge reverse = edge.getReverse();
                    visited.set(forward.getIndex());
                    visited.set(reverse.getIndex());
                    Vertex A = edge.getA();
                    Vertex B = edge.getB();
                    Vertex C = forward.getB();
                    IConstraint constraint = tin.getRegionConstraint(edge);
                    Boolean appData = Boolean.FALSE;
                    if (constraint instanceof PolygonConstraint) {
                        appData = (Boolean)constraint.getApplicationData();
                    }
                    if (appData.booleanValue()) {
                        if (edge.isConstrainedRegionBorder()) {
                            if (C != null) {
                                double vx = B.getX() - A.getX();
                                double vy = B.getY() - A.getY();
                                double cx = C.getX() - A.getX();
                                double cy = C.getY() - A.getY();
                                double s = vx * cy - vy * cx;
                                if (s > 0.0) {
                                    this.addTriangle(A, B, C);
                                }
                            }
                        } else if (edge.isConstrainedRegionInterior()) {
                            this.addTriangle(A, B, C);
                        }
                    }
                }
                edge = testEdge.getDual();
            }
        }
    }

    List<AreaVolumeSum> getResults() {
        ArrayList<AreaVolumeSum> resultList = new ArrayList<AreaVolumeSum>();
        for (AreaVolumeSum avSum : this.avSumArray) {
            resultList.add(avSum);
            if (avSum.getVolume() == 0.0) break;
        }
        return resultList;
    }

    static class AreaVolumeSum {
        final double level;
        final KahanSummation areaSum = new KahanSummation();
        final KahanSummation volumeSum = new KahanSummation();

        AreaVolumeSum(double z) {
            this.level = z;
        }

        void addTriangleResult(double area, double volume) {
            this.areaSum.add(area);
            this.volumeSum.add(volume);
        }

        void addTriangleArea(double area) {
            this.areaSum.add(area);
        }

        double getVolume() {
            return this.volumeSum.getSum();
        }

        double getArea() {
            return this.areaSum.getSum();
        }
    }
}

