/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.svm.properties;

import org.tinfour.utils.loaders.CoordinatePair;
import org.tinfour.utils.loaders.ICoordinateTransform;

class SvmHorizontalTransform
implements ICoordinateTransform {
    final double scale;
    final double offset;

    SvmHorizontalTransform(double scale, double offset) {
        this.scale = scale;
        this.offset = offset;
    }

    @Override
    public boolean forward(double xSource, double ySource, CoordinatePair transformedCoordinates) {
        transformedCoordinates.x = xSource * this.scale + this.offset;
        transformedCoordinates.y = ySource * this.scale + this.offset;
        return true;
    }

    @Override
    public boolean inverse(double xTransformed, double yTransformed, CoordinatePair sourceCoordinates) {
        sourceCoordinates.x = (xTransformed - this.offset) / this.scale;
        sourceCoordinates.y = (yTransformed - this.offset) / this.scale;
        return true;
    }
}

