/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.svm.properties;

import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.tinfour.svm.SvmBathymetryModel;
import org.tinfour.svm.properties.SvmFileSpecification;
import org.tinfour.svm.properties.SvmHorizontalTransform;
import org.tinfour.svm.properties.SvmUnitSpecification;
import org.tinfour.utils.loaders.ICoordinateTransform;

public class SvmProperties {
    private static final String bathymetryModelKey = "bathymetryModel";
    private static final String unitOfDistanceKey = "unitOfDistance";
    private static final String unitOfAreaKey = "unitOfArea";
    private static final String unitOfVolumeKey = "unitOfVolume";
    private static final String reportKey = "report";
    private static final String shorelineReferenceElevationKey = "shorelineReferenceElevation";
    private static final String tableKey = "table";
    private static final String tableIntervalKey = "tableInterval";
    private static final String flatFixerKey = "remediateFlatTriangles";
    private static final String inputFolderKey = "inputFolder";
    private static final String outputFolderKey = "outputFolder";
    private static final String gridFileName = "rasterFileName";
    private static final String gridCellSize = "rasterCellSize";
    private static final String gridImageFileName = "rasterImageFileName";
    private static final String rasterGeoTiffFileName = "rasterGeoTiffFileName";
    private static final String rasterGeoTiffProjectionCode = "rasterGeoTiffProjectionCode";
    private static final String rasterGeoTiffNoDataCode = "rasterGeoTiffNoDataCode";
    private static final String rasterGeoTiffDataCompression = "rasterGeoTiffDataCompression";
    private static final String supplementalConstraintsFileKey = "supplementalConstraints";
    private static final String capacityGraphFileKey = "capacityGraphFileName";
    private static final String capacityGraphSizeKey = "capacityGraphSize";
    private static final String capacityGraphTitleKey = "capacityGraphTitle";
    private static final String drawdownGraphFileKey = "drawdownGraphFileName";
    private static final String drawdownGraphSizeKey = "drawdownGraphSize";
    private static final String drawdownGraphTitleKey = "drawdownGraphTitle";
    private static final String contourGraphFileKey = "contourGraphFileName";
    private static final String contourGraphSizeKey = "contourGraphSize";
    private static final String contourGraphLegendTextKey = "contourGraphLegendText";
    private static final String contourGraphIntervalKey = "contourGraphInterval";
    private static final String contourGraphSmoothingFactorKey = "contourGraphSmoothingFactor";
    private static final String contourRegionShapefileKey = "contourRegionShapefile";
    private static final String contourLineShapefileKey = "contourLineShapefile";
    private static final String contourShapefileShorelineEnabledKey = "contourShapefileShorelineEnabled";
    private static final String anomalyTableFileKey = "anomalyTableFileName";
    private static final String experimentalFilterKey = "experimentalFilter";
    private static final String experimentalFilterFileKey = "experimentalFilterFileName";
    private static final String experimentalFilterSlopeOfAnomalyKey = "experimentalFilterSlopeOfAnomaly";
    private static final String experimentalFilterSlopeOfSupportKey = "experimentalFilterSlopeOfSupport";
    private static final String horizontalTransformKey = "horizontalTransform";
    final Properties properties = new Properties();
    final List<String> keyList = new ArrayList<String>();
    private File specificationFile;
    private SvmUnitSpecification unitOfDistance = new SvmUnitSpecification("Distance", "m", 1.0);
    private SvmUnitSpecification unitOfArea = new SvmUnitSpecification("Area", "m^2", 1.0);
    private SvmUnitSpecification unitOfVolume = new SvmUnitSpecification("Volume", "m^3", 1.0);
    private Locale explicitLocale;
    private boolean usesCommaForDecimal;

    public SvmProperties() {
        String qf = String.format("%f", 3.14);
        if (qf.indexOf(44) > 0) {
            this.usesCommaForDecimal = true;
        }
    }

    public static int indexArg(String[] args, String target, boolean valueRequired) {
        if (args == null || target == null || target.isEmpty()) {
            return -1;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!target.equalsIgnoreCase(args[i])) continue;
            if (valueRequired) {
                if (i == args.length - 1 || args[i + 1].isEmpty()) {
                    throw new IllegalArgumentException("Missing value for option " + target);
                }
                String s = args[i + 1];
                if (s.charAt(0) == '-' && s.length() > 1 && !Character.isDigit(s.charAt(1))) {
                    throw new IllegalArgumentException("Missing value for option " + target);
                }
            }
            return i;
        }
        return -1;
    }

    private static String findArgString(String[] args, String target) {
        int index = SvmProperties.indexArg(args, target, true);
        if (index >= 0) {
            return args[index + 1];
        }
        return null;
    }

    public static SvmProperties load(String[] args) throws IOException {
        String s = SvmProperties.findArgString(args, "-properties");
        if (s == null) {
            String test;
            int i;
            if (args.length == 1 && (i = (test = args[0].toLowerCase()).lastIndexOf(".properties")) == test.length() - 11) {
                s = args[0];
            }
            if (s == null) {
                throw new IllegalArgumentException("Missing properties file specification");
            }
        }
        File file = new File(s);
        SvmProperties p = new SvmProperties();
        p.load(file);
        return p;
    }

    private void checkForLocaleSettings() throws IOException {
        String q = this.properties.getProperty("Locale");
        if (q == null) {
            q = this.properties.getProperty("locale");
        }
        if (q != null) {
            try {
                Locale locale = Locale.forLanguageTag(q);
                if (locale == null) {
                    throw new IOException("Unrecognized specification for Locale, \"" + q + "\"");
                }
                Locale.setDefault(locale);
                this.explicitLocale = locale;
                String qf = String.format("%f", 3.14);
                if (qf.indexOf(44) > 0) {
                    this.usesCommaForDecimal = true;
                }
            }
            catch (RuntimeException rex) {
                throw new IOException("Invalid specification for Locale, \"" + q + "\"");
            }
        }
    }

    public void load(File file) throws IOException {
        this.specificationFile = file;
        try (FileInputStream fins = new FileInputStream(file);
             BufferedInputStream bins = new BufferedInputStream(fins);){
            this.properties.load(bins);
        }
        this.checkForLocaleSettings();
        Set<String> nset = this.properties.stringPropertyNames();
        for (String s : nset) {
            this.keyList.add(s);
        }
        Collections.sort(this.keyList);
        this.unitOfDistance = this.extractUnit("Distance", unitOfDistanceKey, this.unitOfDistance);
        this.unitOfArea = this.extractUnit("Area", unitOfAreaKey, this.getUnitOfArea());
        this.unitOfVolume = this.extractUnit("Volume", unitOfVolumeKey, this.getUnitOfVolume());
    }

    public Locale getExplicitLocale() {
        return this.explicitLocale;
    }

    public boolean doesLocaleUseCommaForDecimal() {
        return this.usesCommaForDecimal;
    }

    public List<SvmFileSpecification> getSampleSpecifications() {
        return this.getTargetSpecifications("samples");
    }

    public List<SvmFileSpecification> getSupplementSpecifications() {
        return this.getTargetSpecifications("supplement");
    }

    public List<SvmFileSpecification> getBoundarySpecifications() {
        return this.getTargetSpecifications("bounds");
    }

    public SvmUnitSpecification getUnitOfDistance() {
        return this.unitOfDistance;
    }

    private SvmUnitSpecification extractUnit(String name, String key, SvmUnitSpecification defaultUnit) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            return defaultUnit;
        }
        List<String> splitList = this.split(value);
        if (splitList.isEmpty()) {
            throw new IllegalArgumentException("Missing specification for " + key);
        }
        String label = splitList.get(0);
        double scaleFactor = 1.0;
        if (splitList.size() > 1) {
            try {
                scaleFactor = Double.parseDouble(splitList.get(1));
            }
            catch (NumberFormatException nex) {
                throw new IllegalArgumentException("Invalid specification for " + key);
            }
            if (scaleFactor == 0.0) {
                throw new IllegalArgumentException("Zero scaling factor not allowed for " + key);
            }
        }
        return new SvmUnitSpecification(name, label, scaleFactor);
    }

    private File extractFile(String folderKey, String fileProperty) {
        if (fileProperty == null) {
            return null;
        }
        String property = fileProperty.trim();
        if (property.isEmpty()) {
            return null;
        }
        File f = new File(property);
        File folder = this.getFolderForKey(folderKey);
        if (folder != null && !f.isAbsolute()) {
            return new File(folder, property);
        }
        return f;
    }

    private File extractOutputFile(String folderKey, String fileProperty) {
        boolean status;
        File parent;
        if (fileProperty == null) {
            return null;
        }
        String property = fileProperty.trim();
        if (property.isEmpty()) {
            return null;
        }
        File f = new File(property);
        File folder = this.getFolderForKey(folderKey);
        if (folder != null && !f.isAbsolute()) {
            f = new File(folder, property);
        }
        if ((parent = f.getParentFile()) != null && !parent.exists() && !(status = parent.mkdirs())) {
            throw new IllegalArgumentException("Unable to create file for property " + property + "=" + f.getPath());
        }
        return f;
    }

    private List<SvmFileSpecification> getTargetSpecifications(String target) {
        SvmBathymetryModel model = this.getBathymetryModel();
        File folder = this.getInputFolder();
        ArrayList<SvmFileSpecification> specList = new ArrayList<SvmFileSpecification>();
        for (String key : this.keyList) {
            if (!key.startsWith(target) || key.contains(supplementalConstraintsFileKey)) continue;
            String value = this.properties.getProperty(key);
            List<String> splitList = this.split(value);
            specList.add(new SvmFileSpecification(key, model, splitList, folder));
        }
        return specList;
    }

    private List<String> split(String value) {
        ArrayList<String> splitList = new ArrayList<String>();
        if (value == null || value.isEmpty()) {
            return splitList;
        }
        StringBuilder sb = new StringBuilder();
        boolean spacePending = false;
        boolean spaceEnable = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isWhitespace(c)) {
                if (spaceEnable) {
                    spacePending = true;
                }
                spaceEnable = false;
                continue;
            }
            if (c == '|') {
                String s = sb.toString();
                sb.setLength(0);
                splitList.add(s);
                spaceEnable = false;
                spacePending = false;
                continue;
            }
            if (spacePending) {
                sb.append(' ');
                spacePending = false;
            }
            spaceEnable = true;
            sb.append(c);
        }
        if (sb.length() > 0) {
            splitList.add(sb.toString());
        }
        return splitList;
    }

    public File getInputFolder() {
        return this.getFolderForKey(inputFolderKey);
    }

    public File getOutputFolder() {
        return this.getFolderForKey(outputFolderKey);
    }

    private File getFolderForKey(String key) {
        String s = this.properties.getProperty(key);
        if (s == null) {
            return null;
        }
        return new File(s);
    }

    public File getReportFile() {
        return this.extractOutputFile(outputFolderKey, this.properties.getProperty(reportKey));
    }

    public File getTableFile() {
        return this.extractOutputFile(outputFolderKey, this.properties.getProperty(tableKey));
    }

    public double getTableInterval() {
        String s = this.properties.getProperty(tableIntervalKey, "1.0");
        try {
            double d = Double.parseDouble(s);
            if (d <= 0.0) {
                throw new IllegalArgumentException("Invalid value for table interval: " + s);
            }
            return d;
        }
        catch (NumberFormatException nex) {
            throw new IllegalArgumentException("Invalid numeric for table interval: " + s);
        }
    }

    public boolean isFlatFixerEnabled() {
        String s = this.properties.getProperty(flatFixerKey, "false");
        boolean test = Boolean.parseBoolean(s.trim());
        return test;
    }

    private int findMaxNameLength(int m0, List<SvmFileSpecification> samples) {
        int m = m0;
        for (SvmFileSpecification sample : samples) {
            String path = sample.file.getName();
            if (path.length() <= m) continue;
            m = path.length();
        }
        return m;
    }

    private void writeFileList(PrintStream ps, List<SvmFileSpecification> samples, String nameFmt) {
        if (samples.size() == 0) {
            ps.println("   None");
        } else {
            for (int i = 0; i < samples.size(); ++i) {
                SvmFileSpecification sample = samples.get(i);
                String name = sample.file.getName();
                ps.format(nameFmt, i + 1, name);
                if (sample.field == null) {
                    ps.format("%n", new Object[0]);
                    continue;
                }
                ps.format("   (%s)%n", sample.field);
            }
        }
    }

    private void writeUnit(PrintStream ps, String name, SvmUnitSpecification s) {
        double f = s.getScaleFactor();
        String fStr = "";
        if (f != 1.0) {
            fStr = f - Math.floor(1.0E-5) == 0.0 ? String.format("   %8d", (long)f) : String.format("   %11.3f", f);
        }
        ps.format("   %-12s%-12s%s%n", name, s.getLabel(), fStr);
    }

    public void writeSummary(PrintStream ps) {
        SvmBathymetryModel model;
        ps.format("Specifications for processing%n", new Object[0]);
        if (this.specificationFile != null) {
            ps.format("Properties file: %s%n", this.specificationFile.getPath());
        }
        if ((model = this.getBathymetryModel()) == null) {
            ps.format("Bathymetry model is not specified, no processing is possible", new Object[0]);
        } else {
            ps.format("%nBathymetry model: %s%n%n", model.name());
        }
        File f = this.getInputFolder();
        ps.format("Input folder:   %s%n", f == null ? "Not specified" : f.getPath());
        f = this.getOutputFolder();
        ps.format("Output folder:  %s%n", f == null ? "Not specified" : f.getPath());
        ps.format("%n", new Object[0]);
        List<SvmFileSpecification> samples = this.getSampleSpecifications();
        List<SvmFileSpecification> bounds = this.getBoundarySpecifications();
        List<SvmFileSpecification> supplements = this.getSupplementSpecifications();
        int m = this.findMaxNameLength(0, samples);
        m = this.findMaxNameLength(m, bounds);
        String nameFmt = "   %2d. %-" + m + "s";
        ps.format("Sample Files:%n", new Object[0]);
        this.writeFileList(ps, samples, nameFmt);
        ps.format("Boundry Files:%n", new Object[0]);
        this.writeFileList(ps, bounds, nameFmt);
        ps.format("Supplemental Sample Files:%n", new Object[0]);
        this.writeFileList(ps, supplements, nameFmt);
        ps.format("%nUnits of Measure%n", new Object[0]);
        this.writeUnit(ps, "Distance", this.unitOfDistance);
        this.writeUnit(ps, "Area:", this.getUnitOfArea());
        this.writeUnit(ps, "Volume:", this.getUnitOfVolume());
        ps.println("");
        String s = this.properties.getProperty(reportKey);
        ps.format("Report:                   %s%n", s == null || s.isEmpty() ? "None" : s);
        s = this.properties.getProperty(tableKey);
        ps.format("Table output:             %s%n", s == null || s.isEmpty() ? "None" : s);
        if (s != null && !s.isEmpty()) {
            ps.format("Table interval:           %4.2f%n", this.getTableInterval());
        }
        s = this.properties.getProperty(shorelineReferenceElevationKey);
        ps.format("Shoreline Elevation:      ", new Object[0]);
        if (s == null || s.isEmpty()) {
            ps.format("To be obtained from boundary data", new Object[0]);
        } else {
            ps.format("Explicitly specified as " + s, new Object[0]);
        }
        ps.format("%n", new Object[0]);
        boolean fixFlats = this.isFlatFixerEnabled();
        ps.format("Remediate Flat Triangles: %s%n", Boolean.toString(fixFlats));
    }

    public SvmUnitSpecification getUnitOfArea() {
        return this.unitOfArea;
    }

    public SvmUnitSpecification getUnitOfVolume() {
        return this.unitOfVolume;
    }

    public double getShorelineReferenceElevation() {
        String s = this.properties.getProperty(shorelineReferenceElevationKey);
        if (s == null) {
            return Double.NaN;
        }
        if ((s = s.trim()).isEmpty()) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException nex) {
            throw new IllegalArgumentException("Invalid numeric for shoreline reference elevation: " + s);
        }
    }

    public double getGridCellSize() {
        String s = this.properties.getProperty(gridCellSize);
        if (s == null) {
            return Double.NaN;
        }
        if ((s = s.trim()).isEmpty()) {
            return Double.NaN;
        }
        try {
            double d = Double.parseDouble(s);
            if (d <= 0.0) {
                throw new IllegalArgumentException("Invalid value for grid cell size: " + s);
            }
            return d;
        }
        catch (NumberFormatException nex) {
            throw new IllegalArgumentException("Invalid numeric for gridCellSize: " + s);
        }
    }

    public File getGridFile() {
        return this.extractOutputFile(outputFolderKey, this.properties.getProperty(gridFileName));
    }

    public File getGridImageFile() {
        return this.extractOutputFile(outputFolderKey, this.properties.getProperty(gridImageFileName));
    }

    public File getGeoTiffFile() {
        return this.extractOutputFile(outputFolderKey, this.properties.getProperty(rasterGeoTiffFileName));
    }

    public File getSupplementalConstraintsFile() {
        return this.extractFile(inputFolderKey, this.properties.getProperty(supplementalConstraintsFileKey));
    }

    public File getGridFile(String extension) {
        String rootName = this.properties.getProperty(gridFileName);
        if (rootName == null) {
            return null;
        }
        String targetName = rootName + extension;
        return this.extractOutputFile(outputFolderKey, targetName);
    }

    public boolean isCapacityGraphEnabled() {
        return this.properties.containsKey(capacityGraphFileKey);
    }

    public File getCapacityGraphFile() {
        if (this.properties.containsKey(capacityGraphFileKey)) {
            return this.extractOutputFile(outputFolderKey, this.properties.getProperty(capacityGraphFileKey));
        }
        return null;
    }

    public Dimension getCapacityGraphDimensions() {
        return this.extractDimension(capacityGraphSizeKey, 650, 400);
    }

    public String getCapacityGraphTitle() {
        String s = this.properties.getProperty(capacityGraphTitleKey);
        if (s == null || s.trim().isEmpty()) {
            return null;
        }
        return s.trim();
    }

    public boolean isDrawdownGraphEnabled() {
        return this.properties.containsKey(drawdownGraphFileKey);
    }

    public File getDrawdownGraphFile() {
        if (this.properties.containsKey(drawdownGraphFileKey)) {
            return this.extractOutputFile(outputFolderKey, this.properties.getProperty(drawdownGraphFileKey));
        }
        return null;
    }

    public Dimension getDrawdownGraphDimensions() {
        return this.extractDimension(drawdownGraphSizeKey, 650, 400);
    }

    public String getDrawdownGraphTitle() {
        String s = this.properties.getProperty(drawdownGraphTitleKey);
        if (s == null || s.trim().isEmpty()) {
            return null;
        }
        return s.trim();
    }

    public File getContourGraphFile() {
        if (this.properties.containsKey(contourGraphFileKey)) {
            return this.extractOutputFile(outputFolderKey, this.properties.getProperty(contourGraphFileKey));
        }
        return null;
    }

    public File getContourRegionShapefile() {
        if (this.properties.containsKey(contourRegionShapefileKey)) {
            return this.extractFile(outputFolderKey, this.properties.getProperty(contourRegionShapefileKey));
        }
        return null;
    }

    public File getContourLineShapefile() {
        if (this.properties.containsKey(contourLineShapefileKey)) {
            return this.extractFile(outputFolderKey, this.properties.getProperty(contourLineShapefileKey));
        }
        return null;
    }

    public boolean isContourShapefileShorelineEnabled() {
        if (this.properties.containsKey(contourShapefileShorelineEnabledKey)) {
            String s = this.properties.getProperty(contourShapefileShorelineEnabledKey);
            return s.toLowerCase().startsWith("t");
        }
        return false;
    }

    public Dimension getContourGraphDimensions() {
        return this.extractDimension(contourGraphSizeKey, 650, 650);
    }

    public String getContourGraphLegendText() {
        String s = this.properties.getProperty(contourGraphLegendTextKey);
        if (s == null || s.trim().isEmpty()) {
            return "Legend";
        }
        return s.trim();
    }

    public double getContourGraphInterval() {
        String s = this.properties.getProperty(contourGraphIntervalKey);
        if (s == null || s.trim().isEmpty()) {
            return 0.0;
        }
        if ("automatic".equalsIgnoreCase(s = s.trim())) {
            return 0.0;
        }
        try {
            double d = Double.parseDouble(s);
            if (d <= 0.0) {
                return 0.0;
            }
            return d;
        }
        catch (NumberFormatException nfe) {
            return 0.0;
        }
    }

    private Dimension extractDimension(String key, int width, int height) {
        String s = this.properties.getProperty(key);
        if (s == null) {
            return new Dimension(width, height);
        }
        int[] values = new int[2];
        int nNumeric = 0;
        int value = 0;
        boolean numeric = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isDigit(c)) {
                if (!numeric) {
                    value = 0;
                    numeric = true;
                }
                value = value * 10 + (c - 48);
                continue;
            }
            if (!numeric) continue;
            numeric = false;
            values[nNumeric++] = value;
            if (nNumeric != 2) continue;
            return new Dimension(values[0], values[1]);
        }
        if (numeric) {
            values[nNumeric++] = value;
            if (nNumeric == 2) {
                return new Dimension(values[0], values[1]);
            }
        }
        throw new IllegalArgumentException("Incomplete specification for dimension: " + key + "=" + s);
    }

    public File getAnomalyTableFile() {
        if (this.properties.containsKey(anomalyTableFileKey)) {
            return this.extractOutputFile(outputFolderKey, this.properties.getProperty(anomalyTableFileKey));
        }
        return null;
    }

    public SvmBathymetryModel getBathymetryModel() {
        String s = this.properties.getProperty(bathymetryModelKey);
        return SvmBathymetryModel.lenientValueOf(s);
    }

    public boolean isBathymetryModelSpecified() {
        String s = this.properties.getProperty(bathymetryModelKey);
        return s != null && !s.trim().isEmpty();
    }

    public boolean isGeoTiffProjectionCodeSpecified() {
        String s = this.properties.getProperty(rasterGeoTiffProjectionCode);
        return s != null && !s.isBlank();
    }

    public int getGeoTiffProjectionCode() {
        String s = this.properties.getProperty(rasterGeoTiffProjectionCode);
        if (s == null || s.isBlank()) {
            return 0;
        }
        try {
            return Integer.parseInt(s.trim());
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public float getGeoTiffNoDataCode() {
        String s = this.properties.getProperty(rasterGeoTiffNoDataCode);
        if (s == null || s.isBlank()) {
            return -1000000.0f;
        }
        try {
            return Float.parseFloat(s.trim());
        }
        catch (NumberFormatException nfe) {
            return -1000000.0f;
        }
    }

    public boolean isGeoTiffNoDataCodeSpecified() {
        String s = this.properties.getProperty(rasterGeoTiffNoDataCode);
        return s != null && !s.isBlank();
    }

    public boolean isGeoTiffDataCompressionEnabled() {
        String s = this.properties.getProperty(rasterGeoTiffDataCompression);
        if (s != null && !s.isBlank()) {
            try {
                return Boolean.parseBoolean(s.trim());
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid boolean specification for GeoTIFF data compression: " + s);
            }
        }
        return false;
    }

    public boolean isExperimentalFilterEnabled() {
        String s = this.properties.getProperty(experimentalFilterKey);
        if (s != null && !s.isBlank()) {
            try {
                return Boolean.parseBoolean(s.trim());
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid boolean specification for experimentalFilter: " + s);
            }
        }
        return false;
    }

    public File getExperimentalFilterFile() {
        if (this.properties.containsKey(experimentalFilterFileKey)) {
            return this.extractOutputFile(outputFolderKey, this.properties.getProperty(experimentalFilterFileKey));
        }
        return null;
    }

    public double getExperimentalFilterSlopeOfAnomaly(double defaultValue) {
        String s = this.properties.getProperty(experimentalFilterSlopeOfAnomalyKey);
        if (s == null || s.isBlank()) {
            return defaultValue;
        }
        try {
            double d = Double.parseDouble(s);
            if (d <= 0.0) {
                throw new IllegalArgumentException("Invalid value for experimental slope anomaly: " + s);
            }
            return d;
        }
        catch (NumberFormatException nex) {
            throw new IllegalArgumentException("Invalid numeric for experimental slope anomaly: " + s);
        }
    }

    public double getExperimentalFilterSlopeOfSupport(double defaultValue) {
        String s = this.properties.getProperty(experimentalFilterSlopeOfSupportKey);
        if (s == null || s.isBlank()) {
            return defaultValue;
        }
        try {
            double d = Double.parseDouble(s);
            if (d <= 0.0) {
                throw new IllegalArgumentException("Invalid value for experimental slope support: " + s);
            }
            return d;
        }
        catch (NumberFormatException nex) {
            throw new IllegalArgumentException("Invalid numeric for experimental slope support: " + s);
        }
    }

    public int getContourGraphSmoothingFactor(int defaultValue) {
        String s = this.properties.getProperty(contourGraphSmoothingFactorKey);
        if (s == null || s.isBlank()) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(s.trim());
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public ICoordinateTransform getHorizontalTransform() {
        String string = this.properties.getProperty(horizontalTransformKey);
        if (string != null && !string.isBlank()) {
            List<String> sList = this.split(string);
            int n = 0;
            double[] d = new double[sList.size()];
            for (String s : sList) {
                try {
                    d[n++] = Double.parseDouble(s);
                }
                catch (NumberFormatException nex) {
                    throw new IllegalArgumentException("Invalid entry where numeric expected for " + string.trim());
                }
            }
            if (n == 0) {
                return null;
            }
            if (n == 1) {
                return new SvmHorizontalTransform(d[0], 0.0);
            }
            if (n == 2) {
                return new SvmHorizontalTransform(d[0], d[1]);
            }
            throw new IllegalArgumentException("Too many specifications for " + string.trim());
        }
        return null;
    }
}

